/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cr;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.ctakes.core.util.doc.SourceMetadataUtil;
import org.apache.ctakes.typesystem.type.structured.Demographics;
import org.apache.ctakes.typesystem.type.structured.DocumentID;
import org.apache.ctakes.typesystem.type.structured.DocumentIdPrefix;
import org.apache.ctakes.typesystem.type.structured.DocumentPath;
import org.apache.ctakes.typesystem.type.structured.Metadata;
import org.apache.ctakes.typesystem.type.structured.SourceData;
import org.apache.uima.UIMAException;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.jcas.JCas;

@Deprecated
public final class JCasBuilder {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private static final String UNKNOWN_DATE = "UnknownDate";
    private static final String UNKNOWN_GENDER = "UnknownGender";
    private static final String UNKNOWN = "Unknown";
    private String _institutionId = "Unknown";
    private String _authorSpecialty = "Unknown";
    private String _patientId = "UnknownPatient";
    private long _patientNum = -1L;
    private String _firstName = "Unknown";
    private String _middleName = "Unknown";
    private String _lastName = "Unknown";
    private String _birthday = "UnknownDate";
    private String _deathday = "UnknownDate";
    private String _gender = "UnknownGender";
    private String _instanceId = "";
    private String _encounterId = "";
    private String _docId = "UnknownDocument";
    private String _docIdPrefix = "UnknownDocumentPrefix";
    private String _docType = "ClinicalNote";
    private String _docSubType = "";
    private String _docStandard = "";
    private int _docRevisionNum = 1;
    private String _docTime = "";
    private String _docPath = "";
    private String _docText = "";
    private boolean _overwrite = false;

    public JCasBuilder overwrite() {
        this._overwrite = true;
        return this;
    }

    public JCasBuilder setInstitutionId(String institutionId) {
        this._institutionId = institutionId;
        return this;
    }

    public JCasBuilder setAuthorSpecialty(String authorSpecialty) {
        this._authorSpecialty = authorSpecialty;
        return this;
    }

    public JCasBuilder setPatientId(String patientId) {
        this._patientId = patientId;
        return this;
    }

    public JCasBuilder setPatientNum(long patientNum) {
        this._patientNum = patientNum;
        return this;
    }

    public JCasBuilder setFirstName(String firstName) {
        this._firstName = firstName;
        return this;
    }

    public JCasBuilder setMiddleName(String middleName) {
        this._middleName = middleName;
        return this;
    }

    public JCasBuilder setLastName(String lastName) {
        this._lastName = lastName;
        return this;
    }

    public JCasBuilder setBirthDay(String birthday) {
        this._birthday = birthday;
        return this;
    }

    public JCasBuilder setDeathday(String deathday) {
        this._deathday = deathday;
        return this;
    }

    public JCasBuilder setGender(String gender) {
        this._gender = gender;
        return this;
    }

    public JCasBuilder setInstanceId(String instanceId) {
        this._instanceId = instanceId;
        return this;
    }

    public JCasBuilder setEncounterId(String encounterId) {
        this._encounterId = encounterId;
        return this;
    }

    public JCasBuilder setDocId(String docId) {
        this._docId = docId;
        return this;
    }

    public JCasBuilder setDocIdPrefix(String docIdPrefix) {
        this._docIdPrefix = docIdPrefix;
        return this;
    }

    public JCasBuilder setDocType(String docType) {
        this._docType = docType;
        return this;
    }

    public JCasBuilder setDocSubType(String docSubType) {
        this._docSubType = docSubType;
        return this;
    }

    public JCasBuilder setDocStandard(String docStandard) {
        this._docStandard = docStandard;
        return this;
    }

    public JCasBuilder setDocRevisionNum(int docRevisionNum) {
        this._docRevisionNum = docRevisionNum;
        return this;
    }

    public JCasBuilder setDocTime(String docTime) {
        this._docTime = docTime;
        return this;
    }

    public JCasBuilder setDocPath(String docPath) {
        this._docPath = docPath;
        return this;
    }

    public JCasBuilder setDocText(String docText) {
        this._docText = docText;
        return this;
    }

    public JCas build() throws UIMAException {
        return this.populate(JCasFactory.createJCas());
    }

    public JCas rebuild(JCas jCas) {
        jCas.reset();
        return this.populate(jCas);
    }

    private boolean ifWrite(String value, String defaultValue) {
        return this._overwrite || !value.equals(defaultValue);
    }

    private boolean ifWrite(int value, int defaultValue) {
        return this._overwrite || value != defaultValue;
    }

    private boolean ifWrite(long value, long defaultValue) {
        return this._overwrite || value != defaultValue;
    }

    public JCas populate(JCas jCas) {
        Metadata metadata = SourceMetadataUtil.getOrCreateMetadata(jCas);
        if (this.ifWrite(this._patientId, "UnknownPatient")) {
            SourceMetadataUtil.setPatientIdentifier(jCas, this._patientId);
        }
        if (this.ifWrite(this._patientNum, -1L)) {
            metadata.setPatientID(this._patientNum);
        }
        Demographics demographics = new Demographics(jCas);
        metadata.setDemographics(demographics);
        if (this.ifWrite(this._firstName, UNKNOWN)) {
            demographics.setFirstName(this._firstName);
        }
        if (this.ifWrite(this._middleName, UNKNOWN)) {
            demographics.setMiddleName(this._middleName);
        }
        if (this.ifWrite(this._lastName, UNKNOWN)) {
            demographics.setLastName(this._lastName);
        }
        if (this.ifWrite(this._birthday, UNKNOWN_DATE)) {
            demographics.setBirthDate(this._birthday);
        }
        if (this.ifWrite(this._deathday, UNKNOWN_DATE)) {
            demographics.setDeathDate(this._deathday);
        }
        if (this.ifWrite(this._gender, UNKNOWN_GENDER)) {
            demographics.setGender(this._gender);
        }
        SourceData sourceData = SourceMetadataUtil.getOrCreateSourceData(jCas);
        if (this.ifWrite(this._institutionId, UNKNOWN)) {
            sourceData.setSourceInstitution(this._institutionId);
        }
        if (this.ifWrite(this._authorSpecialty, UNKNOWN)) {
            sourceData.setAuthorSpecialty(this._authorSpecialty);
        }
        if (this.ifWrite(this._encounterId, "")) {
            sourceData.setSourceEncounterId(this._encounterId);
        }
        if (this.ifWrite(this._instanceId, UNKNOWN)) {
            sourceData.setSourceInstanceId(this._instanceId);
        }
        if (this.ifWrite(this._docId, "UnknownDocument")) {
            DocumentID documentId = new DocumentID(jCas);
            documentId.setDocumentID(this._docId);
            documentId.addToIndexes();
        }
        if (this.ifWrite(this._docIdPrefix, "UnknownDocumentPrefix")) {
            DocumentIdPrefix documentIdPrefix = new DocumentIdPrefix(jCas);
            documentIdPrefix.setDocumentIdPrefix(this._docIdPrefix);
            documentIdPrefix.addToIndexes();
        }
        if (this.ifWrite(this._docType, "ClinicalNote")) {
            sourceData.setNoteTypeCode(this._docType);
        }
        if (this.ifWrite(this._docSubType, "")) {
            sourceData.setNoteSubTypeCode(this._docSubType);
        }
        if (this.ifWrite(this._docStandard, "")) {
            sourceData.setDocumentStandard(this._docStandard);
        }
        if (this.ifWrite(this._docTime, "")) {
            sourceData.setSourceRevisionDate(this._docTime);
        }
        if (this.ifWrite(this._docRevisionNum, 1)) {
            sourceData.setSourceRevisionNbr(this._docRevisionNum);
        }
        if (this.ifWrite(this._docPath, "")) {
            DocumentPath documentPath = new DocumentPath(jCas);
            documentPath.setDocumentPath(this._docPath);
            documentPath.addToIndexes();
        }
        if (this.ifWrite(this._docText, "")) {
            jCas.setDocumentText(this._docText);
        }
        return jCas;
    }
}

