/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileResource;
import org.apache.ctakes.core.resource.JdbcConnectionResource;
import org.apache.ctakes.typesystem.type.structured.DocumentID;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

@PipeBitInfo(name="JDBC Reader", description="Reads document texts from database text fields.", role=PipeBitInfo.Role.READER, products={PipeBitInfo.TypeProduct.DOCUMENT_ID})
public class JdbcCollectionReader
extends JCasCollectionReader_ImplBase {
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    public static final String PARAM_SQL = "SqlStatement";
    @ConfigurationParameter(name="SqlStatement", description="SQL statement to retrieve the document.")
    private String _sqlStatement;
    public static final String PARAM_DOCTEXT_COL = "DocTextColName";
    @ConfigurationParameter(name="DocTextColName", description="Name of column from resultset that contains the document text.")
    private String _docTextColName;
    public static final String PARAM_DB_CONN_RESRC = "DbConnResrcName";
    @ConfigurationParameter(name="DbConnResrcName", description="Name of external resource for database connection.")
    String _resrcName;
    public static final String PARAM_DOCID_COLS = "DocIdColNames";
    @ConfigurationParameter(name="DocIdColNames", description="Specifies column names that will be used to form a document ID.", mandatory=false)
    private String[] _docIdColNames;
    public static final String PARAM_DOCID_DELIMITER = "DocIdDelimiter";
    @ConfigurationParameter(name="DocIdDelimiter", description="Specifies delimiter used when document ID is built.", mandatory=false)
    private String _docIdDelimiter = "_";
    public static final String PARAM_VALUE_FILE_RESRC = "ValueFileResrcName";
    @ConfigurationParameter(name="ValueFileResrcName", description="Name of external resource for prepared statement value file.", mandatory=false)
    private String _fileResrcName;
    private PreparedStatement _preparedStatement;
    private ResultSet _resultSet;
    private int _docColType;
    private String _docColTypeName;
    private int _totalRowCount = 0;
    private int _currRowCount = 0;
    private List<String>[] _prepStmtValArr = null;
    private int _prepStmtValArrIdx = 0;
    private boolean _usePrepStmtVals = false;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            JdbcConnectionResource connectionResource = (JdbcConnectionResource)context.getResourceObject(this._resrcName);
            Connection connection = connectionResource.getConnection();
            this._preparedStatement = connection.prepareStatement(this._sqlStatement);
            if (this._fileResrcName != null && !this._fileResrcName.trim().isEmpty()) {
                FileResource fileResrc = (FileResource)this.getUimaContext().getResourceObject(this._fileResrcName);
                if (fileResrc != null) {
                    this.loadValueFile(fileResrc.getFile());
                    this._usePrepStmtVals = true;
                } else {
                    this.logger.error((Object)("Failed to get " + this._fileResrcName + " from ResourceManager"));
                    throw new ResourceInitializationException();
                }
            }
            this._totalRowCount = this.getRowCount(connection, this._sqlStatement);
        }
        catch (IOException | SQLException | ResourceAccessException multE) {
            throw new ResourceInitializationException(multE);
        }
    }

    private void loadValueFile(File valueFile) throws IOException {
        ArrayList<String> lineList = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(valueFile));
        String line = br.readLine();
        while (line != null && line.trim().length() > 0) {
            lineList.add(line);
            line = br.readLine();
        }
        br.close();
        this._prepStmtValArr = new List[lineList.size()];
        for (int i = 0; i < lineList.size(); ++i) {
            String currLine = (String)lineList.get(i);
            ArrayList<String> valList = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(currLine, "\t");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                valList.add(token);
            }
            this._prepStmtValArr[i] = valList;
        }
        this.logger.info((Object)("Loaded " + lineList.size() + " lines from value file: " + valueFile.getAbsolutePath()));
    }

    private int getRowCount(Connection conn, String querySql) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT COUNT(*) ");
        int idx = querySql.toUpperCase().indexOf("FROM");
        sb.append(querySql.subSequence(idx, querySql.length()));
        PreparedStatement cntStmt = conn.prepareStatement(sb.toString());
        if (this._usePrepStmtVals) {
            int totalCnt = 0;
            for (int i = 0; i < this._prepStmtValArr.length; ++i) {
                List<String> valList = this._prepStmtValArr[i];
                this.setPrepStmtValues(cntStmt, valList);
                ResultSet rs = cntStmt.executeQuery();
                rs.next();
                totalCnt += rs.getInt(1);
            }
            return totalCnt;
        }
        ResultSet rs = cntStmt.executeQuery();
        rs.next();
        return rs.getInt(1);
    }

    private void setPrepStmtValues(PreparedStatement prepStmt, List<String> valList) throws SQLException {
        prepStmt.clearParameters();
        for (int i = 0; i < valList.size(); ++i) {
            String valObj = valList.get(i);
            prepStmt.setObject(i + 1, valObj);
        }
    }

    public void getNext(JCas jcas) throws IOException, CollectionException {
        ++this._currRowCount;
        try {
            String document = null;
            if (this._docColType == 1 || this._docColType == 12) {
                document = this._resultSet.getString(this._docTextColName);
            } else if (this._docColType == 2005) {
                document = this.convertToString(this._resultSet.getClob(this._docTextColName));
            } else {
                throw new Exception("Unsupported document text column type: " + this._docColTypeName);
            }
            try {
                jcas.setDocumentText(document);
                DocumentID docIdAnnot = new DocumentID(jcas);
                docIdAnnot.setDocumentID(this.getDocumentID(this._resultSet));
                docIdAnnot.addToIndexes();
                this.logger.info((Object)("Reading document with ID=" + docIdAnnot.getDocumentID()));
            }
            catch (Exception e) {
                this.logger.error((Object)"CasInitializer failed to process document: ");
                this.logger.error((Object)document);
                throw e;
            }
        }
        catch (Exception e) {
            throw new CollectionException((Throwable)e);
        }
    }

    private String getDocumentID(ResultSet rs) throws SQLException {
        if (this._docIdColNames != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this._docIdColNames.length; ++i) {
                String val = rs.getObject(this._docIdColNames[i]).toString();
                sb.append(val);
                if (i == this._docIdColNames.length - 1) continue;
                sb.append(this._docIdDelimiter);
            }
            return sb.toString();
        }
        return String.valueOf(this._currRowCount);
    }

    private String convertToString(Clob clob) throws SQLException, IOException {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = new BufferedReader(clob.getCharacterStream());
        String line = br.readLine();
        while (line != null) {
            sb.append(line);
            sb.append('\n');
            line = br.readLine();
        }
        br.close();
        return sb.toString();
    }

    public boolean hasNext() throws IOException, CollectionException {
        try {
            boolean hasAnotherRow;
            if (this._resultSet == null) {
                if (this._usePrepStmtVals) {
                    List<String> valList = this._prepStmtValArr[this._prepStmtValArrIdx];
                    this.setPrepStmtValues(this._preparedStatement, valList);
                    ++this._prepStmtValArrIdx;
                }
                this._resultSet = this._preparedStatement.executeQuery();
                ResultSetMetaData rsMetaData = this._resultSet.getMetaData();
                int colIdx = this._resultSet.findColumn(this._docTextColName);
                this._docColType = rsMetaData.getColumnType(colIdx);
                this._docColTypeName = rsMetaData.getColumnTypeName(1);
            }
            if (!(hasAnotherRow = this._resultSet.next())) {
                this._resultSet.close();
            }
            if (this._usePrepStmtVals && !hasAnotherRow && this._prepStmtValArrIdx < this._prepStmtValArr.length) {
                this._resultSet = null;
                return this.hasNext();
            }
            return hasAnotherRow;
        }
        catch (Exception e) {
            throw new CollectionException((Throwable)e);
        }
    }

    public Progress[] getProgress() {
        ProgressImpl p = new ProgressImpl(this._currRowCount, this._totalRowCount, "entities");
        return new Progress[]{p};
    }

    public void close() throws IOException {
        try {
            this._preparedStatement.close();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

