/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cr;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileReadWriteUtil;
import org.apache.ctakes.typesystem.type.structured.DocumentID;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

@PipeBitInfo(name="Text Files Reader", description="Reads document texts from text files specified in a provided list.", role=PipeBitInfo.Role.READER, products={PipeBitInfo.TypeProduct.DOCUMENT_ID})
public class TextReader
extends JCasCollectionReader_ImplBase {
    public static final String PARAM_FILES = "files";
    @ConfigurationParameter(name="files", mandatory=true, description="The text files to be loaded")
    private List<File> _files;
    private Iterator<File> _filesIter;
    private int _completed;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this._filesIter = this._files.iterator();
        this._completed = 0;
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this._completed, this._files.size(), "entities")};
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this._filesIter.hasNext();
    }

    public void getNext(JCas jCas) throws IOException, CollectionException {
        File currentFile = this._filesIter.next();
        String filename = currentFile.getName();
        String text = FileReadWriteUtil.readText(filename);
        jCas.setDocumentText(text);
        DocumentID documentIDAnnotation = new DocumentID(jCas);
        documentIDAnnotation.setDocumentID(filename);
        documentIDAnnotation.addToIndexes();
        ++this._completed;
    }
}

