/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cr;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.ctakes.core.cr.AbstractFileTreeReader;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.jcas.JCas;
import org.xml.sax.SAXException;

@PipeBitInfo(name="XMI Tree Reader", description="Reads document texts and annotations from XMI files in a directory tree.", role=PipeBitInfo.Role.READER, products={PipeBitInfo.TypeProduct.DOCUMENT_ID})
public final class XmiTreeReader
extends AbstractFileTreeReader {
    @Override
    protected void readFile(JCas jCas, File file) throws IOException {
        jCas.reset();
        try (FileInputStream inputStream = new FileInputStream(file);){
            XmiCasDeserializer.deserialize((InputStream)new BufferedInputStream(inputStream), (CAS)jCas.getCas());
        }
        catch (SAXException saxE) {
            throw new IOException(saxE);
        }
    }
}

