/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cr.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.ctakes.core.cr.jdbc.Decryptor;
import org.apache.ctakes.core.cr.jdbc.DecryptorWrapper;
import org.apache.ctakes.core.cr.jdbc.PassThroughDecryptor;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.structured.Demographics;
import org.apache.ctakes.typesystem.type.structured.DocumentID;
import org.apache.ctakes.typesystem.type.structured.Metadata;
import org.apache.ctakes.typesystem.type.structured.SourceData;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import sqlWrapper.WrappedConnection;

@PipeBitInfo(name="JDBC Note Table Reader", description="Reads document texts from database table's fields.", role=PipeBitInfo.Role.READER, products={PipeBitInfo.TypeProduct.DOCUMENT_ID})
public final class JdbcNotesReader
extends JCasCollectionReader_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"JdbcNoteTableReader");
    public static final String PARAM_DB_DRIVER = "DbDriver";
    @ConfigurationParameter(name="DbDriver", description="JDBC driver ClassName.")
    private String _dbDriver;
    public static final String PARAM_DB_DECRYPTOR = "DbDecryptor";
    @ConfigurationParameter(name="DbDecryptor", description="JDBC decryptor ClassName.", mandatory=false)
    private String _dbDecryptor;
    public static final String PARAM_DECRYPT_PASS = "DecryptPass";
    @ConfigurationParameter(name="DecryptPass", description="Password for text decryption.", mandatory=false)
    private String _decryptPass;
    public static final String PARAM_DB_URL = "DbUrl";
    @ConfigurationParameter(name="DbUrl", description="JDBC URL that specifies database network location and name.")
    private String _url;
    public static final String PARAM_DB_USER = "DbUser";
    @ConfigurationParameter(name="DbUser", description="Username for database authentication.")
    private String _user;
    public static final String PARAM_DB_PASS = "DbPass";
    @ConfigurationParameter(name="DbPass", description="Password for database authentication.")
    private String _pass;
    public static final String PARAM_KEEP_ALIVE = "KeepAlive";
    @ConfigurationParameter(name="KeepAlive", description="Flag that determines whether to keep JDBC connection open no matter what.", mandatory=false)
    private String _keepAlive;
    public static final String PARAM_SQL = "SqlStatement";
    @ConfigurationParameter(name="SqlStatement", description="SQL statement to retrieve the document.")
    private String _sqlStatement;
    public static final String PARAM_DOCTEXT_COL = "DocColumn";
    @ConfigurationParameter(name="DocColumn", description="Name of column that contains the document text.")
    private String _docTextColumn;
    public static final String PARAM_DOCID_COLS = "IdColumns";
    @ConfigurationParameter(name="IdColumns", description="Specifies column names that will be used to form a document ID.", mandatory=false)
    private String[] _docIdColumns;
    public static final String PARAM_DOCID_DELIMITER = "IdDelimiter";
    @ConfigurationParameter(name="IdDelimiter", description="Specifies delimiter used when document ID is built.", mandatory=false)
    private String _docIdDelimiter = "_";
    public static final String PARAM_PATIENT_COLUMN = "PatientColumn";
    @ConfigurationParameter(name="PatientColumn", description="Name of column that contains the patient identifier.", mandatory=false)
    private String _patientIdentifier;
    public static final String PARAM_PATIENT_ID = "PatientIdColumn";
    @ConfigurationParameter(name="PatientIdColumn", description="Name of column that contains the patient id.", mandatory=false)
    private String _patientId;
    public static final String PARAM_NOTE_TYPE = "NoteTypeColumn";
    @ConfigurationParameter(name="NoteTypeColumn", description="Name of column that contains the note type.", mandatory=false)
    private String _noteTypeCode;
    public static final String PARAM_NOTE_SUBTYPE = "NoteSubtypeColumn";
    @ConfigurationParameter(name="NoteSubtypeColumn", description="Name of column that contains the note subtype.", mandatory=false)
    private String _noteSubtypeCode;
    public static final String PARAM_SPECIALTY = "SpecialtyColumn";
    @ConfigurationParameter(name="SpecialtyColumn", description="Name of column that contains the author specialty.", mandatory=false)
    private String _authorSpecialty;
    public static final String PARAM_DOC_STANDARD = "StandardColumn";
    @ConfigurationParameter(name="StandardColumn", description="Name of column that contains the document standard.", mandatory=false)
    private String _documentStandard;
    public static final String PARAM_INSTANCE_ID = "InstanceIdColumn";
    @ConfigurationParameter(name="InstanceIdColumn", description="Name of column that contains the document instance id.", mandatory=false)
    private String _sourceInstanceId;
    public static final String PARAM_REVISION = "RevisionColumn";
    @ConfigurationParameter(name="RevisionColumn", description="Name of column that contains the document revision number.", mandatory=false)
    private String _sourceRevisionNumber;
    public static final String PARAM_REVISION_DATE = "RevisionDateColumn";
    @ConfigurationParameter(name="RevisionDateColumn", description="Name of column that contains the document revision date.", mandatory=false)
    private String _sourceRevisionDate;
    public static final String PARAM_DATE_COLUMN = "DateColumn";
    @ConfigurationParameter(name="DateColumn", description="Name of column that contains the document original date.", mandatory=false)
    private String _sourceOriginalDate;
    public static final String PARAM_INSTITUTE = "InstituteColumn";
    @ConfigurationParameter(name="InstituteColumn", description="Name of column that contains the source institution.", mandatory=false)
    private String _sourceInstitution;
    public static final String PARAM_ENCOUNTER = "EncounterIdColumn";
    @ConfigurationParameter(name="EncounterIdColumn", description="Name of column that contains the encounter id.", mandatory=false)
    private String _sourceEncounterId;
    public static final String PARAM_BIRTHDAY = "BirthColumn";
    @ConfigurationParameter(name="BirthColumn", description="Name of column that contains the patient birth date.", mandatory=false)
    private String _birthDate;
    public static final String PARAM_DEATHDAY = "DeathColumn";
    @ConfigurationParameter(name="DeathColumn", description="Name of column that contains the patient death date.", mandatory=false)
    private String _deathDate;
    public static final String PARAM_GENDER = "GenderColumn";
    @ConfigurationParameter(name="GenderColumn", description="Name of column that contains the patient gender.", mandatory=false)
    private String _gender;
    public static final String PARAM_FIRST_NAME = "FirstNameColumn";
    @ConfigurationParameter(name="FirstNameColumn", description="Name of column that contains the patient first name.", mandatory=false)
    private String _firstName;
    public static final String PARAM_MIDDLE_NAME = "MiddleNameColumn";
    @ConfigurationParameter(name="MiddleNameColumn", description="Name of column that contains the patient middle name.", mandatory=false)
    private String _middleName;
    public static final String PARAM_LAST_NAME = "LastNameColumn";
    @ConfigurationParameter(name="LastNameColumn", description="Name of column that contains the patient last name.", mandatory=false)
    private String _lastName;
    public static final String PARAM_FIRST_SOUNDEX = "FirstSoundexColumn";
    @ConfigurationParameter(name="FirstSoundexColumn", description="Name of column that contains the patient first name soundex.", mandatory=false)
    private String _firstNameSoundex;
    public static final String PARAM_LAST_SOUNDEX = "LastSoundexColumn";
    @ConfigurationParameter(name="LastSoundexColumn", description="Name of column that contains the patient last name soundex.", mandatory=false)
    private String _lastNameSoundex;
    private Connection _connection;
    private Decryptor _decryptor;
    private PreparedStatement _preparedStatement;
    private ResultSet _resultSet;
    private int _docColumnType;
    private String _docColumnTypeName;
    private long _startMillis;
    private int _totalRowCount = 0;
    private int _rowIndex = 0;
    private String _docId;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        LOGGER.info((Object)("Using Sql Statement:\n" + this._sqlStatement));
        this._connection = JdbcNotesReader.createConnection(this._dbDriver, this._url, this._user, this._pass, this._keepAlive);
        this._decryptor = JdbcNotesReader.createDecryptor(this._dbDecryptor);
        this._preparedStatement = this.createSqlStatement(this._connection);
        this._startMillis = System.currentTimeMillis();
    }

    public boolean hasNext() throws IOException, CollectionException {
        boolean hasAnotherRow;
        if (this._resultSet == null) {
            try {
                this.fillResultSet();
                this.setupDocColumnType();
            }
            catch (SQLException sqlE) {
                throw new CollectionException((Throwable)sqlE);
            }
        }
        try {
            hasAnotherRow = this._resultSet.next();
            if (hasAnotherRow) {
                this._docId = this.createDocId();
            } else {
                this._resultSet.close();
            }
        }
        catch (SQLException sqlE) {
            throw new CollectionException((Throwable)sqlE);
        }
        return hasAnotherRow;
    }

    public void getNext(JCas jCas) throws IOException, CollectionException {
        ++this._rowIndex;
        if (jCas == null) {
            throw new CollectionException((Throwable)new NullPointerException("Null CAS " + this._rowIndex + " in " + ((Object)((Object)this)).getClass().getName() + ".getNext( JCAS )"));
        }
        String clobDocument = this.getClobDocument();
        String document = this.getTextDocument(clobDocument);
        try {
            jCas.setDocumentText(document);
        }
        catch (CASRuntimeException casRTE) {
            throw new CollectionException((Throwable)casRTE);
        }
        DocumentID docIdAnnot = new DocumentID(jCas);
        docIdAnnot.setDocumentID(this._docId);
        docIdAnnot.addToIndexes();
        LOGGER.info((Object)("Reading document number " + this._rowIndex + " with ID " + this._docId));
        try {
            this.setMetadata(jCas);
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE);
        }
    }

    public Progress[] getProgress() {
        ProgressImpl p = new ProgressImpl(this._rowIndex, this._totalRowCount, "entities");
        return new Progress[]{p};
    }

    public void close() throws IOException {
        long totalMillis = System.currentTimeMillis() - this._startMillis;
        long totalSeconds = totalMillis / 1000L;
        long hourSeconds = 3600L;
        long daySeconds = 86400L;
        long days = totalSeconds / 86400L;
        long hours = (totalSeconds - days * 86400L) / 3600L;
        long minutes = (totalSeconds - days * 86400L - hours * 3600L) / 60L;
        long seconds = totalSeconds % 60L;
        LOGGER.info((Object)(((Object)((Object)this)).getClass().getName() + " read " + this._totalRowCount + " documents in " + days + " days, " + hours + " hours, " + minutes + " minutes and " + seconds + " seconds"));
        try {
            if (this._resultSet != null && !this._resultSet.isClosed()) {
                this._resultSet.close();
            }
            if (this._preparedStatement != null && !this._preparedStatement.isClosed()) {
                this._preparedStatement.close();
            }
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE);
        }
    }

    private PreparedStatement createSqlStatement(Connection connection) throws ResourceInitializationException {
        try {
            this._preparedStatement = connection.prepareStatement(this._sqlStatement);
            this._totalRowCount = this.getTotalRowCount(connection, this._sqlStatement);
        }
        catch (SQLException sqlE) {
            LOGGER.error((Object)"Could not interact with Database");
            throw new ResourceInitializationException((Throwable)sqlE);
        }
        return this._preparedStatement;
    }

    private int getTotalRowCount(Connection connection, String querySql) throws SQLException {
        PreparedStatement countStatement = JdbcNotesReader.createCountSql(connection, querySql);
        int totalRowCount = JdbcNotesReader.getTotalRowCount(countStatement);
        if (!countStatement.isClosed()) {
            countStatement.close();
        }
        LOGGER.info((Object)("Processing row count:" + totalRowCount));
        return totalRowCount;
    }

    private static PreparedStatement createCountSql(Connection connection, String querySql) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT COUNT(*) ");
        int fromIndex = querySql.toUpperCase().indexOf("FROM");
        sb.append(querySql.subSequence(fromIndex, querySql.length()));
        return connection.prepareStatement(sb.toString());
    }

    private static int getTotalRowCount(PreparedStatement countStatement) throws SQLException {
        ResultSet resultSet = countStatement.executeQuery();
        resultSet.next();
        int count = resultSet.getInt(1);
        resultSet.close();
        countStatement.close();
        return count;
    }

    private void fillResultSet() throws SQLException {
        LOGGER.info((Object)("SQL: " + this._preparedStatement.toString()));
        this._resultSet = this._preparedStatement.executeQuery();
    }

    private void setupDocColumnType() throws SQLException {
        ResultSetMetaData rsMetaData = this._resultSet.getMetaData();
        int colIdx = this._resultSet.findColumn(this._docTextColumn);
        this._docColumnType = rsMetaData.getColumnType(colIdx);
        this._docColumnTypeName = rsMetaData.getColumnTypeName(colIdx);
    }

    private String createDocId() {
        if (this._docIdColumns == null) {
            return String.valueOf(this._rowIndex + 1);
        }
        StringBuilder sb = new StringBuilder();
        boolean firstColumn = true;
        try {
            for (String columnName : this._docIdColumns) {
                if (!firstColumn) {
                    sb.append(this._docIdDelimiter);
                } else {
                    firstColumn = false;
                }
                String columnValue = this._resultSet.getObject(columnName).toString();
                sb.append(columnValue);
            }
        }
        catch (SQLException sqlE) {
            return String.valueOf(this._rowIndex);
        }
        return sb.toString();
    }

    private String getClobDocument() throws IOException {
        String document;
        try {
            if (this._docColumnType == 1 || this._docColumnType == 12) {
                document = this._resultSet.getString(this._docTextColumn);
            } else if (this._docColumnType == 2005) {
                document = JdbcNotesReader.convertToString(this._resultSet.getClob(this._docTextColumn));
            } else {
                if (!this._docColumnTypeName.equals("text")) {
                    LOGGER.warn((Object)("Inferring document text column as string type: " + this._docColumnTypeName));
                }
                document = this._resultSet.getString(this._docTextColumn);
            }
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE);
        }
        return document;
    }

    private String getTextDocument(String clobDocument) throws IOException {
        if (this._decryptPass == null || this._decryptPass.trim().isEmpty()) {
            return clobDocument;
        }
        try {
            return this._decryptor.decrypt(this._decryptPass, clobDocument);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static String convertToString(Clob clob) throws SQLException, IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(clob.getCharacterStream());
        String line = br.readLine();
        while (line != null) {
            sb.append(line);
            sb.append('\n');
            line = br.readLine();
        }
        br.close();
        return sb.toString();
    }

    private void setMetadata(JCas jCas) throws SQLException {
        Metadata metadata = new Metadata(jCas);
        metadata.setPatientIdentifier(this.getResult(this._patientIdentifier));
        Long patientId = this.getResultLong(this._patientId);
        if (patientId != null) {
            metadata.setPatientID(patientId.longValue());
        }
        SourceData sourcedata = this.createSourceData(jCas);
        metadata.setSourceData(sourcedata);
        Demographics demographics = this.createDemographics(jCas);
        metadata.setDemographics(demographics);
        jCas.addFsToIndexes((FeatureStructure)metadata);
    }

    private SourceData createSourceData(JCas jCas) throws SQLException {
        Timestamp originalDate;
        Timestamp revisionDate;
        SourceData sourcedata = new SourceData(jCas);
        sourcedata.setNoteTypeCode(this.getResult(this._noteTypeCode));
        sourcedata.setNoteSubTypeCode(this.getResult(this._noteSubtypeCode));
        sourcedata.setAuthorSpecialty(this.getResult(this._authorSpecialty));
        sourcedata.setDocumentStandard(this.getResult(this._documentStandard));
        sourcedata.setSourceInstanceId(this.getResult(this._sourceInstanceId));
        Integer revision = this.getResultInt(this._sourceRevisionNumber);
        if (revision != null) {
            sourcedata.setSourceRevisionNbr(revision.intValue());
        }
        if ((revisionDate = this.getResultDate(this._sourceRevisionDate)) != null) {
            sourcedata.setSourceRevisionDate(revisionDate.toString());
        }
        if ((originalDate = this.getResultDate(this._sourceOriginalDate)) != null) {
            sourcedata.setSourceOriginalDate(originalDate.toString());
        }
        sourcedata.setSourceInstitution(this.getResult(this._sourceInstitution));
        sourcedata.setSourceEncounterId(this.getResult(this._sourceEncounterId));
        return sourcedata;
    }

    private Demographics createDemographics(JCas jCas) throws SQLException {
        Timestamp deathDate;
        Demographics demographics = new Demographics(jCas);
        Timestamp birthDate = this.getResultDate(this._birthDate);
        if (birthDate != null) {
            demographics.setBirthDate(birthDate.toString());
        }
        if ((deathDate = this.getResultDate(this._deathDate)) != null) {
            demographics.setDeathDate(deathDate.toString());
        }
        demographics.setGender(this.getResult(this._gender));
        demographics.setFirstName(this.getResult(this._firstName));
        demographics.setMiddleName(this.getResult(this._middleName));
        demographics.setLastName(this.getResult(this._lastName));
        demographics.setFirstNameSoundex(this.getResult(this._firstNameSoundex));
        demographics.setLastNameSoundex(this.getResult(this._lastNameSoundex));
        return demographics;
    }

    private String getResult(String column) throws SQLException {
        if (column == null || column.isEmpty()) {
            return "";
        }
        return this._resultSet.getString(column);
    }

    private Integer getResultInt(String column) throws SQLException {
        if (column == null || column.isEmpty()) {
            return null;
        }
        return this._resultSet.getInt(column);
    }

    private Long getResultLong(String column) throws SQLException {
        if (column == null || column.isEmpty()) {
            return null;
        }
        return this._resultSet.getLong(column);
    }

    private Timestamp getResultDate(String column) throws SQLException {
        if (column == null || column.isEmpty()) {
            return null;
        }
        return this._resultSet.getTimestamp(column);
    }

    private static Connection createConnection(String driver, String url, String user, String pass, String keepAlive) throws ResourceInitializationException {
        Object[] emptyObjectArray = new Object[]{};
        try {
            if (keepAlive != null && !keepAlive.isEmpty() && Boolean.valueOf(keepAlive).booleanValue()) {
                return new WrappedConnection(user, pass, driver, url);
            }
            Class<?> driverClass = Class.forName(driver);
            return DriverManager.getConnection(url, user, pass);
        }
        catch (ClassNotFoundException | SQLException multE) {
            throw new ResourceInitializationException("Could not construct " + driver, emptyObjectArray, (Throwable)multE);
        }
    }

    private static Decryptor createDecryptor(String decryptorClassName) throws ResourceInitializationException {
        Constructor<?>[] constructors;
        Class<?> decryptorClass;
        if (decryptorClassName == null || decryptorClassName.isEmpty()) {
            return new PassThroughDecryptor();
        }
        Object[] emptyObjectArray = new Object[]{};
        try {
            decryptorClass = Class.forName(decryptorClassName);
        }
        catch (ClassNotFoundException cnfE) {
            throw new ResourceInitializationException("Unknown class " + decryptorClassName, emptyObjectArray, (Throwable)cnfE);
        }
        if (!Decryptor.class.isAssignableFrom(decryptorClass)) {
            return JdbcNotesReader.createWrappedDecryptor(decryptorClass);
        }
        for (Constructor<?> constructor : constructors = decryptorClass.getConstructors()) {
            try {
                if (constructor.getParameterTypes().length != 0) continue;
                return (Decryptor)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException multE) {
                throw new ResourceInitializationException("Could not construct " + decryptorClassName, emptyObjectArray, (Throwable)multE);
            }
        }
        throw new ResourceInitializationException("No Constructor for " + decryptorClassName, emptyObjectArray);
    }

    private static Decryptor createWrappedDecryptor(Class decryptorThingClass) throws ResourceInitializationException {
        Constructor<?>[] constructors;
        Method decryptMethod;
        Object[] emptyObjectArray = new Object[]{};
        Class[] methodParameters = new Class[]{String.class, String.class};
        try {
            decryptMethod = decryptorThingClass.getDeclaredMethod("decrypt", methodParameters);
            if (!decryptMethod.getReturnType().equals(String.class)) {
                throw new ResourceInitializationException(decryptorThingClass.getName() + ".decrypt( key, note ) method does not return text", emptyObjectArray);
            }
        }
        catch (NoSuchMethodException nsmE) {
            throw new ResourceInitializationException(decryptorThingClass.getName() + " has no decrypt( key, note ) method", emptyObjectArray);
        }
        for (Constructor<?> constructor : constructors = decryptorThingClass.getConstructors()) {
            try {
                if (constructor.getParameterTypes().length != 0) continue;
                LOGGER.info((Object)("Wrapping " + decryptorThingClass.getName() + " in a Decryptor"));
                return new DecryptorWrapper(constructor.newInstance(new Object[0]), decryptMethod);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException multE) {
                throw new ResourceInitializationException("Could not construct " + decryptorThingClass.getName(), emptyObjectArray, (Throwable)multE);
            }
        }
        throw new ResourceInitializationException("No Constructor for " + decryptorThingClass.getName(), emptyObjectArray);
    }
}

