/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.fsm.adapters;

import org.apache.ctakes.core.fsm.adapters.NumberTokenAdapter;
import org.apache.ctakes.core.fsm.token.DecimalToken;
import org.apache.ctakes.typesystem.type.syntax.NumToken;

public class DecimalTokenAdapter
extends NumberTokenAdapter
implements DecimalToken {
    private double iv_val;
    private static final String negativeSign = "-";

    public DecimalTokenAdapter(NumToken nta) {
        block5: {
            super(nta);
            if (!nta.getCoveredText().isEmpty()) {
                String numAsString = this.removeCommas(nta.getCoveredText());
                try {
                    this.iv_val = Double.parseDouble(numAsString);
                }
                catch (NumberFormatException nfE) {
                    if (numAsString.startsWith(negativeSign)) {
                        this.iv_val = -1.7976931348623157E308;
                        break block5;
                    }
                    this.iv_val = Double.MAX_VALUE;
                }
            } else {
                this.iv_val = 0.0;
            }
        }
    }

    @Override
    public double getValue() {
        return this.iv_val;
    }
}

