/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.fsm.machine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Condition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;
import org.apache.ctakes.core.fsm.condition.DayNightWordCondition;
import org.apache.ctakes.core.fsm.condition.HourMinuteCondition;
import org.apache.ctakes.core.fsm.condition.IntegerRangeCondition;
import org.apache.ctakes.core.fsm.condition.PunctuationValueCondition;
import org.apache.ctakes.core.fsm.condition.WordSetCondition;
import org.apache.ctakes.core.fsm.output.TimeToken;
import org.apache.ctakes.core.fsm.state.NamedState;
import org.apache.ctakes.core.fsm.token.BaseToken;

public class TimeFSM {
    private final int MIN_MINUTE = 0;
    private final int MAX_MINUTE = 59;
    private final int MIN_HOUR = 1;
    private final int MAX_HOUR = 12;
    private Set<String> iv_dayNightSet = new HashSet<String>();
    private Set<Machine> iv_machineSet = new HashSet<Machine>();

    public TimeFSM() {
        this.iv_dayNightSet.add("am");
        this.iv_dayNightSet.add("pm");
        this.iv_machineSet.add(this.getMachine());
    }

    private Machine getMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        NamedState hourNumState = new NamedState("HOUR_NUM");
        NamedState hourMinTextState = new NamedState("HOUR_MIN_TEXT");
        NamedState ampmTextWithPeriodState = new NamedState("AM_PM_PERIOD_TEXT");
        IntegerRangeCondition hourNumCondition = new IntegerRangeCondition(1, 12);
        HourMinuteCondition hourMinCondition = new HourMinuteCondition(1, 12, 0, 59);
        WordSetCondition dayNightCondition = new WordSetCondition(this.iv_dayNightSet, false);
        DayNightWordCondition dayNightWithPeriodCondition = new DayNightWordCondition();
        PunctuationValueCondition closingPeriodCondition = new PunctuationValueCondition('.');
        startState.addTransition(hourNumCondition, hourNumState);
        startState.addTransition(hourMinCondition, hourMinTextState);
        startState.addTransition((Condition)new AnyCondition(), startState);
        hourMinTextState.addTransition(dayNightCondition, endState);
        hourMinTextState.addTransition(dayNightWithPeriodCondition, ampmTextWithPeriodState);
        hourMinTextState.addTransition((Condition)new AnyCondition(), startState);
        hourNumState.addTransition(dayNightCondition, endState);
        hourNumState.addTransition(dayNightWithPeriodCondition, ampmTextWithPeriodState);
        hourNumState.addTransition((Condition)new AnyCondition(), startState);
        ampmTextWithPeriodState.addTransition(closingPeriodCondition, endState);
        ampmTextWithPeriodState.addTransition((Condition)new AnyCondition(), startState);
        endState.addTransition((Condition)new AnyCondition(), startState);
        return m;
    }

    public Set<TimeToken> execute(List<? extends BaseToken> tokens) throws Exception {
        HashSet<TimeToken> timeSet = new HashSet<TimeToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        for (int i = 0; i < tokens.size(); ++i) {
            BaseToken token = tokens.get(i);
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input((Object)token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken startToken = tokens.get(tokenStartIndex);
                BaseToken endToken = token;
                TimeToken timeToken = new TimeToken(startToken.getStartOffset(), endToken.getEndOffset());
                timeSet.add(timeToken);
                fsm.reset();
            }
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return timeSet;
    }
}

