/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.knowtator;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.ctakes.core.knowtator.KnowtatorAnnotation;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class KnowtatorXMLParser {
    private static final Logger LOGGER = Logger.getLogger((String)KnowtatorXMLParser.class.getName());
    private XMLOutputter xmlOutputter = new XMLOutputter();
    private Set<String> annotatorNames;

    public KnowtatorXMLParser(String ... annotatorNames) {
        this(new HashSet<String>(Arrays.asList(annotatorNames)));
    }

    public KnowtatorXMLParser(Set<String> annotatorNames) {
        this.annotatorNames = annotatorNames;
    }

    public Collection<KnowtatorAnnotation> parse(URI knowtatorXML) throws JDOMException, IOException {
        Element annotationsElem = new SAXBuilder().build(knowtatorXML.toURL()).getRootElement();
        HashSet<String> ignoredAnnotators = new HashSet<String>();
        HashMap<String, KnowtatorAnnotation> annotations = new HashMap<String, KnowtatorAnnotation>();
        for (Object annotationElem : annotationsElem.getChildren("annotation")) {
            for (Element element : this.getChild((Element)annotationElem, "annotator")) {
                String string = element.getText();
                if (!this.annotatorNames.contains(string)) {
                    ignoredAnnotators.add(string);
                    continue;
                }
                for (Element element2 : this.getChild((Element)annotationElem, "mention")) {
                    for (String id : this.getAttributeValue(element2, "id")) {
                        KnowtatorAnnotation annotation = new KnowtatorAnnotation();
                        annotation.id = id;
                        annotations.put(id, annotation);
                        List spanElems = annotationElem.getChildren("span");
                        if (spanElems.isEmpty()) continue;
                        for (Element spannedTextElem : this.getChild((Element)annotationElem, "spannedText")) {
                            annotation.spannedText = spannedTextElem.getText();
                        }
                        for (Element spanElem : spanElems) {
                            for (String startStr : this.getAttributeValue(spanElem, "start")) {
                                for (String endStr : this.getAttributeValue(spanElem, "end")) {
                                    annotation.addSpan(Integer.parseInt(startStr), Integer.parseInt(endStr));
                                }
                            }
                        }
                    }
                }
            }
        }
        LOGGER.debug((Object)String.format("Ignored annotators %s in %s", ignoredAnnotators, knowtatorXML));
        HashMap stringSlots = new HashMap();
        for (Object slotMentionElem : annotationsElem.getChildren("stringSlotMention")) {
            for (IdAndSlot<String> idAndSlot : this.parseSlotMention((Element)slotMentionElem, "stringSlotMentionValue")) {
                stringSlots.put(idAndSlot.id, idAndSlot.slot);
            }
        }
        HashMap<String, Slot<Boolean>> booleanSlots = new HashMap<String, Slot<Boolean>>();
        for (Element element : annotationsElem.getChildren("booleanSlotMention")) {
            for (IdAndSlot<String> idAndSlot : this.parseSlotMention(element, "booleanSlotMentionValue")) {
                Slot slot = idAndSlot.slot;
                Boolean value = Boolean.parseBoolean((String)slot.value);
                booleanSlots.put(idAndSlot.id, new Slot<Boolean>(slot.name, value));
            }
        }
        HashMap<String, Slot<KnowtatorAnnotation>> mentionSlots = new HashMap<String, Slot<KnowtatorAnnotation>>();
        for (Element element : annotationsElem.getChildren("complexSlotMention")) {
            for (IdAndSlot<String> idAndSlot : this.parseSlotMention(element, "complexSlotMentionValue")) {
                Slot slot = idAndSlot.slot;
                KnowtatorAnnotation mention = (KnowtatorAnnotation)annotations.get(slot.value);
                if (mention == null) continue;
                mentionSlots.put(idAndSlot.id, new Slot<KnowtatorAnnotation>(slot.name, mention));
            }
        }
        for (Element element : annotationsElem.getChildren("classMention")) {
            for (String string : this.getAttributeValue(element, "id")) {
                KnowtatorAnnotation annotation = (KnowtatorAnnotation)annotations.get(string);
                if (annotation == null) continue;
                annotation.type = element.getChildText("mentionClass");
                for (Element hasSlotMentionElem : element.getChildren("hasSlotMention")) {
                    for (String slotId : this.getAttributeValue(hasSlotMentionElem, "id")) {
                        Slot stringSlot = (Slot)stringSlots.get(slotId);
                        if (stringSlot != null) {
                            annotation.stringSlots.put(stringSlot.name, (String)stringSlot.value);
                            continue;
                        }
                        Slot booleanSlot = (Slot)booleanSlots.get(slotId);
                        if (booleanSlot != null) {
                            annotation.booleanSlots.put(booleanSlot.name, (Boolean)booleanSlot.value);
                            continue;
                        }
                        Slot mentionSlot = (Slot)mentionSlots.get(slotId);
                        if (mentionSlot != null) {
                            annotation.annotationSlots.put(mentionSlot.name, (KnowtatorAnnotation)mentionSlot.value);
                            continue;
                        }
                        LOGGER.warn((Object)("no simple slot for " + slotId));
                    }
                }
            }
        }
        return annotations.values();
    }

    private Option<Element> getChild(Element element, String cname) {
        Element child = element.getChild(cname);
        if (child == null) {
            String xml = this.xmlOutputter.outputString(element);
            LOGGER.debug((Object)String.format("no child <%s> for %s", cname, xml));
        }
        return new Option<Element>(child);
    }

    private Option<String> getAttributeValue(Element element, String attname) {
        String value = element.getAttributeValue(attname);
        if (value == null) {
            String xml = this.xmlOutputter.outputString(element);
            LOGGER.debug((Object)String.format("no attribute %s for %s", attname, xml));
        }
        return new Option<String>(value);
    }

    private Option<IdAndSlot<String>> parseSlotMention(Element slotMentionElem, String slotMentionValueElemName) {
        IdAndSlot<String> result = null;
        for (String slotId : this.getAttributeValue(slotMentionElem, "id")) {
            for (Element mentionSlotElem : this.getChild(slotMentionElem, "mentionSlot")) {
                for (String slotName : this.getAttributeValue(mentionSlotElem, "id")) {
                    for (Element slotMentionValueElem : this.getChild(slotMentionElem, slotMentionValueElemName)) {
                        for (String slotValue : this.getAttributeValue(slotMentionValueElem, "value")) {
                            result = new IdAndSlot<String>(slotId, new Slot<String>(slotName, slotValue));
                        }
                    }
                }
            }
        }
        return new Option<Object>(result);
    }

    private static class IdAndSlot<T> {
        public String id;
        public Slot<T> slot;

        public IdAndSlot(String id, Slot<T> slot) {
            this.id = id;
            this.slot = slot;
        }
    }

    private static class Slot<T> {
        public String name;
        public T value;

        public Slot(String name, T value) {
            this.name = name;
            this.value = value;
        }
    }

    private static class Option<T>
    implements Iterable<T> {
        T value;

        public Option(T value) {
            this.value = value;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private T next;
                {
                    this.next = value;
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public T next() {
                    Object result = this.next;
                    this.next = null;
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

