/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.patient;

import java.util.Collection;
import org.apache.ctakes.core.ae.NamedEngine;
import org.apache.ctakes.core.patient.PatientNoteStore;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.doc.SourceMetadataUtil;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="AbstractPatientConsumer", description="Abstract Engine to take action on a patient level instead of document level.", role=PipeBitInfo.Role.ANNOTATOR)
public abstract class AbstractPatientConsumer
extends JCasAnnotator_ImplBase
implements NamedEngine {
    public static final String REMOVE_PATIENT = "RemovePatient";
    public static final String ENGINE_NAME = "EngineName";
    @ConfigurationParameter(name="RemovePatient", description="The Patient Consumer should remove the patient from the cache when finished.", defaultValue={"true"})
    private boolean _removePatient;
    @ConfigurationParameter(name="EngineName", description="The Name to use for this Patient Consumer.  Must be unique in the pipeline", mandatory=false)
    private String _engineName;
    private final String _action;
    private final Logger _logger;

    protected AbstractPatientConsumer(String aeName, String action) {
        this._action = action;
        this._logger = Logger.getLogger((String)aeName);
    }

    @Override
    public String getEngineName() {
        if (this._engineName != null && !this._engineName.isEmpty()) {
            return this._engineName;
        }
        return this.getClass().getSimpleName();
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        PatientNoteStore.getInstance().registerEngine(this.getEngineName());
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        this.processPatients();
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        this.processPatients();
    }

    protected void processPatients() throws AnalysisEngineProcessException {
        Collection<JCas> completedCases = PatientNoteStore.getInstance().popPatientCases(this.getEngineName());
        for (JCas patientCas : completedCases) {
            String patientName = SourceMetadataUtil.getPatientIdentifier(patientCas);
            this._logger.info((Object)(this._action + " for patient " + patientName + " ..."));
            this.processPatientCas(patientCas);
        }
    }

    protected abstract void processPatientCas(JCas var1) throws AnalysisEngineProcessException;
}

