/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.patient;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.ctakes.core.ae.NamedEngine;
import org.apache.ctakes.core.cc.AbstractFileWriter;
import org.apache.ctakes.core.patient.PatientNoteStore;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;

public abstract class AbstractPatientFileWriter
extends AbstractFileWriter<Collection<JCas>>
implements NamedEngine {
    private static final Logger LOGGER = Logger.getLogger((String)"AbstractPatientFileWriter");
    private static final Object DATA_LOCK = new Object();
    private final Collection<JCas> _patientCases = new HashSet<JCas>();

    protected AbstractPatientFileWriter() {
        PatientNoteStore.getInstance().registerEngine(this.getEngineName());
    }

    @Override
    protected void createData(JCas jCas) {
        this._patientCases.addAll(PatientNoteStore.getInstance().popPatientCases(this.getEngineName()));
    }

    @Override
    protected Collection<JCas> getData() {
        return this._patientCases;
    }

    @Override
    protected void writeComplete(Collection<JCas> data) {
        this._patientCases.clear();
    }

    @Override
    protected String getSubdirectory(JCas jCas, String documentId) {
        return this.getSimpleSubDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        String outputDir = this.getOutputDirectory(null, this.getRootDirectory(), "");
        try {
            Object object = DATA_LOCK;
            synchronized (object) {
                this.createData(null);
                Object data = this.getData();
                this.writeFile(data, outputDir, "", "");
                this.writeComplete((Collection<JCas>)data);
            }
        }
        catch (IOException ioE) {
            throw new AnalysisEngineProcessException((Throwable)ioE);
        }
    }
}

