/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.patient;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.ctakes.core.ae.NamedEngine;
import org.apache.ctakes.core.patient.PatientViewUtil;
import org.apache.ctakes.core.util.doc.DocIdUtil;
import org.apache.ctakes.core.util.doc.SourceMetadataUtil;
import org.apache.ctakes.typesystem.type.structured.DocumentIdPrefix;
import org.apache.ctakes.typesystem.type.structured.Metadata;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.util.CasCopier;

public enum PatientNoteStore {
    INSTANCE;

    private static final Logger LOGGER;
    private static final String GENERIC_PATIENT = "Generic";
    private final Collection<String> _registeredEngines = new HashSet<String>();
    private final Map<String, Collection<String>> _enginesRun = new HashMap<String, Collection<String>>();
    private final Map<String, JCas> _patientMap = new HashMap<String, JCas>();
    private final Map<String, Collection<ViewInfo>> _patientViewInfos = new HashMap<String, Collection<ViewInfo>>();
    private final Map<String, Integer> _wantedDocCounts = new HashMap<String, Integer>();

    public static PatientNoteStore getInstance() {
        return INSTANCE;
    }

    public synchronized void registerEngine(String engineName) {
        if (!this._registeredEngines.add(engineName)) {
            throw new IllegalArgumentException(engineName + " already Registered!  To add an engine twice, please use the parameter " + "EngineName" + " to specify unique names OR if you are developing the engine override getEngineName() method.");
        }
    }

    public synchronized void registerEngine(NamedEngine namedEngine) {
        this.registerEngine(namedEngine.getEngineName());
    }

    @Deprecated
    public synchronized Collection<String> getStoredPatientIds() {
        return this._patientMap.keySet().stream().sorted().collect(Collectors.toList());
    }

    public synchronized Collection<String> getStoredDocIds(String patientId) {
        return this.getViewInfos(patientId).stream().map(ViewInfo::getDocId).sorted().distinct().collect(Collectors.toList());
    }

    public synchronized Collection<String> getStoredViewNames(String patientId, String docId) {
        return this.getViewInfos(patientId).stream().filter(vi -> vi.getDocId().equals(docId)).map(ViewInfo::getViewName).sorted().collect(Collectors.toList());
    }

    public synchronized Collection<String> getCompletedPatientIds() {
        return this.getStoredPatientIds().stream().filter(pid -> this.getWantedDocCount((String)pid) == this.getStoredDocCount((String)pid)).sorted().collect(Collectors.toList());
    }

    public synchronized int getStoredDocCount(String patientId) {
        return this.getStoredDocIds(patientId).size();
    }

    public synchronized int getWantedDocCount(String patientId) {
        return this._wantedDocCounts.getOrDefault(patientId, -1);
    }

    public synchronized void setWantedDocCount(String patientId, int count) {
        this._wantedDocCounts.put(patientId, count);
    }

    public static String getDefaultPatientId(JCas viewCas) {
        String patientIdentifier = SourceMetadataUtil.getPatientIdentifier(viewCas);
        if (patientIdentifier != null && !patientIdentifier.isEmpty() && !patientIdentifier.equals("UnknownPatient")) {
            return patientIdentifier;
        }
        return GENERIC_PATIENT;
    }

    public static String getDefaultDocumentId(JCas viewCas) {
        return DocIdUtil.getDocumentID(viewCas);
    }

    public synchronized void storeAllViews(JCas sourceCas) {
        PatientViewUtil.getAllViewNames(sourceCas).forEach(n -> this.storeView((String)n, sourceCas));
    }

    public synchronized void storeAllViews(String patientId, String docId, JCas sourceCas) {
        PatientViewUtil.getAllViewNames(sourceCas).forEach(n -> this.storeView(patientId, docId, (String)n, sourceCas));
    }

    public synchronized void storePrimaryAsView(String storeViewName, JCas sourceCas) {
        this.storePrimaryAsView(PatientNoteStore.getDefaultPatientId(sourceCas), PatientNoteStore.getDefaultDocumentId(sourceCas), storeViewName, sourceCas);
    }

    public synchronized void storePrimaryAsView(String patientId, String docId, String storeViewName, JCas sourceCas) {
        this.storeView(patientId, docId, storeViewName, "_InitialView", sourceCas);
    }

    public synchronized void storeView(String sourceViewName, JCas sourceCas) {
        this.storeView(PatientNoteStore.getDefaultPatientId(sourceCas), PatientNoteStore.getDefaultDocumentId(sourceCas), sourceViewName, sourceViewName, sourceCas);
    }

    public synchronized void storeView(String patientId, String docId, String sourceViewName, JCas sourceCas) {
        this.storeView(patientId, docId, sourceViewName, sourceViewName, sourceCas);
    }

    public synchronized void storeView(String patientId, String docId, String storeViewName, String sourceViewName, JCas sourceCas) {
        JCas patientCas;
        if (this.getStoredViewNames(patientId, docId).contains(storeViewName)) {
            LOGGER.warn((Object)("View already stored as " + patientId + " " + docId + " " + storeViewName));
            LOGGER.warn((Object)"Previously stored view will be replaced.");
        }
        if ((patientCas = this._patientMap.get(patientId)) == null) {
            try {
                patientCas = JCasFactory.createJCas();
                PatientNoteStore.setPatientId(patientCas, patientId);
                this._patientMap.put(patientId, patientCas);
            }
            catch (UIMAException uE) {
                LOGGER.error((Object)uE.getMessage());
                return;
            }
        }
        LOGGER.info((Object)("Caching view for " + patientId + " " + docId + " " + sourceViewName + (sourceViewName.equals(storeViewName) ? "" : " as " + storeViewName) + " ..."));
        ViewInfo viewInfo = new ViewInfo(patientId, docId, storeViewName);
        try {
            JCas sourceView = sourceCas.getView(sourceViewName);
            CasCopier copier = new CasCopier(sourceCas.getCas(), patientCas.getCas());
            copier.copyCasView(sourceView.getCas(), viewInfo.getViewCode(), true);
            this._patientViewInfos.putIfAbsent(patientId, new ArrayList());
            this._patientViewInfos.get(patientId).add(viewInfo);
        }
        catch (CASException | CASRuntimeException casE) {
            LOGGER.error((Object)casE.getMessage());
        }
    }

    private static void setPatientId(JCas jCas, String patientId) {
        DocumentIdPrefix documentIdPrefix = new DocumentIdPrefix(jCas);
        documentIdPrefix.setDocumentIdPrefix(patientId);
        documentIdPrefix.addToIndexes();
        Metadata metadata = SourceMetadataUtil.getOrCreateMetadata(jCas);
        metadata.setPatientIdentifier(patientId);
    }

    public synchronized JCas getStoredView(String patientId, String docId, String viewName) {
        JCas patientCas = this._patientMap.get(patientId);
        if (patientCas == null) {
            LOGGER.warn((Object)("No patient with id " + patientId));
            return null;
        }
        ViewInfo viewInfo = new ViewInfo(patientId, docId, viewName);
        try {
            return patientCas.getView(viewInfo.getViewCode());
        }
        catch (CASException casE) {
            LOGGER.error((Object)casE.getMessage());
            return null;
        }
    }

    public synchronized Map<String, JCas> getStoredViews(String patientId, String docId) {
        JCas patientCas = this._patientMap.get(patientId);
        if (patientCas == null) {
            LOGGER.warn((Object)("No patient with id " + patientId));
            return null;
        }
        Collection<String> viewNames = this.getStoredViewNames(patientId, docId);
        HashMap<String, JCas> viewMap = new HashMap<String, JCas>();
        try {
            for (String viewName : viewNames) {
                ViewInfo viewInfo = new ViewInfo(viewName);
                viewMap.put(viewInfo.getViewName(), patientCas.getView(viewName));
            }
        }
        catch (CASException casE) {
            LOGGER.error((Object)casE.getMessage());
        }
        return viewMap;
    }

    public synchronized Map<String, Map<String, JCas>> getStoredViews(String patientId) {
        HashMap<String, Map<String, JCas>> viewMap = new HashMap<String, Map<String, JCas>>();
        Collection<String> docIds = this.getStoredDocIds(patientId);
        for (String docId : docIds) {
            viewMap.put(docId, this.getStoredViews(patientId, docId));
        }
        return viewMap;
    }

    public static String getInternalViewname(String patientId, String docId, String viewName) {
        ViewInfo viewInfo = new ViewInfo(patientId, docId, viewName);
        return viewInfo.getViewCode();
    }

    public synchronized JCas getFullPatientCas(String patientId) {
        return this._patientMap.get(patientId);
    }

    public synchronized JCas popPatientCas(String engineName) {
        if (!this._registeredEngines.contains(engineName)) {
            throw new IllegalArgumentException("Engine not registered to use patients " + engineName);
        }
        Collection<String> completedPatientIds = this.getCompletedPatientIds();
        for (String patientId : completedPatientIds) {
            JCas patientCas = this.popPatientCas(patientId, engineName);
            if (patientCas == null) continue;
            return patientCas;
        }
        return null;
    }

    public synchronized Collection<JCas> popPatientCases(String engineName) {
        if (!this._registeredEngines.contains(engineName)) {
            throw new IllegalArgumentException("Engine not registered to use patients " + engineName);
        }
        ArrayList<String> completedPatientIds = new ArrayList<String>(this.getCompletedPatientIds());
        return completedPatientIds.stream().map(id -> this.popPatientCas((String)id, engineName)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public synchronized JCas popPatientCas(String patientId, String engineName) {
        if (!this._registeredEngines.contains(engineName)) {
            throw new IllegalArgumentException("Engine not registered to use patients " + engineName);
        }
        Collection enginesRun = this._enginesRun.computeIfAbsent(patientId, n -> new HashSet());
        boolean newRun = enginesRun.add(engineName);
        if (!newRun) {
            return null;
        }
        JCas patientCas = this._patientMap.get(patientId);
        if (enginesRun.size() == this._registeredEngines.size()) {
            this.removePatient(patientId);
        }
        return patientCas;
    }

    public synchronized void removePatient(String patientId) {
        this._patientMap.remove(patientId);
        this._patientViewInfos.remove(patientId);
        this._wantedDocCounts.remove(patientId);
    }

    private synchronized Collection<ViewInfo> getViewInfos(String patientId) {
        Collection<ViewInfo> viewInfos = this._patientViewInfos.get(patientId);
        if (viewInfos == null) {
            LOGGER.debug((Object)("No patient with id " + patientId));
            return Collections.emptyList();
        }
        return viewInfos;
    }

    static {
        LOGGER = Logger.getLogger((String)"PatientNoteStore");
    }

    @Immutable
    private static final class ViewInfo {
        private final String _pid;
        private final String _docId;
        private final String _viewName;

        private ViewInfo(String viewCode) {
            this(ViewInfo.getId(viewCode, "pid"), ViewInfo.getId(viewCode, "docId"), ViewInfo.getId(viewCode, "viewName"));
        }

        private ViewInfo(String pid, String docId, String viewName) {
            this._pid = pid;
            this._docId = docId;
            this._viewName = viewName;
        }

        public String getPid() {
            return this._pid;
        }

        public String getDocId() {
            return this._docId;
        }

        public String getViewName() {
            return this._viewName;
        }

        public String getViewCode() {
            return "<pid>" + this._pid + "</pid><docId>" + this._docId + "</docId><viewName>" + this._viewName + "</viewName>";
        }

        public boolean equals(Object object) {
            return object instanceof ViewInfo && ((ViewInfo)object).getViewCode().equals(this.getViewCode());
        }

        public int hashCode() {
            return this.getViewCode().hashCode();
        }

        private static String getId(String viewCode, String tag) {
            int i1 = viewCode.indexOf("<" + tag + ">");
            if (i1 < 0) {
                return viewCode;
            }
            int i2 = viewCode.indexOf("</" + tag + ">");
            if (i2 < 0) {
                return viewCode;
            }
            return viewCode.substring(i1 + 2 + tag.length(), i2);
        }
    }
}

