/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.patient;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ctakes.core.patient.PatientNoteStore;
import org.apache.ctakes.core.util.NumberedSuffixComparator;
import org.apache.log4j.Logger;
import org.apache.uima.cas.CASException;
import org.apache.uima.jcas.JCas;

public final class PatientViewUtil {
    public static final String DEFAULT_VIEW = "_InitialView";
    public static final String GOLD_PREFIX = "GoldView";
    private static final Predicate<String> isNameGold = s -> s.startsWith(GOLD_PREFIX);
    private static final Predicate<JCas> isCasGold = c -> c.getViewName().startsWith(GOLD_PREFIX);
    private static final Logger LOGGER = Logger.getLogger((String)"PatientViewUtil");

    private PatientViewUtil() {
    }

    public static Collection<String> getAllViewNames(JCas jCas) {
        return PatientViewUtil.getAllViews(jCas).stream().map(JCas::getViewName).collect(Collectors.toList());
    }

    public static String getDefaultViewName() {
        return DEFAULT_VIEW;
    }

    public static Collection<String> getGoldViewNames(JCas jCas) {
        return PatientViewUtil.getAllViewNames(jCas).stream().filter(isNameGold).collect(Collectors.toList());
    }

    public static Collection<String> getDocumentViewNames(JCas jCas) {
        return PatientViewUtil.getDocumentViews(jCas).stream().map(JCas::getViewName).collect(Collectors.toList());
    }

    public static Collection<JCas> getAllViews(JCas jCas) {
        if (jCas == null) {
            return Collections.emptyList();
        }
        ArrayList<JCas> views = new ArrayList<JCas>();
        try {
            jCas.getViewIterator().forEachRemaining(views::add);
        }
        catch (CASException casE) {
            LOGGER.error((Object)casE.getMessage());
        }
        return views;
    }

    public static JCas getDefaultView(JCas jCas) {
        try {
            return jCas.getView(DEFAULT_VIEW);
        }
        catch (CASException casE) {
            LOGGER.error((Object)casE.getMessage());
            return jCas;
        }
    }

    public static Collection<JCas> getGoldViews(JCas jCas) {
        return PatientViewUtil.getAllViews(jCas).stream().filter(isCasGold).sorted(new ViewComparator()).collect(Collectors.toList());
    }

    public static Collection<JCas> getDocumentViews(JCas jCas) {
        ArrayList<JCas> unwantedViews = new ArrayList<JCas>(PatientViewUtil.getGoldViews(jCas));
        unwantedViews.add(PatientViewUtil.getDefaultView(jCas));
        return PatientViewUtil.getAllViews(jCas).stream().filter(c -> !unwantedViews.contains(c)).sorted(new ViewComparator()).collect(Collectors.toList());
    }

    public static JCas getAlignedGoldCas(JCas patientJCas, JCas docView) throws CASException {
        String pid = PatientNoteStore.getDefaultPatientId(patientJCas);
        String docId = PatientNoteStore.getDefaultDocumentId(docView).replace(DEFAULT_VIEW, "");
        String goldViewName = PatientNoteStore.getInternalViewname(pid, docId, GOLD_PREFIX);
        return patientJCas.getView(goldViewName);
    }

    public static JCas getAlignedDocCas(JCas patientJCas, JCas goldView) throws CASException {
        String pid = PatientNoteStore.getDefaultPatientId(patientJCas);
        String docId = PatientNoteStore.getDefaultDocumentId(goldView).replace("GoldView_", "");
        String docViewName = PatientNoteStore.getInternalViewname(pid, docId, DEFAULT_VIEW);
        return patientJCas.getView(docViewName);
    }

    static final class ViewComparator
    implements Comparator<JCas> {
        private final Comparator<String> __delegate = new NumberedSuffixComparator();

        ViewComparator() {
        }

        @Override
        public int compare(JCas jCas1, JCas jCas2) {
            return this.__delegate.compare(jCas1.getViewName(), jCas2.getViewName());
        }
    }
}

