/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.pipeline;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.annotation.OntologyConceptUtil;
import org.apache.ctakes.core.util.doc.DocIdUtil;
import org.apache.log4j.Logger;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.jcas.JCas;

public enum CuiCollector {
    INSTANCE;

    private static final Logger LOGGER;
    private final Map<String, Map<String, Long>> _cuiCountMap = new HashMap<String, Map<String, Long>>();

    public static CuiCollector getInstance() {
        return INSTANCE;
    }

    public Collection<String> getDocumentIds() {
        return Collections.unmodifiableCollection(this._cuiCountMap.keySet());
    }

    public Collection<String> getCuis(String documentId) {
        return Collections.unmodifiableCollection(this.get(documentId).keySet());
    }

    public Map<String, Long> getCuiCounts(String documentId) {
        return this.get(documentId);
    }

    public Collection<String> getCuis() {
        return Collections.unmodifiableCollection(this._cuiCountMap.values().stream().map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toSet()));
    }

    public Map<String, Long> getCuiCounts() {
        return Collections.unmodifiableMap(this._cuiCountMap.values().stream().map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (n1, n2) -> n1 + n2)));
    }

    private Map<String, Long> get(String documentId) {
        Map<String, Long> cuiCounts = this._cuiCountMap.get(documentId);
        if (cuiCounts == null) {
            LOGGER.warn((Object)("No Cuis for " + documentId));
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(cuiCounts);
    }

    public String toString() {
        List allCuis = this.getCuis().stream().sorted().collect(Collectors.toList());
        String header = "DOCUMENT_ID|" + String.join((CharSequence)"|", allCuis);
        String rows = this._cuiCountMap.entrySet().stream().sorted().map(e -> CuiCollector.createRowText((String)e.getKey(), (Map)e.getValue(), allCuis)).collect(Collectors.joining());
        return header + "\n" + rows;
    }

    private static String createRowText(String documentId, Map<String, Long> cuiCounts, List<String> allCuis) {
        StringBuilder sb = new StringBuilder();
        sb.append(documentId);
        for (String cui : allCuis) {
            sb.append("|");
            Long count = cuiCounts.get(cui);
            sb.append(count == null ? "0" : count);
        }
        sb.append("\n");
        return sb.toString();
    }

    static {
        LOGGER = Logger.getLogger((String)"CuiCollector");
    }

    @PipeBitInfo(name="CUI Collector", description="Collects all CUIs generated during a run.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
    public static final class CuiCollectorEngine
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) {
            LOGGER.info((Object)"Starting processing");
            String id = DocIdUtil.getDeepDocumentId(jCas);
            Map<String, Long> cuiCounts = OntologyConceptUtil.getCuiCounts(jCas);
            CuiCollector.getInstance()._cuiCountMap.put(id, cuiCounts);
            LOGGER.info((Object)"Finished processing");
        }
    }
}

