/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.pipeline;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.resource.ResourceInitializationException;

public enum PipeBitLocator {
    INSTANCE;

    private static final Logger LOGGER;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private static final String[] CTAKES_PACKAGES;
    private final Collection<String> _userPackages = new HashSet<String>();

    public static PipeBitLocator getInstance() {
        return INSTANCE;
    }

    public Collection<String> getCtakesPackages() {
        return Arrays.stream(CTAKES_PACKAGES).map(p -> "org.apache.ctakes." + p).collect(Collectors.toList());
    }

    public Collection<String> getUserPackages() {
        return Collections.unmodifiableCollection(this._userPackages);
    }

    public void addUserPackage(String packagePath) {
        this._userPackages.add(packagePath);
    }

    public Class<? extends AnalysisComponent> getComponentClass(String className) throws ResourceInitializationException {
        Class<Object> componentClass;
        try {
            componentClass = Class.forName(className);
        }
        catch (ClassNotFoundException cnfE) {
            componentClass = this.getPackagedComponent(className);
        }
        if (componentClass == null) {
            throw new ResourceInitializationException("No Analysis Component found for " + className, EMPTY_OBJECT_ARRAY);
        }
        PipeBitLocator.assertClassType(componentClass, AnalysisComponent.class);
        return componentClass;
    }

    private Class<? extends AnalysisComponent> getPackagedComponent(String className) {
        Class<?> componentClass;
        for (String packageName : this._userPackages) {
            componentClass = PipeBitLocator.getPackagedClass(packageName, className, AnalysisComponent.class);
            if (componentClass == null) continue;
            return componentClass;
        }
        for (String packageName : this.getCtakesPackages()) {
            componentClass = PipeBitLocator.getPackagedClass(packageName + ".ae", className, AnalysisComponent.class);
            if (componentClass != null) {
                return componentClass;
            }
            componentClass = PipeBitLocator.getPackagedClass(packageName + ".cc", className, AnalysisComponent.class);
            if (componentClass != null) {
                return componentClass;
            }
            componentClass = PipeBitLocator.getPackagedClass(packageName, className, AnalysisComponent.class);
            if (componentClass == null) continue;
            return componentClass;
        }
        return null;
    }

    public Class<? extends CollectionReader> getReaderClass(String className) throws ResourceInitializationException {
        Class<Object> readerClass;
        try {
            readerClass = Class.forName(className);
        }
        catch (ClassNotFoundException cnfE) {
            readerClass = this.getPackagedReader(className);
        }
        if (readerClass == null) {
            throw new ResourceInitializationException("No Collection Reader found for " + className, EMPTY_OBJECT_ARRAY);
        }
        PipeBitLocator.assertClassType(readerClass, CollectionReader.class);
        return readerClass;
    }

    private Class<? extends CollectionReader> getPackagedReader(String className) {
        Class<?> readerClass;
        for (String packageName : this._userPackages) {
            readerClass = PipeBitLocator.getPackagedClass(packageName, className, CollectionReader.class);
            if (readerClass == null) continue;
            return readerClass;
        }
        for (String packageName : this.getCtakesPackages()) {
            readerClass = PipeBitLocator.getPackagedClass(packageName + ".cr", className, CollectionReader.class);
            if (readerClass != null) {
                return readerClass;
            }
            readerClass = PipeBitLocator.getPackagedClass(packageName, className, CollectionReader.class);
            if (readerClass == null) continue;
            return readerClass;
        }
        return null;
    }

    private static Class<?> getPackagedClass(String packageName, String className, Class<?> wantedClassType) {
        try {
            Class<?> classType = Class.forName(packageName + "." + className);
            if (PipeBitLocator.isClassType(classType, wantedClassType)) {
                return classType;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public AnalysisEngineDescription createDescription(String className, Object ... values) throws ResourceInitializationException {
        Method method;
        Class<? extends AnalysisComponent> componentClass = this.getComponentClass(className);
        try {
            method = values.length == 0 ? componentClass.getMethod("createAnnotatorDescription", new Class[0]) : componentClass.getMethod("createAnnotatorDescription", PipeBitLocator.getValueTypes(values));
        }
        catch (NoSuchMethodException nsmE) {
            try {
                method = values.length == 0 ? componentClass.getMethod("createEngineDescription", new Class[0]) : componentClass.getMethod("createEngineDescription", PipeBitLocator.getValueTypes(values));
            }
            catch (NoSuchMethodException nsmE2) {
                LOGGER.error((Object)("No createAnnotatorDescription or createEngineDescription method in " + className));
                throw new ResourceInitializationException((Throwable)nsmE2);
            }
        }
        try {
            Object invocation = method.invoke(null, values);
            if (!AnalysisEngineDescription.class.isInstance(invocation)) {
                LOGGER.error((Object)(method.getName() + " in " + className + " returned an " + invocation.getClass().getName() + " not an AnalysisEngineDescription"));
                throw new ResourceInitializationException();
            }
            return (AnalysisEngineDescription)invocation;
        }
        catch (IllegalAccessException | InvocationTargetException multE) {
            LOGGER.error((Object)("Could not invoke " + method.getName() + " on " + className));
            throw new ResourceInitializationException((Throwable)multE);
        }
    }

    private static Class<?>[] getValueTypes(Object ... values) {
        Class[] classArray = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            Class<?> type = values[i].getClass();
            classArray[i] = type.equals(Integer.class) ? Integer.TYPE : (type.equals(Boolean.class) ? Boolean.TYPE : type);
        }
        return classArray;
    }

    private static void assertClassType(Class<?> classType, Class<?> wantedClassType) throws ResourceInitializationException {
        if (!PipeBitLocator.isClassType(classType, wantedClassType)) {
            throw new ResourceInitializationException("Not " + wantedClassType.getSimpleName() + " " + classType.getName(), EMPTY_OBJECT_ARRAY);
        }
    }

    private static boolean isClassType(Class<?> classType, Class<?> wantedClassType) {
        return wantedClassType.isAssignableFrom(classType);
    }

    static {
        LOGGER = Logger.getLogger((String)"PipeBitFinder");
        EMPTY_OBJECT_ARRAY = new Object[0];
        CTAKES_PACKAGES = new String[]{"core", "context.tokenizer", "postagger", "chunker", "dictionary.lookup2", "dictionary.lookup.fast", "dictionary.lookup.cased", "dictionary.cased", "assertion", "assertion.medfacts.cleartk", "clinicalpipeline", "clinical.pipeline", "constituency.parser", "relationextractor", "relation.extractor", "coreference", "dependency.parser", "temporal", "pbj", "drug-ner", "necontexts", "ne.contexts", "preprocessor", "sideeffect", "smokingstatus", "smoking.status", "dictionary.lookup", "template.filler", "lvg", "examples"};
    }
}

