/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ctakes.core.cc.FileTreeXmiWriter;
import org.apache.ctakes.core.cc.pretty.html.HtmlTextWriter;
import org.apache.ctakes.core.cr.FileTreeReader;
import org.apache.ctakes.core.pipeline.CuiCollector;
import org.apache.ctakes.core.pipeline.EntityCollector;
import org.apache.ctakes.core.util.PropertyAeFactory;
import org.apache.ctakes.core.util.external.SystemUtil;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.fit.cpe.CpeBuilder;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.xml.sax.SAXException;

public final class PipelineBuilder {
    private static final Logger LOGGER = Logger.getLogger((String)"PipelineBuilder");
    private CollectionReaderDescription _readerDesc;
    private final List<String> _aeNameList = new ArrayList<String>();
    private final List<String[]> _aeViewList = new ArrayList<String[]>();
    private final List<AnalysisEngineDescription> _descList = new ArrayList<AnalysisEngineDescription>();
    private final List<String> _aeEndNameList = new ArrayList<String>();
    private final List<String[]> _aeEndViewList = new ArrayList<String[]>();
    private final List<AnalysisEngineDescription> _descEndList = new ArrayList<AnalysisEngineDescription>();
    private AnalysisEngineDescription _analysisEngineDesc;
    private boolean _pipelineChanged;
    private int _threadCount = 1;

    public void clear() {
        this._aeNameList.clear();
        this._aeViewList.clear();
        this._descList.clear();
        this._aeEndNameList.clear();
        this._aeEndViewList.clear();
        this._descEndList.clear();
        this._threadCount = 1;
    }

    public PipelineBuilder set(Object ... parameters) {
        PropertyAeFactory.getInstance().addParameters(parameters);
        this._pipelineChanged = true;
        return this;
    }

    public PipelineBuilder setIfEmpty(Object ... parameters) {
        PropertyAeFactory.getInstance().addIfEmptyParameters(parameters);
        this._pipelineChanged = true;
        return this;
    }

    public PipelineBuilder env(Object ... parameters) {
        SystemUtil.addEnvironmentVariables(parameters);
        return this;
    }

    public PipelineBuilder reader(CollectionReaderDescription description) {
        this._readerDesc = description;
        this._pipelineChanged = true;
        return this;
    }

    public PipelineBuilder reader(Class<? extends CollectionReader> readerClass, Object ... parameters) throws UIMAException {
        this.reader(PropertyAeFactory.getInstance().createReaderDescription(readerClass, parameters));
        return this;
    }

    public PipelineBuilder readFiles() throws UIMAException {
        return this.reader(CollectionReaderFactory.createReaderDescription(FileTreeReader.class, (Object[])new Object[0]));
    }

    public PipelineBuilder readFiles(String inputDirectory) throws UIMAException {
        return this.reader(FileTreeReader.class, "InputDirectory", inputDirectory);
    }

    public CollectionReaderDescription getReader() {
        return this._readerDesc;
    }

    public PipelineBuilder add(Class<? extends AnalysisComponent> component) throws ResourceInitializationException {
        return this.add(component, Collections.emptyList(), new Object[0]);
    }

    public PipelineBuilder add(Class<? extends AnalysisComponent> component, Collection<String> views, Object ... parameters) throws ResourceInitializationException {
        this._aeNameList.add(component.getName());
        this._aeViewList.add(PipelineBuilder.toStringArray(views));
        this._descList.add(PropertyAeFactory.getInstance().createDescription(component, parameters));
        this._pipelineChanged = true;
        return this;
    }

    public PipelineBuilder addLogged(Class<? extends AnalysisComponent> component, Collection<String> views, Object ... parameters) throws ResourceInitializationException {
        this._aeNameList.add(component.getName());
        this._aeViewList.add(PipelineBuilder.toStringArray(views));
        this._descList.add(PropertyAeFactory.getInstance().createLoggedDescription(component, parameters));
        this._pipelineChanged = true;
        return this;
    }

    public PipelineBuilder addDescription(AnalysisEngineDescription description) {
        return this.addDescription(description, Collections.emptyList());
    }

    public PipelineBuilder addDescription(AnalysisEngineDescription description, Collection<String> views) {
        this._aeNameList.add(description.getAnnotatorImplementationName());
        this._aeViewList.add(PipelineBuilder.toStringArray(views));
        this._descList.add(description);
        this._pipelineChanged = true;
        return this;
    }

    public PipelineBuilder addLast(Class<? extends AnalysisComponent> component, Collection<String> views, Object ... parameters) throws ResourceInitializationException {
        this._aeEndNameList.add(component.getName());
        this._aeEndViewList.add(PipelineBuilder.toStringArray(views));
        this._descEndList.add(PropertyAeFactory.getInstance().createDescription(component, parameters));
        this._pipelineChanged = true;
        return this;
    }

    public List<String> getAeNames() {
        ArrayList<String> allNames = new ArrayList<String>(this._aeNameList);
        allNames.addAll(this._aeEndNameList);
        return Collections.unmodifiableList(allNames);
    }

    public PipelineBuilder collectCuis() throws ResourceInitializationException {
        return this.add(CuiCollector.CuiCollectorEngine.class);
    }

    public PipelineBuilder collectEntities() throws ResourceInitializationException {
        return this.add(EntityCollector.EntityCollectorEngine.class);
    }

    public PipelineBuilder writeXMIs() throws ResourceInitializationException {
        return this.addLast(FileTreeXmiWriter.class, Collections.emptyList(), new Object[0]);
    }

    public PipelineBuilder writeXMIs(String outputDirectory) throws ResourceInitializationException {
        return this.addLast(FileTreeXmiWriter.class, Collections.emptyList(), "OutputDirectory", outputDirectory);
    }

    public PipelineBuilder writeHtml() throws ResourceInitializationException {
        return this.addLast(HtmlTextWriter.class, Collections.emptyList(), new Object[0]);
    }

    public PipelineBuilder writeHtml(String outputDirectory) throws ResourceInitializationException {
        return this.addLast(HtmlTextWriter.class, Collections.emptyList(), "OutputDirectory", outputDirectory);
    }

    public PipelineBuilder threads(int threadCount) {
        if (threadCount <= 1) {
            if (threadCount < 1) {
                LOGGER.warn((Object)("Thread count (" + threadCount + ") cannot be below 1.  Using 1 thread for processing."));
            }
            this._threadCount = 1;
            return this;
        }
        int coreCount = Runtime.getRuntime().availableProcessors();
        if (threadCount > coreCount) {
            LOGGER.warn((Object)("Thread count (" + threadCount + ") is greater than core count (" + coreCount + ").  Using core count for processing."));
            this._threadCount = coreCount;
            return this;
        }
        this._threadCount = threadCount;
        return this;
    }

    public int getThreadCount() {
        return this._threadCount;
    }

    public PipelineBuilder build() throws IOException, UIMAException {
        if (this._analysisEngineDesc == null || this._pipelineChanged) {
            int i;
            AggregateBuilder builder = new AggregateBuilder();
            for (i = 0; i < this._descList.size(); ++i) {
                builder.add(this._descList.get(i), this._aeViewList.get(i));
            }
            for (i = 0; i < this._descEndList.size(); ++i) {
                builder.add(this._descEndList.get(i), this._aeEndViewList.get(i));
            }
            this._analysisEngineDesc = builder.createAggregateDescription();
        }
        this._pipelineChanged = false;
        return this;
    }

    public PipelineBuilder run() throws IOException, UIMAException {
        if (this._readerDesc == null) {
            LOGGER.error((Object)"No Collection Reader specified.");
            return this;
        }
        this.build();
        if (this._threadCount == 1) {
            SimplePipeline.runPipeline((CollectionReaderDescription)this._readerDesc, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{this._analysisEngineDesc});
        } else {
            CpeBuilder cpeBuilder = new CpeBuilder();
            try {
                cpeBuilder.setReader(this._readerDesc);
                cpeBuilder.setAnalysisEngine(this._analysisEngineDesc);
                cpeBuilder.setMaxProcessingUnitThreadCount(this._threadCount);
                CollectionProcessingEngine cpe = cpeBuilder.createCpe(null);
                cpe.process();
            }
            catch (CpeDescriptorException | SAXException multE) {
                LOGGER.error((Object)multE.getMessage(), multE);
                throw new UIMAException(multE);
            }
        }
        return this;
    }

    public PipelineBuilder run(String text) throws IOException, UIMAException {
        if (this._readerDesc != null) {
            LOGGER.error((Object)"Collection Reader specified, ignoring.");
            return this;
        }
        JCas jcas = JCasFactory.createJCas();
        jcas.setDocumentText(text);
        return this.run(jcas);
    }

    public PipelineBuilder run(JCas jCas) throws IOException, UIMAException {
        if (this._readerDesc != null) {
            LOGGER.error((Object)"Collection Reader specified, ignoring.");
            return this;
        }
        this.build();
        SimplePipeline.runPipeline((JCas)jCas, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{this._analysisEngineDesc});
        return this;
    }

    public AnalysisEngineDescription getAnalysisEngineDesc() throws IOException, UIMAException {
        this.build();
        return this._analysisEngineDesc;
    }

    private static String[] toStringArray(Collection<String> things) {
        return new ArrayList<String>(things).toArray(new String[things.size()]);
    }
}

