/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.pipeline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ctakes.core.pipeline.CliOptionals;
import org.apache.ctakes.core.pipeline.CliOptionalsHandler;
import org.apache.ctakes.core.pipeline.PipeBitLocator;
import org.apache.ctakes.core.pipeline.PipelineBuilder;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.core.util.log.DotLogger;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;

public final class PiperFileReader {
    private static final Logger LOGGER = Logger.getLogger((String)"PiperFileReader");
    public static final String AE_VIEW_NAMES = "AeViews";
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+");
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("=");
    private static final Pattern KEY_VALUE_PATTERN_2 = Pattern.compile("[^\"=]+|(?:\"[^\"]*\")");
    private static final Pattern COMMA_ARRAY_PATTERN = Pattern.compile(",");
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private static final Pattern QUOTE_VALUE_PATTERN = Pattern.compile("(?:[^\"=\\s]+)|(?:\"[^\"\\r\\n]+\")");
    private static final Pattern NAME_VALUE_PATTERN = Pattern.compile("[^\"=\\s]+=(?:(?:[^\"=\\s]+)|(?:\"[^\"\\r\\n]+\"))");
    private static final Pattern VIEWS_PATTERN = Pattern.compile("AeViews=[^\\s]+");
    private PipelineBuilder _builder = new PipelineBuilder();
    private CliOptionals _cliOptionals;

    public PiperFileReader() {
    }

    public PiperFileReader(String filePath) throws UIMAException {
        this(filePath, null);
    }

    public PiperFileReader(String filePath, CliOptionals cliOptionals) throws UIMAException {
        if (cliOptionals != null) {
            this.setCliOptionals(cliOptionals);
        }
        if (!this.loadPipelineFile(filePath)) {
            LOGGER.error((Object)"Piper File contained invalid command or parameters, exiting cTAKES.");
            System.exit(1);
        }
    }

    public void setCliOptionals(CliOptionals cliOptionals) {
        this._cliOptionals = cliOptionals;
    }

    public boolean loadPipelineFile(String filePath) throws UIMAException {
        LOGGER.info((Object)("Loading Piper File " + filePath + " ..."));
        try (BufferedReader reader = this.getPiperReader(filePath);
             DotLogger logger = new DotLogger();){
            String line = reader.readLine();
            while (line != null) {
                this.parsePipelineLine(line.trim());
                line = reader.readLine();
            }
        }
        catch (IOException ioE) {
            LOGGER.error((Object)("Could not read piper file: " + filePath));
            throw new UIMAException((Throwable)ioE);
        }
        return true;
    }

    public boolean parsePipelineLine(String line) throws UIMAException {
        if (line.isEmpty() || line.startsWith("//") || line.startsWith("#") || line.startsWith("!")) {
            return true;
        }
        int spaceIndex = line.indexOf(32);
        if (spaceIndex < 0) {
            return this.addToPipeline(line, "");
        }
        return this.addToPipeline(line.substring(0, spaceIndex), line.substring(spaceIndex + 1).trim());
    }

    public PipelineBuilder getBuilder() {
        return this._builder;
    }

    private boolean addToPipeline(String command, String parameter) throws UIMAException {
        Collection<String> viewSpecs = PiperFileReader.getViewSpecs(parameter);
        Collection<String> views = PiperFileReader.getViews(viewSpecs);
        String info = PiperFileReader.removeViewSpecs(parameter, viewSpecs);
        switch (command) {
            case "load": {
                return this.loadPipelineFile(info);
            }
            case "package": {
                PipeBitLocator.getInstance().addUserPackage(info);
                return true;
            }
            case "set": {
                this._builder.set(PiperFileReader.splitParameters(info));
                return true;
            }
            case "cli": {
                this._builder.setIfEmpty(this.getCliParameters(info));
                return true;
            }
            case "env": {
                this._builder.env(PiperFileReader.splitParameters(info));
                return true;
            }
            case "reader": {
                if (PiperFileReader.hasParameters(info)) {
                    String[] component_parameters = PiperFileReader.splitFromParameters(info);
                    String component = component_parameters[0];
                    Object[] parameters = PiperFileReader.splitParameters(component_parameters[1]);
                    this._builder.reader(PipeBitLocator.getInstance().getReaderClass(component), parameters);
                } else {
                    this._builder.reader(PipeBitLocator.getInstance().getReaderClass(info), new Object[0]);
                }
                return true;
            }
            case "readFiles": {
                if (info.isEmpty()) {
                    this._builder.readFiles();
                } else {
                    this._builder.readFiles(info);
                }
                return true;
            }
            case "add": {
                if (PiperFileReader.hasParameters(info)) {
                    String[] component_parameters = PiperFileReader.splitFromParameters(info);
                    String component = component_parameters[0];
                    Object[] parameters = PiperFileReader.splitParameters(component_parameters[1]);
                    this._builder.add(PipeBitLocator.getInstance().getComponentClass(component), views, parameters);
                } else {
                    this._builder.add(PipeBitLocator.getInstance().getComponentClass(info), views, new Object[0]);
                }
                return true;
            }
            case "addLogged": {
                if (PiperFileReader.hasParameters(info)) {
                    String[] component_parameters = PiperFileReader.splitFromParameters(info);
                    String component = component_parameters[0];
                    Object[] parameters = PiperFileReader.splitParameters(component_parameters[1]);
                    this._builder.addLogged(PipeBitLocator.getInstance().getComponentClass(component), views, parameters);
                } else {
                    this._builder.addLogged(PipeBitLocator.getInstance().getComponentClass(info), views, new Object[0]);
                }
                return true;
            }
            case "addDescription": {
                if (PiperFileReader.hasParameters(info)) {
                    String[] descriptor_parameters = PiperFileReader.splitFromParameters(info);
                    String component = descriptor_parameters[0];
                    Object[] values = PiperFileReader.splitDescriptorValues(descriptor_parameters[1]);
                    AnalysisEngineDescription description = PipeBitLocator.getInstance().createDescription(component, values);
                    this._builder.addDescription(description, views);
                } else {
                    AnalysisEngineDescription description = PipeBitLocator.getInstance().createDescription(info, new Object[0]);
                    this._builder.addDescription(description, views);
                }
                return true;
            }
            case "addLast": {
                if (PiperFileReader.hasParameters(info)) {
                    String[] component_parameters = PiperFileReader.splitFromParameters(info);
                    String component = component_parameters[0];
                    Object[] parameters = PiperFileReader.splitParameters(component_parameters[1]);
                    this._builder.addLast(PipeBitLocator.getInstance().getComponentClass(component), views, parameters);
                } else {
                    this._builder.addLast(PipeBitLocator.getInstance().getComponentClass(info), views, new Object[0]);
                }
                return true;
            }
            case "threads": {
                return this.setThreadCount(info);
            }
            case "collectCuis": {
                this._builder.collectCuis();
                return true;
            }
            case "collectEntities": {
                this._builder.collectEntities();
                return true;
            }
            case "writeXmis": {
                if (info.isEmpty()) {
                    this._builder.writeXMIs();
                } else {
                    this._builder.writeXMIs(info);
                }
                return true;
            }
            case "writeHtml": {
                if (info.isEmpty()) {
                    this._builder.writeHtml();
                } else {
                    this._builder.writeHtml(info);
                }
                return true;
            }
        }
        LOGGER.error((Object)("Unknown Piper Command: " + command));
        return false;
    }

    private boolean setThreadCount(String info) {
        Object count = PiperFileReader.attemptParseInt(info);
        if (count instanceof Integer) {
            this._builder.threads((Integer)count);
            return true;
        }
        LOGGER.error((Object)("Could not parse thread count from " + info));
        return false;
    }

    public BufferedReader getPiperReader(String filePath) throws FileNotFoundException {
        InputStream stream = this.getPiperStream(filePath);
        if (stream == null) {
            throw new FileNotFoundException("No piper file found for " + filePath);
        }
        return new BufferedReader(new InputStreamReader(stream));
    }

    public InputStream getPiperStream(String filePath) {
        InputStream stream;
        if (!filePath.toLowerCase().endsWith(".piper")) {
            return this.getPiperStream(filePath + ".piper");
        }
        File piperFile = new File(filePath);
        String parentPath = null;
        if (piperFile.isAbsolute()) {
            parentPath = piperFile.getParent();
        } else {
            File located = FileLocator.getFileQuiet(filePath);
            if (located != null) {
                parentPath = located.getParent();
            }
        }
        if (parentPath != null && !parentPath.isEmpty() && !PipeBitLocator.getInstance().getUserPackages().contains(parentPath)) {
            PipeBitLocator.getInstance().addUserPackage(parentPath);
        }
        if ((stream = FileLocator.getStreamQuiet(filePath)) != null) {
            return stream;
        }
        for (String packageName : PipeBitLocator.getInstance().getUserPackages()) {
            stream = FileLocator.getStreamQuiet(packageName.replace('.', '/') + '/' + filePath);
            if (stream != null) {
                return stream;
            }
            stream = FileLocator.getStreamQuiet(packageName.replace('.', '/') + "/pipeline/" + filePath);
            if (stream == null) continue;
            return stream;
        }
        for (String packageName : PipeBitLocator.getInstance().getCtakesPackages()) {
            stream = FileLocator.getStreamQuiet(packageName.replace('.', '/') + '/' + filePath);
            if (stream != null) {
                return stream;
            }
            stream = FileLocator.getStreamQuiet(packageName.replace('.', '/') + "/pipeline/" + filePath);
            if (stream == null) continue;
            return stream;
        }
        LOGGER.error((Object)("No piper file found for " + filePath));
        return null;
    }

    private static boolean hasParameters(String text) {
        return SPACE_PATTERN.split(text).length > 1;
    }

    private static String[] splitFromParameters(String text) {
        String[] allSplits = SPACE_PATTERN.split(text);
        String[] returnSplits = new String[2];
        returnSplits[0] = allSplits[0];
        StringBuilder paramBuilder = new StringBuilder();
        paramBuilder.append(allSplits[1]);
        for (int i = 2; i < allSplits.length; ++i) {
            paramBuilder.append(" ").append(allSplits[i]);
        }
        returnSplits[1] = paramBuilder.toString();
        return returnSplits;
    }

    private static Object[] splitParameters(String text) {
        if (text == null || text.trim().isEmpty()) {
            return EMPTY_OBJECT_ARRAY;
        }
        Matcher matcher = NAME_VALUE_PATTERN.matcher(text);
        ArrayList<String> pairList = new ArrayList<String>();
        while (matcher.find()) {
            pairList.add(text.substring(matcher.start(), matcher.end()));
        }
        String[] pairs = pairList.toArray(new String[pairList.size()]);
        Object[] keysAndValues = new Object[pairs.length * 2];
        int i = 0;
        for (String pair : pairs) {
            Matcher kv_matcher = KEY_VALUE_PATTERN_2.matcher(pair);
            ArrayList<String> kvList = new ArrayList<String>();
            while (kv_matcher.find()) {
                kvList.add(pair.substring(kv_matcher.start(), kv_matcher.end()));
            }
            String[] keyAndValue = kvList.toArray(new String[kvList.size()]);
            keysAndValues[i] = keyAndValue[0];
            if (keyAndValue.length == 1) {
                keysAndValues[i + 1] = "";
                i += 2;
                continue;
            }
            if (keyAndValue.length > 2) {
                LOGGER.warn((Object)("Multiple parameter values, using first of " + pair));
            }
            keysAndValues[i + 1] = PiperFileReader.getValueObject(keyAndValue[1]);
            i += 2;
        }
        return keysAndValues;
    }

    private Object[] getCliParameters(String text) {
        if (this._cliOptionals == null) {
            LOGGER.warn((Object)"Attempted to set Parameter by Command-line options.  Command-line options are not specified.");
            return EMPTY_OBJECT_ARRAY;
        }
        if (text == null || text.trim().isEmpty()) {
            return EMPTY_OBJECT_ARRAY;
        }
        Matcher matcher = NAME_VALUE_PATTERN.matcher(text);
        ArrayList<String> pairList = new ArrayList<String>();
        while (matcher.find()) {
            pairList.add(text.substring(matcher.start(), matcher.end()));
        }
        String[] pairs = pairList.toArray(new String[pairList.size()]);
        Object[] keysAndValues = new Object[pairs.length * 2];
        int i = 0;
        for (String pair : pairs) {
            Matcher kv_matcher = KEY_VALUE_PATTERN_2.matcher(pair);
            ArrayList<String> kvList = new ArrayList<String>();
            while (kv_matcher.find()) {
                kvList.add(pair.substring(kv_matcher.start(), kv_matcher.end()));
            }
            String[] keyAndValue = kvList.toArray(new String[kvList.size()]);
            keysAndValues[i] = keyAndValue[0];
            if (keyAndValue.length == 1) {
                keysAndValues[i + 1] = "";
                i += 2;
                continue;
            }
            if (keyAndValue.length > 2) {
                LOGGER.warn((Object)("Multiple parameter values, using first of " + pair));
            }
            keysAndValues[i + 1] = PiperFileReader.getValueObject(CliOptionalsHandler.getCliOptionalValue(this._cliOptionals, keyAndValue[1]));
            i += 2;
        }
        return keysAndValues;
    }

    private static Collection<String> getViewSpecs(String text) {
        Matcher matcher = VIEWS_PATTERN.matcher(text);
        ArrayList<String> viewSpecs = new ArrayList<String>();
        while (matcher.find()) {
            viewSpecs.add(text.substring(matcher.start(), matcher.end()));
        }
        return viewSpecs;
    }

    private static String removeViewSpecs(String text, Collection<String> viewSpecs) {
        if (viewSpecs.isEmpty()) {
            return text;
        }
        String viewless = text;
        for (String viewSpec : viewSpecs) {
            viewless = viewless.replace(viewSpec, " ");
        }
        return viewless;
    }

    private static Collection<String> getViews(Collection<String> viewSpecs) {
        if (viewSpecs.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> views = new HashSet<String>();
        for (String viewSpec : viewSpecs) {
            String viewText = viewSpec.substring(AE_VIEW_NAMES.length() + 1);
            views.addAll(Arrays.asList(viewText.split(",")));
        }
        return views;
    }

    private static Object[] splitDescriptorValues(String text) {
        Matcher matcher = QUOTE_VALUE_PATTERN.matcher(text);
        ArrayList<String> valueList = new ArrayList<String>();
        while (matcher.find()) {
            valueList.add(text.substring(matcher.start(), matcher.end()));
        }
        String[] values = valueList.toArray(new String[valueList.size()]);
        Object[] valueObjects = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            valueObjects[i] = PiperFileReader.getValueObject(values[i]);
        }
        return valueObjects;
    }

    private static Object getValueObject(String value) {
        if (value.indexOf(34) >= 0) {
            return QUOTE_PATTERN.matcher(value).replaceAll("");
        }
        if (PiperFileReader.isCommaArray(value)) {
            return PiperFileReader.attemptParseArray(value);
        }
        Object returner = PiperFileReader.attemptParseBoolean(value);
        if (!value.equals(returner)) {
            return returner;
        }
        return PiperFileReader.attemptParseInt(value);
    }

    private static Object attemptParseInt(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException nfE) {
            return value;
        }
    }

    private static Object attemptParseBoolean(String value) {
        if (value.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return value;
    }

    private static boolean isCommaArray(String value) {
        return value.indexOf(44) > 0;
    }

    private static Object attemptParseArray(String value) {
        return COMMA_ARRAY_PATTERN.split(value);
    }
}

