/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.pipeline;

import com.lexicalscope.jewel.cli.CliFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Paths;
import org.apache.ctakes.core.pipeline.CliOptionals;
import org.apache.ctakes.core.pipeline.PipelineBuilder;
import org.apache.ctakes.core.pipeline.PiperFileReader;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAException;

public final class PiperFileRunner {
    private static final Logger LOGGER = Logger.getLogger((String)"PiperFileRunner");

    private PiperFileRunner() {
    }

    public static void main(String ... args) {
        if (!PiperFileRunner.run(args)) {
            System.exit(1);
        }
    }

    public static boolean run(String ... args) {
        CliOptionals options = (CliOptionals)CliFactory.parseArguments(CliOptionals.class, (String[])args);
        try {
            PiperFileReader reader = new PiperFileReader();
            PipelineBuilder builder = reader.getBuilder();
            String inputDir = options.getInputDirectory();
            if (!inputDir.isEmpty()) {
                builder.set("InputDirectory", inputDir);
            }
            String outputDir = options.getOutputDirectory();
            String xmiOutDir = options.getXmiOutDirectory();
            String htmlOutDir = options.getHtmlOutDirectory();
            if (!outputDir.isEmpty()) {
                builder.set("OutputDirectory", outputDir);
            } else if (!xmiOutDir.isEmpty()) {
                builder.set("OutputDirectory", xmiOutDir);
            } else if (!htmlOutDir.isEmpty()) {
                builder.set("OutputDirectory", htmlOutDir);
            }
            reader.setCliOptionals(options);
            reader.loadPipelineFile(options.getPiperPath());
            if (!inputDir.isEmpty() && builder.getReader() == null) {
                builder.readFiles(inputDir);
            }
            if (!xmiOutDir.isEmpty() && builder.getAeNames().stream().map(String::toLowerCase).noneMatch(n -> n.contains("xmiwriter"))) {
                builder.writeXMIs(xmiOutDir);
            }
            if (!htmlOutDir.isEmpty() && builder.getAeNames().stream().map(String::toLowerCase).noneMatch(n -> n.contains("htmlwriter"))) {
                builder.writeHtml(htmlOutDir);
            }
            builder.run();
        }
        catch (IOException | UIMAException multE) {
            LOGGER.error((Object)multE.getMessage());
            String logPath = Paths.get("cTAKES.error.log", new String[0]).toFile().getAbsolutePath();
            try {
                PrintStream stream = new PrintStream(logPath);
                multE.printStackTrace(stream);
                LOGGER.info((Object)("\nFor more information please see log file " + logPath));
                LOGGER.info((Object)"This is a log file on your machine listing information that may be useful in debugging your failed run.");
                LOGGER.info((Object)("Seriously, don't ignore this message.  If you want to get to the root of a problem, check the error log file " + logPath));
            }
            catch (FileNotFoundException fnfE) {
                LOGGER.warn((Object)("Could not write to log file " + logPath));
                multE.printStackTrace();
            }
            return false;
        }
        return true;
    }
}

