/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.pipeline;

import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.event.ChangeListener;

public enum ProgressManager {
    INSTANCE;

    public static final String PROGRESS_COMPLETE = "PROGRESS_COMPLETE";
    private String _name;
    private String _patientId;
    private String _docId;
    private final BoundedRangeModel _model = new DefaultBoundedRangeModel();

    public static ProgressManager getInstance() {
        return INSTANCE;
    }

    public void initializeProgress(String name, int max) {
        this._name = name;
        this._model.setRangeProperties(0, 0, 0, max, false);
    }

    public String getName() {
        if (this._name == null || this._name.trim().isEmpty()) {
            return "Progress";
        }
        return this._name;
    }

    public void updatePatientId(String patientId) {
        this._patientId = patientId;
    }

    public String getPatientId() {
        if (this._patientId == null || this._patientId.trim().isEmpty() || this._patientId.equals(PROGRESS_COMPLETE) || this._patientId.equals("UnknownPatient")) {
            return "";
        }
        return this._patientId;
    }

    public void updateDocId(String docId) {
        this._docId = docId;
    }

    public String getDocId() {
        if (this._docId == null || this._docId.trim().isEmpty() || this._docId.equals(PROGRESS_COMPLETE) || this._docId.equals("UnknownDocument")) {
            return "";
        }
        return this._docId;
    }

    public void updateProgress(int value) {
        if (value <= this._model.getValue()) {
            return;
        }
        if (this._model.getMaximum() < value) {
            this._model.setMaximum(value);
        }
        this._model.setValue(value);
    }

    public void updateProgress(int value, int max) {
        this._model.setMaximum(max);
        this.updateProgress(value);
    }

    public BoundedRangeModel getModel() {
        return this._model;
    }

    public void addListener(ChangeListener listener) {
        this._model.addChangeListener(listener);
    }

    public void removeListener(ChangeListener listener) {
        this._model.removeChangeListener(listener);
    }
}

