/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.pipeline;

import com.lexicalscope.jewel.cli.Option;

public interface StandardCliOptions {
    public static final String UMLS_KEY = "key";
    public static final String USER_NAME = "user";
    public static final String PASSWORD = "pass";
    public static final String PIPER_FILE = "piper";
    public static final String INPUT_DIR = "inputDir";
    public static final String OUTPUT_DIR = "outputDir";
    public static final String SUB_DIR = "subDir";
    public static final String XMI_OUT_DIR = "xmiOut";
    public static final String HTML_OUT_DIR = "htmlOut";
    public static final String PIP_PBJ = "pipPbj";

    @Option(shortName={"p"}, longName={"piper"}, description="path to the piper file containing commands and parameters for pipeline configuration.", defaultValue={""})
    public String getPiperPath();

    @Option(shortName={"i"}, longName={"inputDir"}, description="path to the directory containing the clinical notes to be processed.", defaultValue={""})
    public String getInputDirectory();

    @Option(shortName={"o"}, longName={"outputDir"}, description="path to the directory where the output files are to be written.", defaultValue={""})
    public String getOutputDirectory();

    @Option(longName={"subDir"}, description="path to a subdirectory for output files.", defaultValue={""})
    public String getSubDirectory();

    @Option(longName={"xmiOut"}, description="path to the directory where xmi files are to be written.  Adds XmiWriter to pipeline.", defaultValue={""})
    public String getXmiOutDirectory();

    @Option(longName={"htmlOut"}, description="path to the directory where html files are to be written.  Adds HtmlWriter to pipeline.", defaultValue={""})
    public String getHtmlOutDirectory();

    @Option(longName={"user"}, description="username.", defaultValue={""})
    public String getUserName();

    @Option(longName={"pass"}, description="password.", defaultValue={""})
    public String getPassword();

    @Option(longName={"key"}, description="UMLS API Key.", defaultValue={""})
    public String getUmlsApiKey();

    @Option(longName={"pipPbj"}, description="pip ctakes-PBJ.", defaultValue={"yes"})
    public String getPipPbj();

    @Option(shortName={"?"}, longName={"help"}, description="print usage.", helpRequest=true)
    public boolean isHelpWanted();
}

