/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.resource;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;

public final class FileLocator {
    private static final Logger LOGGER = Logger.getLogger((String)"FileLocator");
    private static final String CTAKES_HOME = "CTAKES_HOME";

    private FileLocator() {
    }

    private static Collection<String> getUrlSearchPaths(String location) {
        String loci = location;
        if (loci.startsWith("\"") && loci.endsWith("\"")) {
            loci = loci.substring(1, loci.length() - 1);
        }
        ArrayList<String> paths = new ArrayList<String>(2);
        paths.add(loci);
        paths.add("resources/" + loci);
        return paths;
    }

    private static Collection<String> getFileSearchPaths(String location) {
        String cTakesHome;
        String loci = location;
        if (loci.startsWith("\"") && loci.endsWith("\"")) {
            loci = loci.substring(1, loci.length() - 1);
        }
        ArrayList<String> paths = new ArrayList<String>();
        String dir = System.getProperty("user.dir");
        if (dir != null && !dir.isEmpty()) {
            paths.add(dir + "/" + loci);
            paths.add(dir + "/resources/" + loci);
        }
        if ((cTakesHome = System.getenv(CTAKES_HOME)) != null && !cTakesHome.isEmpty()) {
            paths.add(cTakesHome + "/" + loci);
            paths.add(cTakesHome + "/resources/" + loci);
        }
        if (dir != null && !dir.isEmpty()) {
            File ancestor = new File(dir);
            while (ancestor.getParentFile() != null) {
                ancestor = ancestor.getParentFile();
                paths.add(ancestor + "/" + loci);
                paths.add(ancestor + "/ctakes/" + loci);
                paths.add(ancestor + "/resources/" + loci);
            }
        }
        return paths;
    }

    private static Collection<String> getAllSearchPaths(String location) {
        ArrayList<String> locations = new ArrayList<String>(FileLocator.getUrlSearchPaths(location));
        locations.addAll(FileLocator.getFileSearchPaths(location));
        return locations;
    }

    public static InputStream getAsStream(String location) throws FileNotFoundException {
        return FileLocator.getAsStream(FileLocator.class, location);
    }

    public static InputStream getAsStream(Class<?> clazz, String location) throws FileNotFoundException {
        InputStream stream = FileLocator.getStreamQuiet(clazz, location);
        if (stream != null) {
            return stream;
        }
        throw new FileNotFoundException("No stream available for " + location);
    }

    public static InputStream getStreamQuiet(String location) {
        return FileLocator.getStreamQuiet(FileLocator.class, location);
    }

    public static InputStream getStreamQuiet(Class<?> clazz, String location) {
        URL url;
        Collection<String> urlPaths = FileLocator.getUrlSearchPaths(location);
        InputStream stream = urlPaths.stream().map(l -> FileLocator.getStreamOnly(clazz, l)).filter(Objects::nonNull).findFirst().orElse(null);
        if (stream != null) {
            return stream;
        }
        Collection<String> allPaths = FileLocator.getAllSearchPaths(location);
        File file = allPaths.stream().map(FileLocator::getFileOnly).filter(Objects::nonNull).findFirst().orElse(null);
        if (file != null) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if ((url = (URL)urlPaths.stream().map(l -> FileLocator.getResourceOnly(clazz, l)).filter(Objects::nonNull).findFirst().orElse(null)) != null) {
            try {
                URI indexUri = new URI(url.toExternalForm());
                if (!indexUri.isOpaque()) {
                    return new FileInputStream(new File(indexUri));
                }
            }
            catch (FileNotFoundException | URISyntaxException multE) {
                return null;
            }
        }
        return null;
    }

    private static InputStream getStreamOnly(Class<?> clazz, String location) {
        try {
            InputStream stream = clazz.getClassLoader().getResourceAsStream(location);
            if (stream != null) {
                return stream;
            }
            stream = clazz.getResourceAsStream(location);
            if (stream != null) {
                return stream;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static URL getResource(String location) throws FileNotFoundException {
        return FileLocator.getResource(FileLocator.class, location);
    }

    public static URL getResource(Class<?> clazz, String location) throws FileNotFoundException {
        URL url = FileLocator.getResourceQuiet(clazz, location);
        if (url != null) {
            return url;
        }
        throw new FileNotFoundException("No Resource at " + location);
    }

    public static URL getResourceQuiet(String location) {
        return FileLocator.getResourceQuiet(FileLocator.class, location);
    }

    public static URL getResourceQuiet(Class<?> clazz, String location) {
        URL url;
        Collection<String> allPaths = FileLocator.getAllSearchPaths(location);
        File file = allPaths.stream().map(FileLocator::getFileOnly).filter(Objects::nonNull).findFirst().orElse(null);
        if (file != null) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if ((url = (URL)FileLocator.getUrlSearchPaths(location).stream().map(l -> FileLocator.getResourceOnly(clazz, l)).filter(Objects::nonNull).findFirst().orElse(null)) != null) {
            return url;
        }
        return null;
    }

    private static URL getResourceOnly(Class<?> clazz, String location) {
        ClassLoader classLoader = clazz.getClassLoader();
        URL url = classLoader.getResource(location);
        if (url != null) {
            LOGGER.debug((Object)(location + " found at " + url.toExternalForm()));
            return url;
        }
        return clazz.getResource(location);
    }

    @Deprecated
    public static File locateFile(String location) throws FileNotFoundException {
        return FileLocator.locateFile(FileLocator.class, location);
    }

    @Deprecated
    public static File locateFile(Class<?> clazz, String location) throws FileNotFoundException {
        return FileLocator.getFile(clazz, location);
    }

    public static File getFile(String location) throws FileNotFoundException {
        return FileLocator.getFile(FileLocator.class, location);
    }

    public static File getFile(Class<?> clazz, String location) throws FileNotFoundException {
        File file = FileLocator.getFileQuiet(clazz, location);
        if (file != null) {
            return file;
        }
        throw new FileNotFoundException("No File found for " + location);
    }

    public static File getFileQuiet(String location) {
        return FileLocator.getFileQuiet(FileLocator.class, location);
    }

    public static File getFileQuiet(Class<?> clazz, String location) {
        InputStream stream;
        Collection<String> allPaths = FileLocator.getAllSearchPaths(location);
        File file = allPaths.stream().map(FileLocator::getFileOnly).filter(Objects::nonNull).findFirst().orElse(null);
        if (file != null) {
            return file;
        }
        Collection<String> urlPaths = FileLocator.getUrlSearchPaths(location);
        URL url = urlPaths.stream().map(l -> FileLocator.getResourceOnly(clazz, l)).filter(Objects::nonNull).findFirst().orElse(null);
        if (url != null) {
            try {
                URI uri = new URI(url.toExternalForm());
                if (!uri.isOpaque()) {
                    return new File(uri);
                }
            }
            catch (URISyntaxException uri) {
                // empty catch block
            }
        }
        if ((stream = (InputStream)urlPaths.stream().map(l -> FileLocator.getStreamOnly(clazz, l)).filter(Objects::nonNull).findFirst().orElse(null)) != null) {
            return FileLocator.createTempFile(stream, location);
        }
        return null;
    }

    private static File getFileOnly(String location) {
        File file;
        String loci = location;
        if (loci.startsWith("\"") && loci.endsWith("\"")) {
            loci = loci.substring(1, loci.length() - 1);
        }
        if ((file = new File(loci)).exists()) {
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File createTempFile(InputStream stream, String location) {
        String loci = location;
        if (loci.startsWith("\"") && loci.endsWith("\"")) {
            loci = loci.substring(1, loci.length() - 1);
        }
        String tempName = loci.replace('/', '_').replace('\\', '_');
        TempFileHolder tempFileHolder = TempFileHolder.INSTANCE;
        synchronized (tempFileHolder) {
            File file2 = TempFileHolder.INSTANCE.getFile(tempName);
            if (file2 != null) {
                return file2;
            }
            try (BufferedInputStream reader = new BufferedInputStream(stream);){
                File tempFile = File.createTempFile(tempName, null);
                tempFile.deleteOnExit();
                Files.copy(reader, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                TempFileHolder.INSTANCE.addFile(tempName, tempFile);
                File file = TempFileHolder.INSTANCE.getFile(tempName);
                return file;
            }
            catch (IOException ioE) {
                LOGGER.error((Object)ioE.getMessage());
                return null;
            }
        }
    }

    @Deprecated
    public static String getFullPath(String relativePath) throws FileNotFoundException {
        return FileLocator.getFullPath(FileLocator.class, relativePath);
    }

    @Deprecated
    public static String getFullPath(Class<?> clazz, String relativePath) throws FileNotFoundException {
        URL[] classpathUrls;
        String fullPath = FileLocator.getFullPathQuiet(clazz, relativePath);
        if (fullPath != null && !fullPath.isEmpty()) {
            return fullPath;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Could not find ").append(relativePath).append("\nas absolute or in $CLASSPATH :\n");
        ClassLoader classLoader = clazz.getClassLoader();
        for (URL url : classpathUrls = ((URLClassLoader)classLoader).getURLs()) {
            sb.append(url.getFile()).append("\n");
        }
        String cwd = System.getProperty("user.dir");
        sb.append("or in working directory : ").append(cwd).append("\n");
        sb.append("or in any parent thereof (with or without /ctakes/)\n");
        String cTakesHome = System.getenv(CTAKES_HOME);
        sb.append("or in $CTAKES_HOME : ").append(cTakesHome);
        LOGGER.error((Object)sb.toString());
        throw new FileNotFoundException("No File exists at " + relativePath);
    }

    @Deprecated
    public static String getFullPathQuiet(String relativePath) {
        return FileLocator.getFullPathQuiet(FileLocator.class, relativePath);
    }

    @Deprecated
    public static String getFullPathQuiet(Class<?> clazz, String relativePath) {
        File file = FileLocator.getFileQuiet(clazz, relativePath);
        if (file == null) {
            return "";
        }
        return file.getPath();
    }

    private static enum TempFileHolder {
        INSTANCE;

        private final Map<String, File> __tempFiles = new HashMap<String, File>();

        private void addFile(String name, File file) {
            this.__tempFiles.putIfAbsent(name, file);
        }

        private File getFile(String name) {
            return this.__tempFiles.get(name);
        }
    }
}

