/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.resource;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.log4j.Logger;

public final class FileReadWriteUtil {
    private static final Logger LOGGER = Logger.getLogger((String)"FileReadWriteUtil");

    private FileReadWriteUtil() {
    }

    public static String readText(String path) throws IOException {
        InputStream stream = FileLocator.getAsStream(path);
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        return sb.toString();
    }

    public static List<String> readLines(String path) throws IOException {
        InputStream stream = FileLocator.getAsStream(path);
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    public static void writeText(String text, String filepath) throws IOException {
        Path path = Paths.get(filepath, new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(text);
        }
    }
}

