/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.sentence;

import java.util.ArrayList;
import java.util.List;

public class SentenceSpan {
    public static String LF = "\n";
    public static String CR = "\r";
    public static String CRLF = "\r\n";
    private int start;
    private int end;
    private String text;

    public SentenceSpan(int s, int e, String t) {
        this.start = s;
        this.end = e;
        this.text = t;
    }

    public void setStart(int in) {
        this.start = in;
    }

    public void setEnd(int in) {
        this.end = in;
    }

    public void setText(String in) {
        this.text = in;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getText() {
        return this.text;
    }

    public List<SentenceSpan> splitAtLineBreaksAndTrim(String separatorPattern) {
        ArrayList<SentenceSpan> subspans = new ArrayList<SentenceSpan>();
        if (!(separatorPattern.equals(LF) || separatorPattern.equals(CR) || separatorPattern.equals(CRLF))) {
            int len = separatorPattern.length();
            System.err.println("Invalid line break: " + len + " characters long.");
            System.err.print("        line break character values: ");
            for (int i = 0; i < len; ++i) {
                System.err.print((Object)separatorPattern.charAt(i));
                System.err.print(" ");
            }
            System.err.println();
            subspans.add(this);
            return subspans;
        }
        String coveredText = this.text.substring(0, this.end - this.start);
        String trimmedText = coveredText.trim();
        int trimmedLen = trimmedText.length();
        if (trimmedLen == 0) {
            return subspans;
        }
        int positionOfNonWhiteSpace = 0;
        String[] spans = coveredText.split(separatorPattern);
        int position = this.start;
        for (String s : spans) {
            String t = s.trim();
            positionOfNonWhiteSpace = t.length() > 0 ? s.indexOf(t.charAt(0)) : 0;
            subspans.add(new SentenceSpan(position += positionOfNonWhiteSpace, position + t.length(), t));
            position += s.length() - positionOfNonWhiteSpace + separatorPattern.length();
        }
        return subspans;
    }

    public String toString() {
        String s = "(" + this.start + ", " + this.end + ") " + this.text;
        return s;
    }
}

