/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util;

import java.security.InvalidParameterException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.apache.ctakes.core.util.annotation.IdentifiedAnnotationBuilder;
import org.apache.ctakes.core.util.annotation.SemanticTui;
import org.apache.ctakes.typesystem.type.refsem.Time;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public final class CalendarUtil {
    public static final Calendar NULL_CALENDAR = new Calendar.Builder().setDate(1, 1, 1).build();
    private static final Collection<String> DATE_FORMAT_CODES = Arrays.asList("M-d-yy", "MM-dd-yy", "MM-dd-yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "MMM d", "MMM yyyy", "MMM d yyyy", "dd-MMM-yy", "dd-MMM-yyyy");
    private static final Collection<String> TIME_FORMAT_CODES = Arrays.asList("h:mm", "h:mm a", "h:mm:ss", "h:mm:ss.SSS", "h:mm z", "h:mm a z", "h:mm a, z", "h a", "h 'o''clock'", "h 'o''clock' a");
    private static final Collection<DateFormat> DATE_FORMATS = new ArrayList<DateFormat>();
    private static final Collection<DateFormat> DATE_TIME_FORMATS = new ArrayList<DateFormat>();
    private static final IdentifiedAnnotationBuilder _builder = new IdentifiedAnnotationBuilder().creator(TimeMention::new).type(SemanticTui.T079);

    private CalendarUtil() {
    }

    public static TimeMention createTimeMention(JCas jCas, int begin, int end) {
        String docText = jCas.getDocumentText();
        if (begin < 0 || end > docText.length() || begin >= end) {
            throw new InvalidParameterException("Offsets " + begin + "," + end + " are outside document bounds 0," + docText.length());
        }
        String text = docText.substring(begin, end);
        TimeMention timeMention = CalendarUtil.createTimeMention(jCas, text);
        timeMention.setBegin(begin);
        timeMention.setEnd(end);
        return timeMention;
    }

    public static TimeMention createTimeMention(JCas jCas, int begin, int end, Calendar calendar) {
        String docText = jCas.getDocumentText();
        if (begin < 0 || end > docText.length() || begin >= end) {
            throw new InvalidParameterException("Offsets " + begin + "," + end + " are outside document bounds 0," + docText.length());
        }
        TimeMention timeMention = CalendarUtil.createTimeMention(jCas, calendar);
        timeMention.setBegin(begin);
        timeMention.setEnd(end);
        return timeMention;
    }

    public static TimeMention createTimeMention(JCas jCas, String text) {
        return CalendarUtil.createTimeMention(jCas, CalendarUtil.getCalendar(text));
    }

    public static TimeMention createTimeMention(JCas jCas, Calendar calendar) {
        org.apache.ctakes.typesystem.type.refsem.Date date = CalendarUtil.createTypeDate(jCas, calendar);
        Time time = CalendarUtil.createTypeTime(jCas, calendar);
        TimeMention timeMention = (TimeMention)_builder.build(jCas);
        timeMention.setDate(date);
        timeMention.setTime(time);
        timeMention.setTimeClass("DATE");
        return timeMention;
    }

    public static org.apache.ctakes.typesystem.type.refsem.Date createTypeDate(JCas jCas, String text) {
        Calendar calendar = CalendarUtil.getCalendar(text);
        return CalendarUtil.createTypeDate(jCas, calendar);
    }

    public static org.apache.ctakes.typesystem.type.refsem.Date createTypeDate(JCas jCas, Calendar calendar) {
        org.apache.ctakes.typesystem.type.refsem.Date date = new org.apache.ctakes.typesystem.type.refsem.Date(jCas);
        date.setDay("" + calendar.get(5));
        date.setMonth("" + (calendar.get(2) + 1));
        date.setYear("" + calendar.get(1));
        return date;
    }

    public static Time createTypeTime(JCas jCas, String text) {
        Calendar calendar = CalendarUtil.getCalendar(text);
        return CalendarUtil.createTypeTime(jCas, calendar);
    }

    public static Time createTypeTime(JCas jCas, Calendar calendar) {
        Time time = new Time(jCas);
        time.setNormalizedForm(calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13) + " " + calendar.get(9));
        return time;
    }

    public static Calendar getCalendar(Annotation annotation) {
        if (annotation instanceof TimeMention) {
            return CalendarUtil.getTimeMentionCalendar((TimeMention)annotation);
        }
        return CalendarUtil.getCalendar(annotation.getCoveredText());
    }

    public static Calendar getCalendar(String text) {
        Calendar calendar = Calendar.getInstance();
        for (DateFormat format : DATE_FORMATS) {
            try {
                Date date = format.parse(text);
                calendar.setTime(date);
                return calendar;
            }
            catch (ParseException date) {
            }
        }
        for (DateFormat format : DATE_TIME_FORMATS) {
            try {
                Date date = format.parse(text);
                calendar.setTime(date);
                return calendar;
            }
            catch (ParseException parseException) {
            }
        }
        return NULL_CALENDAR;
    }

    private static Calendar getTimeMentionCalendar(TimeMention timeMention) {
        if (timeMention == null) {
            return NULL_CALENDAR;
        }
        org.apache.ctakes.typesystem.type.refsem.Date typeDate = timeMention.getDate();
        Calendar typeCalendar = CalendarUtil.getCalendar(typeDate);
        if (!NULL_CALENDAR.equals(typeCalendar)) {
            return typeCalendar;
        }
        return CalendarUtil.getCalendar(timeMention.getCoveredText());
    }

    private static Calendar getCalendar(org.apache.ctakes.typesystem.type.refsem.Date typeDate) {
        if (typeDate == null) {
            return NULL_CALENDAR;
        }
        int year = CalendarUtil.parseInt(typeDate.getYear());
        int month = CalendarUtil.parseInt(typeDate.getMonth());
        int day = CalendarUtil.parseInt(typeDate.getDay());
        if (year == Integer.MIN_VALUE && month == Integer.MIN_VALUE && day == Integer.MIN_VALUE) {
            return NULL_CALENDAR;
        }
        ArrayList<Integer> fields = new ArrayList<Integer>(6);
        if (year != Integer.MIN_VALUE) {
            fields.add(1);
            fields.add(year);
        }
        if (month != Integer.MIN_VALUE) {
            fields.add(2);
            fields.add(month - 1);
        }
        if (day != Integer.MIN_VALUE) {
            fields.add(5);
            fields.add(day);
        }
        int[] array = new int[fields.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Integer)fields.get(i);
        }
        return new Calendar.Builder().setFields(array).build();
    }

    private static int parseInt(String text) {
        if (text == null || text.isEmpty()) {
            return Integer.MIN_VALUE;
        }
        for (char c : text.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return Integer.MIN_VALUE;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException nfE) {
            return Integer.MIN_VALUE;
        }
    }

    static {
        for (String date : DATE_FORMAT_CODES) {
            DATE_FORMATS.add(new SimpleDateFormat(date));
            DATE_FORMATS.add(new SimpleDateFormat("EEE " + date));
            DATE_FORMATS.add(new SimpleDateFormat("EEE, " + date));
            for (String time : TIME_FORMAT_CODES) {
                DATE_TIME_FORMATS.add(new SimpleDateFormat(date + " " + time));
                DATE_TIME_FORMATS.add(new SimpleDateFormat(date + " 'at' " + time));
                DATE_TIME_FORMATS.add(new SimpleDateFormat("EEE " + date + " " + time));
                DATE_TIME_FORMATS.add(new SimpleDateFormat("EEE, " + date + " 'at' " + time));
                DATE_TIME_FORMATS.add(new SimpleDateFormat(time + " " + date));
                DATE_TIME_FORMATS.add(new SimpleDateFormat(time + " 'on' " + date));
                DATE_TIME_FORMATS.add(new SimpleDateFormat(time + ", EEE " + date));
                DATE_TIME_FORMATS.add(new SimpleDateFormat(time + " 'on' EEE " + date));
                DATE_TIME_FORMATS.add(new SimpleDateFormat(time + " 'on' EEE, " + date));
            }
        }
    }
}

