/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util;

import java.util.Comparator;
import org.apache.log4j.Logger;

public class NumberedSuffixComparator
implements Comparator<String> {
    private static final Logger LOGGER = Logger.getLogger((String)"NumberedSuffixComparator");

    @Override
    public int compare(String text1, String text2) {
        int len1 = text1.length();
        int len2 = text2.length();
        int i1 = 0;
        int i2 = 0;
        while (i1 < len1 && i2 < len2) {
            char c1 = text1.charAt(i1);
            char c2 = text2.charAt(i2);
            if (Character.isDigit(c1) && Character.isDigit(c2)) {
                String numText2;
                String numText1 = NumberedSuffixComparator.getIntText(text1, i1);
                int value = NumberedSuffixComparator.compareNumText(numText1, numText2 = NumberedSuffixComparator.getIntText(text2, i2));
                if (value != 0) {
                    return value;
                }
                value = numText1.length() - numText2.length();
                if (value != 0) {
                    return value;
                }
                i1 += numText1.length();
                i2 += numText2.length();
                continue;
            }
            int value = Character.compare(c1, c2);
            if (value != 0) {
                return value;
            }
            ++i1;
            ++i2;
        }
        if (len1 < len2) {
            return -1;
        }
        if (len2 < len1) {
            return 1;
        }
        return 0;
    }

    private static String getIntText(String text, int index) {
        StringBuilder sb = new StringBuilder();
        int length = text.length();
        for (int i = index; i < length; ++i) {
            char c = text.charAt(i);
            if (!Character.isDigit(c)) {
                return sb.toString();
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static int compareNumText(String numText1, String numText2) {
        try {
            long num1 = Long.parseUnsignedLong(numText1);
            long num2 = Long.parseUnsignedLong(numText2);
            return Long.compare(num1, num2);
        }
        catch (NumberFormatException nfE) {
            LOGGER.debug((Object)nfE.getMessage(), (Throwable)nfE);
            return 0;
        }
    }
}

