/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.ctakes.core.ae.StartFinishLogger;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.TypeSystemDescription;

public enum PropertyAeFactory {
    INSTANCE;

    private static final Logger LOGGER;
    private final Map<String, Object> _properties = new HashMap<String, Object>();
    private TypeSystemDescription _typeSystemDescription;

    public static PropertyAeFactory getInstance() {
        return INSTANCE;
    }

    private PropertyAeFactory() {
        try {
            this._typeSystemDescription = TypeSystemDescriptionFactory.createTypeSystemDescription();
        }
        catch (ResourceInitializationException riE) {
            Logger.getLogger((String)"PropertyAeFactory").error((Object)("Could not initialize cTAKES Type System\n" + riE.getMessage()));
            System.exit(-1);
        }
    }

    public synchronized void addParameters(Object ... parameters) {
        if (parameters.length == 0) {
            LOGGER.warn((Object)"No parameters specified.");
            return;
        }
        if (parameters.length % 2 != 0) {
            LOGGER.error((Object)"Odd number of parameters provided.  Should be key value pairs.");
            return;
        }
        PropertyAeFactory.addToMap(this._properties, parameters);
    }

    public synchronized void addIfEmptyParameters(Object ... parameters) {
        if (parameters.length == 0) {
            LOGGER.warn((Object)"No parameters specified.");
            return;
        }
        if (parameters.length % 2 != 0) {
            LOGGER.error((Object)"Odd number of parameters provided.  Should be key value pairs.");
            return;
        }
        for (int i = 0; i < parameters.length; i += 2) {
            String name;
            if (parameters[i] instanceof String) {
                name = (String)parameters[i];
            } else {
                LOGGER.warn((Object)("Parameter " + i + " not a String, using " + parameters[i].toString()));
                name = parameters[i].toString();
            }
            if (this._properties.containsKey(name) && parameters[i + 1].toString().isEmpty()) {
                LOGGER.info((Object)("Parameter " + name + " has value " + this._properties.get(name) + " ; ignoring empty value"));
                continue;
            }
            this._properties.put(name, parameters[i + 1]);
        }
    }

    private static Object[] createParameters(Map<String, Object> parameterMap) {
        Object[] parameters = new Object[parameterMap.size() * 2];
        int i = 0;
        for (Map.Entry<String, Object> entry : parameterMap.entrySet()) {
            parameters[i] = entry.getKey();
            parameters[i + 1] = entry.getValue();
            i += 2;
        }
        return parameters;
    }

    private synchronized Object[] getAllParameters(Object ... parameters) {
        if (parameters.length == 0) {
            return PropertyAeFactory.createParameters(this._properties);
        }
        if (parameters.length % 2 != 0) {
            LOGGER.error((Object)"Odd number of parameters provided.  Should be key value pairs.");
            return PropertyAeFactory.createParameters(this._properties);
        }
        if (this._properties.isEmpty()) {
            return parameters;
        }
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(this._properties);
        PropertyAeFactory.addToMap(parameterMap, parameters);
        return PropertyAeFactory.createParameters(parameterMap);
    }

    public CollectionReaderDescription createReaderDescription(Class<? extends CollectionReader> readerClass, Object ... parameters) throws ResourceInitializationException {
        Object[] allParameters = this.getAllParameters(parameters);
        return CollectionReaderFactory.createReaderDescription(readerClass, (Object[])allParameters);
    }

    public AnalysisEngine createEngine(Class<? extends AnalysisComponent> classType, Object ... parameters) throws ResourceInitializationException {
        AnalysisEngineDescription description = this.createDescription(classType, parameters);
        Object[] allParameters = this.getAllParameters(parameters);
        return AnalysisEngineFactory.createEngine((AnalysisEngineDescription)description, (Object[])allParameters);
    }

    public AnalysisEngineDescription createDescription(Class<? extends AnalysisComponent> classType, Object ... parameters) throws ResourceInitializationException {
        Object[] allParameters = this.getAllParameters(parameters);
        return AnalysisEngineFactory.createEngineDescription(classType, (TypeSystemDescription)this._typeSystemDescription, (Object[])allParameters);
    }

    public AnalysisEngine createLoggedEngine(Class<? extends AnalysisComponent> classType, Object ... parameters) throws ResourceInitializationException {
        Object[] allParameters = this.getAllParameters(parameters);
        return StartFinishLogger.createLoggedEngine(classType, allParameters);
    }

    public AnalysisEngineDescription createLoggedDescription(Class<? extends AnalysisComponent> classType, Object ... parameters) throws ResourceInitializationException {
        Object[] allParameters = this.getAllParameters(parameters);
        return StartFinishLogger.createLoggedDescription(classType, allParameters);
    }

    public static AnalysisEngineDescription createLoggedDescription(AnalysisEngineDescription mainDescription) throws ResourceInitializationException {
        return StartFinishLogger.createLoggedDescription(mainDescription);
    }

    private static void addToMap(Map<String, Object> map, Object ... parameters) {
        for (int i = 0; i < parameters.length; i += 2) {
            if (parameters[i] instanceof String) {
                map.put((String)parameters[i], parameters[i + 1]);
                continue;
            }
            LOGGER.warn((Object)("Parameter " + i + " not a String, using " + parameters[i].toString()));
            map.put(parameters[i].toString(), parameters[i + 1]);
        }
    }

    static {
        LOGGER = Logger.getLogger((String)"PropertyAeFactory");
    }
}

