/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.LocationOfTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

@Immutable
public final class RelationArgumentUtil {
    private static final Logger LOGGER = Logger.getLogger((String)"RelationUtil");

    private RelationArgumentUtil() {
    }

    public static Collection<IdentifiedAnnotation> getFirstArguments(Collection<? extends BinaryTextRelation> relations, IdentifiedAnnotation annotation) {
        return relations.stream().filter(r -> r.getArg2().getArgument().equals((Object)annotation)).map(r -> r.getArg1().getArgument()).filter(IdentifiedAnnotation.class::isInstance).map(a -> (IdentifiedAnnotation)a).collect(Collectors.toList());
    }

    public static Collection<IdentifiedAnnotation> getSecondArguments(Collection<? extends BinaryTextRelation> relations, IdentifiedAnnotation annotation) {
        return relations.stream().filter(r -> r.getArg1().getArgument().equals((Object)annotation)).map(r -> r.getArg2().getArgument()).filter(IdentifiedAnnotation.class::isInstance).map(a -> (IdentifiedAnnotation)a).collect(Collectors.toList());
    }

    public static Collection<IdentifiedAnnotation> getAllRelated(Collection<? extends BinaryTextRelation> relations, IdentifiedAnnotation annotation) {
        return relations.stream().map(r -> RelationArgumentUtil.getRelated(r, annotation)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Map.Entry<BinaryTextRelation, IdentifiedAnnotation> getRelationEntry(BinaryTextRelation relation, IdentifiedAnnotation annotation) {
        IdentifiedAnnotation related = RelationArgumentUtil.getRelated(relation, annotation);
        if (related == null) {
            return null;
        }
        return new AbstractMap.SimpleEntry<BinaryTextRelation, IdentifiedAnnotation>(relation, related);
    }

    public static Map<BinaryTextRelation, IdentifiedAnnotation> getAllRelatedMap(Collection<BinaryTextRelation> relations, IdentifiedAnnotation annotation) {
        HashMap<BinaryTextRelation, IdentifiedAnnotation> map = new HashMap<BinaryTextRelation, IdentifiedAnnotation>();
        relations.stream().map(r -> RelationArgumentUtil.getRelationEntry(r, annotation)).filter(Objects::nonNull).forEach(e -> {
            IdentifiedAnnotation cfr_ignored_0 = (IdentifiedAnnotation)map.put((BinaryTextRelation)e.getKey(), (IdentifiedAnnotation)e.getValue());
        });
        return map;
    }

    private static IdentifiedAnnotation getRelated(BinaryTextRelation relation, IdentifiedAnnotation annotation) {
        Annotation argument = null;
        if (relation.getArg1().getArgument().equals((Object)annotation)) {
            argument = relation.getArg2().getArgument();
        } else if (relation.getArg2().getArgument().equals((Object)annotation)) {
            argument = relation.getArg1().getArgument();
        }
        if (argument != null && IdentifiedAnnotation.class.isInstance(argument)) {
            return (IdentifiedAnnotation)argument;
        }
        return null;
    }

    private static IdentifiedAnnotation getTarget(BinaryTextRelation relation, IdentifiedAnnotation annotation) {
        if (!relation.getArg1().getArgument().equals((Object)annotation)) {
            return null;
        }
        Annotation argument = relation.getArg2().getArgument();
        if (argument != null && IdentifiedAnnotation.class.isInstance(argument)) {
            return (IdentifiedAnnotation)argument;
        }
        return null;
    }

    private static Map.Entry<BinaryTextRelation, IdentifiedAnnotation> getRelationTargetEntry(BinaryTextRelation relation, IdentifiedAnnotation annotation) {
        IdentifiedAnnotation related = RelationArgumentUtil.getTarget(relation, annotation);
        if (related == null) {
            return null;
        }
        return new AbstractMap.SimpleEntry<BinaryTextRelation, IdentifiedAnnotation>(relation, related);
    }

    public static Map<BinaryTextRelation, IdentifiedAnnotation> getRelatedTargetsMap(Collection<BinaryTextRelation> relations, IdentifiedAnnotation annotation) {
        HashMap<BinaryTextRelation, IdentifiedAnnotation> map = new HashMap<BinaryTextRelation, IdentifiedAnnotation>();
        relations.stream().map(r -> RelationArgumentUtil.getRelationTargetEntry(r, annotation)).filter(Objects::nonNull).forEach(e -> {
            IdentifiedAnnotation cfr_ignored_0 = (IdentifiedAnnotation)map.put((BinaryTextRelation)e.getKey(), (IdentifiedAnnotation)e.getValue());
        });
        return map;
    }

    public static <T extends BinaryTextRelation> Collection<T> getRelationsAsFirst(Collection<T> relations, IdentifiedAnnotation annotation) {
        return relations.stream().filter(r -> r.getArg1().getArgument().equals((Object)annotation)).collect(Collectors.toList());
    }

    public static <T extends BinaryTextRelation> Collection<T> getRelationsAsSecond(Collection<T> relations, IdentifiedAnnotation annotation) {
        return relations.stream().filter(r -> r.getArg2().getArgument().equals((Object)annotation)).collect(Collectors.toList());
    }

    public static Map<IdentifiedAnnotation, Collection<IdentifiedAnnotation>> createCandidateMap(JCas jcas, List<IdentifiedAnnotation> candidates, List<IdentifiedAnnotation> mainAnnotations) {
        if (candidates.isEmpty()) {
            return Collections.emptyMap();
        }
        Map coveringSentences = JCasUtil.indexCovering((JCas)jcas, IdentifiedAnnotation.class, Sentence.class);
        HashMap<IdentifiedAnnotation, Collection<IdentifiedAnnotation>> candidateMap = new HashMap<IdentifiedAnnotation, Collection<IdentifiedAnnotation>>(candidates.size());
        int nextJ = mainAnnotations.size() - 1;
        for (int i = candidates.size() - 1; i >= 0; --i) {
            IdentifiedAnnotation candidate = candidates.get(i);
            int candidateBegin = candidate.getBegin();
            HashSet<IdentifiedAnnotation> candidateMains = new HashSet<IdentifiedAnnotation>();
            for (int j = nextJ; j >= 0; --j) {
                IdentifiedAnnotation main = mainAnnotations.get(j);
                int mainEnd = main.getEnd();
                if (mainEnd > candidateBegin && !candidate.equals((Object)main)) {
                    candidateMains.add(main);
                    if (j != 0) continue;
                    nextJ = -1;
                    break;
                }
                nextJ = j;
                break;
            }
            if (candidateMains.isEmpty()) continue;
            candidateMap.put(candidate, candidateMains);
        }
        if (nextJ >= 0) {
            IdentifiedAnnotation main = mainAnnotations.get(nextJ);
            IdentifiedAnnotation firstCandidate = candidates.get(0);
            if (!firstCandidate.equals((Object)main) && ((Collection)coveringSentences.get(main)).equals(coveringSentences.get(firstCandidate))) {
                Collection candidateMains = candidateMap.computeIfAbsent(firstCandidate, s -> new HashSet(1));
                candidateMains.add(main);
            }
        }
        return candidateMap;
    }

    public static BinaryTextRelation createRelation(JCas jCas, IdentifiedAnnotation argument, IdentifiedAnnotation target, String name) {
        if (name.equals("hasBodySite")) {
            return RelationArgumentUtil.createRelation(jCas, new LocationOfTextRelation(jCas), argument, target, name);
        }
        return RelationArgumentUtil.createRelation(jCas, new BinaryTextRelation(jCas), argument, target, name);
    }

    public static <T extends BinaryTextRelation> T createRelation(JCas jCas, T relation, IdentifiedAnnotation argument, IdentifiedAnnotation target, String name) {
        if (argument == null) {
            LOGGER.info((Object)("No argument for " + (target != null ? target.getCoveredText() : "")));
            return null;
        }
        if (target == null) {
            LOGGER.info((Object)("No target to relate to " + argument.getCoveredText()));
            return null;
        }
        if (argument.equals((Object)target)) {
            LOGGER.warn((Object)("Argument and target are identical " + argument.getCoveredText()));
            return null;
        }
        RelationArgument relationArgument = new RelationArgument(jCas);
        relationArgument.setArgument((Annotation)argument);
        relationArgument.setRole("Argument");
        relationArgument.addToIndexes();
        RelationArgument relationTarget = new RelationArgument(jCas);
        relationTarget.setArgument((Annotation)target);
        relationTarget.setRole("Related_to");
        relationTarget.addToIndexes();
        relation.setArg1(relationArgument);
        relation.setArg2(relationTarget);
        relation.setCategory(name);
        relation.addToIndexes();
        return relation;
    }
}

