/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util.annotation;

import org.apache.ctakes.core.util.annotation.SemanticTui;
import org.apache.ctakes.typesystem.type.refsem.OntologyConcept;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.uima.jcas.JCas;

public final class ConceptBuilder {
    private String _schema = "";
    private String _code = "";
    private double _score = Double.MIN_VALUE;
    private boolean _disambiguated = false;
    private SemanticTui _type = SemanticTui.UNKNOWN;
    private String _cui = "C0000000";
    private String _prefText = "Unknown UMLS Concept";
    private boolean _isUmls = false;

    public ConceptBuilder schema(String schema) {
        this._schema = schema;
        return this;
    }

    public ConceptBuilder code(String code) {
        this._code = code;
        return this;
    }

    public ConceptBuilder score(double score) {
        this._score = score;
        return this;
    }

    public ConceptBuilder disambiguated() {
        return this.disambiguated(true);
    }

    public ConceptBuilder disambiguated(boolean disambiguated) {
        this._disambiguated = disambiguated;
        return this;
    }

    public ConceptBuilder type(SemanticTui semanticType) {
        this._type = semanticType;
        this._isUmls = true;
        return this;
    }

    public ConceptBuilder type(String semanticType) {
        return this.type(SemanticTui.getTui(semanticType));
    }

    public ConceptBuilder tui(int tui) {
        return this.type(SemanticTui.getTui(tui));
    }

    public ConceptBuilder tui(String tui) {
        return this.type(SemanticTui.getTui(tui));
    }

    public ConceptBuilder cui(String cui) {
        this._cui = cui;
        this._isUmls = true;
        return this;
    }

    public ConceptBuilder preferredText(String text) {
        this._prefText = text;
        this._isUmls = true;
        return this;
    }

    private boolean isUmls() {
        return this._isUmls;
    }

    public OntologyConcept build(JCas jcas) {
        UmlsConcept concept;
        if (this.isUmls()) {
            concept = new UmlsConcept(jcas);
            concept.setCui(this._cui);
            if (this._type != SemanticTui.UNKNOWN) {
                concept.setTui(this._type.name());
            }
            if (!this._prefText.isEmpty()) {
                concept.setPreferredText(this._prefText);
            }
        } else {
            concept = new OntologyConcept(jcas);
        }
        if (!this._schema.isEmpty()) {
            concept.setCodingScheme(this._schema);
            concept.setCode(this._code);
            if (this._score != Double.MIN_VALUE) {
                concept.setScore(this._score);
            }
            if (this._disambiguated) {
                concept.setDisambiguated(true);
            }
        }
        return concept;
    }
}

