/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ctakes.core.util.textspan.TextSpan;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.log4j.Logger;
import org.apache.uima.fit.util.FSCollectionFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.tcas.Annotation;

public final class EssentialAnnotationUtil {
    private static final Logger LOGGER = Logger.getLogger((String)"EssentialAnnotationUtil");
    private static final Pattern N_DOT_PATTERN = Pattern.compile("N..?");
    private static final Predicate<Annotation> ESSENTIALS = a -> EventMention.class.isInstance(a) || TimeMention.class.isInstance(a) || EntityMention.class.isInstance(a);

    private EssentialAnnotationUtil() {
    }

    private static Collection<IdentifiedAnnotation> getEssentialAnnotations(Collection<IdentifiedAnnotation> annotations) {
        return annotations.stream().filter(ESSENTIALS).collect(Collectors.toList());
    }

    private static void cullToEssentialAnnotations(Collection<Collection<IdentifiedAnnotation>> annotationCollections) {
        HashSet keepers = new HashSet();
        for (Collection<IdentifiedAnnotation> annotations : annotationCollections) {
            annotations.stream().filter(ESSENTIALS).forEach(keepers::add);
            annotations.retainAll(keepers);
            keepers.clear();
        }
    }

    private static Collection<IdentifiedAnnotation> getNonEssentialAnnotations(Collection<IdentifiedAnnotation> allAnnotations, Collection<IdentifiedAnnotation> essentialAnnotations) {
        return allAnnotations.stream().filter(a -> !essentialAnnotations.contains(a)).filter(a -> !Markable.class.isInstance(a)).collect(Collectors.toList());
    }

    public static Collection<IdentifiedAnnotation> getRequiredAnnotations(JCas jCas, Map<IdentifiedAnnotation, Collection<Integer>> corefIndexed) {
        return EssentialAnnotationUtil.getRequiredAnnotations(jCas, JCasUtil.select((JCas)jCas, IdentifiedAnnotation.class), corefIndexed);
    }

    public static Collection<IdentifiedAnnotation> getRequiredAnnotations(JCas jCas, Collection<IdentifiedAnnotation> allAnnotations, Map<IdentifiedAnnotation, Collection<Integer>> corefIndexed) {
        return EssentialAnnotationUtil.getRequiredAnnotations(allAnnotations, corefIndexed, JCasUtil.select((JCas)jCas, BinaryTextRelation.class));
    }

    public static Collection<IdentifiedAnnotation> getRequiredAnnotations(Collection<IdentifiedAnnotation> allAnnotations, Map<IdentifiedAnnotation, Collection<Integer>> corefIndexed, Collection<BinaryTextRelation> relations) {
        Collection<IdentifiedAnnotation> essentialAnnotations = EssentialAnnotationUtil.getEssentialAnnotations(allAnnotations);
        HashSet<IdentifiedAnnotation> requiredAnnotations = new HashSet<IdentifiedAnnotation>(essentialAnnotations);
        requiredAnnotations.addAll(corefIndexed.keySet());
        requiredAnnotations.addAll(EssentialAnnotationUtil.getRelationAnnotations(relations));
        return requiredAnnotations;
    }

    public static Map<IdentifiedAnnotation, Collection<Integer>> createMarkableCorefs(JCas jCas) {
        Collection corefs = JCasUtil.select((JCas)jCas, CollectionTextRelation.class);
        Map<Markable, IdentifiedAnnotation> markableAnnotations = EssentialAnnotationUtil.mapMarkableAnnotations(jCas, corefs);
        return EssentialAnnotationUtil.createMarkableCorefs(corefs, markableAnnotations);
    }

    public static Map<IdentifiedAnnotation, Collection<Integer>> createMarkableCorefs(Collection<CollectionTextRelation> corefs, Map<Markable, IdentifiedAnnotation> markableAnnotations) {
        if (corefs == null || corefs.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<IdentifiedAnnotation, Collection<Integer>> corefMarkables = new HashMap<IdentifiedAnnotation, Collection<Integer>>();
        int index = 1;
        for (CollectionTextRelation coref : corefs) {
            FSList chainHead = coref.getMembers();
            Collection markables = FSCollectionFactory.create((FSList)chainHead, Markable.class);
            for (Markable markable : markables) {
                IdentifiedAnnotation annotation = markableAnnotations.get(markable);
                corefMarkables.putIfAbsent(annotation, new ArrayList());
                ((Collection)corefMarkables.get(annotation)).add(index);
            }
            ++index;
        }
        return corefMarkables;
    }

    public static Map<IdentifiedAnnotation, Collection<Integer>> createMarkableAssertedCorefs(Collection<CollectionTextRelation> corefs, Map<Markable, IdentifiedAnnotation> markableAnnotations) {
        if (corefs == null || corefs.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList<List> chains = new ArrayList<List>();
        for (CollectionTextRelation coref : corefs) {
            HashMap<String, List> assertionMap = new HashMap<String, List>();
            FSList fSList = coref.getMembers();
            Collection markables = FSCollectionFactory.create((FSList)fSList, Markable.class);
            for (Markable markable : markables) {
                IdentifiedAnnotation annotation = markableAnnotations.get(markable);
                String assertion = EssentialAnnotationUtil.getAssertion(annotation);
                assertionMap.computeIfAbsent(assertion, a -> new ArrayList()).add(annotation);
            }
            for (List asserted : assertionMap.values()) {
                if (asserted.size() <= 1) continue;
                asserted.sort(Comparator.comparingInt(Annotation::getBegin));
                chains.add(asserted);
            }
        }
        chains.sort((l1, l2) -> ((IdentifiedAnnotation)l1.get(0)).getBegin() - ((IdentifiedAnnotation)l2.get(0)).getBegin());
        HashMap<IdentifiedAnnotation, Collection<Integer>> corefMarkables = new HashMap<IdentifiedAnnotation, Collection<Integer>>();
        int index = 1;
        for (Collection collection : chains) {
            for (IdentifiedAnnotation annotation : collection) {
                corefMarkables.computeIfAbsent(annotation, a -> new ArrayList()).add(index);
            }
            ++index;
        }
        return corefMarkables;
    }

    public static Map<IdentifiedAnnotation, Collection<Integer>> createAllMarkableAssertedCorefs(JCas jCas) {
        Collection corefs = JCasUtil.select((JCas)jCas, CollectionTextRelation.class);
        Map<Markable, Collection<IdentifiedAnnotation>> markableAnnotations = EssentialAnnotationUtil.mapAllMarkableAnnotations(jCas, corefs);
        return EssentialAnnotationUtil.createAllMarkableAssertedCorefs(corefs, markableAnnotations);
    }

    public static Map<IdentifiedAnnotation, Collection<Integer>> createAllMarkableAssertedCorefs(Collection<CollectionTextRelation> corefs, Map<Markable, Collection<IdentifiedAnnotation>> markableAnnotations) {
        if (corefs == null || corefs.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList<List> chains = new ArrayList<List>();
        for (CollectionTextRelation coref : corefs) {
            HashMap<String, List> assertionMap = new HashMap<String, List>();
            FSList fSList = coref.getMembers();
            Collection markables = FSCollectionFactory.create((FSList)fSList, Markable.class);
            for (Markable markable : markables) {
                for (IdentifiedAnnotation annotation : markableAnnotations.get(markable)) {
                    String assertion = EssentialAnnotationUtil.getAssertion(annotation);
                    assertionMap.computeIfAbsent(assertion, a -> new ArrayList()).add(annotation);
                }
            }
            for (List asserted : assertionMap.values()) {
                if (asserted.size() <= 1) continue;
                asserted.sort(Comparator.comparingInt(Annotation::getBegin));
                chains.add(asserted);
            }
        }
        chains.sort((l1, l2) -> ((IdentifiedAnnotation)l1.get(0)).getBegin() - ((IdentifiedAnnotation)l2.get(0)).getBegin());
        HashMap<IdentifiedAnnotation, Collection<Integer>> corefMarkables = new HashMap<IdentifiedAnnotation, Collection<Integer>>();
        int index = 1;
        for (Collection collection : chains) {
            for (IdentifiedAnnotation annotation : collection) {
                corefMarkables.computeIfAbsent(annotation, a -> new ArrayList()).add(index);
            }
            ++index;
        }
        return corefMarkables;
    }

    private static String getAssertion(IdentifiedAnnotation annotation) {
        StringBuilder sb = new StringBuilder();
        if (annotation.getPolarity() == -1) {
            sb.append("AFFIRMED");
        } else {
            sb.append("NEGATED");
        }
        if (annotation.getUncertainty() == 1) {
            sb.append("UNCERTAIN");
        }
        if (annotation.getGeneric()) {
            sb.append("GENERIC");
        }
        if (annotation.getConditional()) {
            sb.append("CONDITIONAL");
        }
        return sb.toString();
    }

    private static Map<Markable, IdentifiedAnnotation> mapMarkableAnnotations(JCas jCas, Collection<CollectionTextRelation> corefs) {
        if (corefs == null || corefs.isEmpty()) {
            return Collections.emptyMap();
        }
        Map markableNodes = JCasUtil.indexCovered((JCas)jCas, Markable.class, ConllDependencyNode.class);
        Map nodeAnnotations = JCasUtil.indexCovering((JCas)jCas, ConllDependencyNode.class, IdentifiedAnnotation.class);
        HashMap<Markable, IdentifiedAnnotation> annotationMap = new HashMap<Markable, IdentifiedAnnotation>();
        for (CollectionTextRelation coref : corefs) {
            Collection markables = JCasUtil.select((FSList)coref.getMembers(), Markable.class);
            for (Markable markable : markables) {
                Collection nodes = (Collection)markableNodes.get(markable);
                if (nodes == null || nodes.isEmpty()) continue;
                ConllDependencyNode headNode = EssentialAnnotationUtil.getNominalHeadNode(new ArrayList<ConllDependencyNode>(nodes));
                Collection headNodeAnnotations = (Collection)nodeAnnotations.get(headNode);
                Collection<IdentifiedAnnotation> essentialAnnotations = EssentialAnnotationUtil.getEssentialAnnotations(headNodeAnnotations);
                Collection<IdentifiedAnnotation> nonEssentialAnnotations = EssentialAnnotationUtil.getNonEssentialAnnotations(headNodeAnnotations, essentialAnnotations);
                IdentifiedAnnotation bestAnnotation = null;
                int bestLength = Integer.MAX_VALUE;
                for (IdentifiedAnnotation annotation : essentialAnnotations) {
                    if (!EventMention.class.equals(annotation.getClass()) && annotation.getBegin() == markable.getBegin() && annotation.getEnd() == markable.getEnd()) {
                        bestAnnotation = annotation;
                        break;
                    }
                    if (annotation.getEnd() - annotation.getBegin() >= bestLength) continue;
                    bestLength = annotation.getEnd() - annotation.getBegin();
                    bestAnnotation = annotation;
                }
                if (bestAnnotation != null) {
                    annotationMap.put(markable, bestAnnotation);
                    continue;
                }
                for (IdentifiedAnnotation annotation : nonEssentialAnnotations) {
                    if (annotation.getEnd() - annotation.getBegin() >= bestLength) continue;
                    bestLength = annotation.getEnd() - annotation.getBegin();
                    bestAnnotation = annotation;
                }
                if (bestAnnotation != null) {
                    annotationMap.put(markable, bestAnnotation);
                    continue;
                }
                annotationMap.put(markable, (IdentifiedAnnotation)markable);
            }
        }
        return annotationMap;
    }

    public static Map<Markable, Collection<IdentifiedAnnotation>> mapAllMarkableAnnotations(JCas jCas, Collection<CollectionTextRelation> corefs) {
        if (corefs == null || corefs.isEmpty()) {
            return Collections.emptyMap();
        }
        Map markableNodes = JCasUtil.indexCovered((JCas)jCas, Markable.class, ConllDependencyNode.class);
        Map nodeAnnotations = JCasUtil.indexCovering((JCas)jCas, ConllDependencyNode.class, IdentifiedAnnotation.class);
        HashMap<Markable, Collection<IdentifiedAnnotation>> annotationMap = new HashMap<Markable, Collection<IdentifiedAnnotation>>();
        for (CollectionTextRelation coref : corefs) {
            Collection markables = JCasUtil.select((FSList)coref.getMembers(), Markable.class);
            for (Markable markable : markables) {
                Collection nodes = (Collection)markableNodes.get(markable);
                if (nodes == null || nodes.isEmpty()) {
                    LOGGER.warn((Object)("No Dependency node for markable " + markable.getCoveredText()));
                    continue;
                }
                ConllDependencyNode headNode = EssentialAnnotationUtil.getNominalHeadNode(new ArrayList<ConllDependencyNode>(nodes));
                Collection headNodeAnnotations = (Collection)nodeAnnotations.get(headNode);
                Collection<IdentifiedAnnotation> essentialAnnotations = EssentialAnnotationUtil.getEssentialAnnotations(headNodeAnnotations);
                Collection<IdentifiedAnnotation> nonEssentialAnnotations = EssentialAnnotationUtil.getNonEssentialAnnotations(headNodeAnnotations, essentialAnnotations);
                ArrayList<IdentifiedAnnotation> bestAnnotations = new ArrayList<IdentifiedAnnotation>();
                ArrayList<IdentifiedAnnotation> overlapAnnotations = new ArrayList<IdentifiedAnnotation>();
                int bestLength = Integer.MAX_VALUE;
                for (IdentifiedAnnotation annotation : essentialAnnotations) {
                    if (!EventMention.class.equals(annotation.getClass()) && annotation.getBegin() == markable.getBegin() && annotation.getEnd() == markable.getEnd() && !bestAnnotations.contains(annotation)) {
                        bestAnnotations.add(annotation);
                    }
                    if ((annotation.getBegin() > markable.getBegin() || markable.getEnd() > annotation.getEnd()) && (markable.getBegin() > annotation.getBegin() || annotation.getEnd() > markable.getEnd()) || annotation.getEnd() - annotation.getBegin() >= bestLength) continue;
                    bestLength = annotation.getEnd() - annotation.getBegin();
                    overlapAnnotations.add(annotation);
                }
                if (bestAnnotations.isEmpty() && bestLength != Integer.MAX_VALUE) {
                    for (IdentifiedAnnotation annotation : overlapAnnotations) {
                        if (annotation.getEnd() - annotation.getBegin() != bestLength) continue;
                        bestAnnotations.add(annotation);
                    }
                }
                if (!bestAnnotations.isEmpty()) {
                    annotationMap.put(markable, bestAnnotations);
                    continue;
                }
                for (IdentifiedAnnotation annotation : nonEssentialAnnotations) {
                    if ((annotation.getBegin() > markable.getBegin() || markable.getEnd() > annotation.getEnd()) && (markable.getBegin() > annotation.getBegin() || annotation.getEnd() > markable.getEnd()) || annotation.getEnd() - annotation.getBegin() >= bestLength) continue;
                    bestLength = annotation.getEnd() - annotation.getBegin();
                    overlapAnnotations.add(annotation);
                }
                if (bestAnnotations.isEmpty() && bestLength != Integer.MAX_VALUE) {
                    for (IdentifiedAnnotation annotation : overlapAnnotations) {
                        if (annotation.getEnd() - annotation.getBegin() != bestLength) continue;
                        bestAnnotations.add(annotation);
                    }
                }
                if (!bestAnnotations.isEmpty()) {
                    annotationMap.put(markable, bestAnnotations);
                    continue;
                }
                annotationMap.put(markable, Collections.singletonList(markable));
            }
        }
        return annotationMap;
    }

    public static ConllDependencyNode getNominalHeadNode(List<ConllDependencyNode> nodes) {
        int i;
        ArrayList<ConllDependencyNode> anodes = new ArrayList<ConllDependencyNode>(nodes);
        Boolean[][] matrixofheads = new Boolean[anodes.size()][anodes.size()];
        ArrayList<ConllDependencyNode> outnodes = new ArrayList<ConllDependencyNode>();
        for (i = 0; i < anodes.size(); ++i) {
            if (anodes.get(i).getId() != 0) continue;
            anodes.remove(i);
        }
        for (int id1 = 0; id1 < anodes.size(); ++id1) {
            for (int id2 = 0; id2 < anodes.size(); ++id2) {
                matrixofheads[id2][id1] = id1 != id2 && anodes.get(id2).getHead() != null && anodes.get(id1).getId() == anodes.get(id2).getHead().getId();
            }
        }
        for (int idhd = 0; idhd < anodes.size(); ++idhd) {
            boolean occupiedCol = false;
            for (int row = 0; row < anodes.size(); ++row) {
                if (!matrixofheads[row][idhd].booleanValue()) continue;
                occupiedCol = true;
            }
            if (!occupiedCol) continue;
            boolean occupiedRow = false;
            for (int col = 0; col < anodes.size(); ++col) {
                if (!matrixofheads[idhd][col].booleanValue()) continue;
                occupiedRow = true;
            }
            if (occupiedRow) continue;
            outnodes.add(anodes.get(idhd));
        }
        if (outnodes.isEmpty()) {
            for (i = 0; i < anodes.size(); ++i) {
                if (anodes.get(i) == null || anodes.get(i).getPostag() == null || !N_DOT_PATTERN.matcher(anodes.get(i).getPostag()).matches()) continue;
                return anodes.get(i);
            }
            return anodes.get(anodes.size() - 1);
        }
        for (i = 0; i < outnodes.size(); ++i) {
            if (outnodes.get(i) == null || ((ConllDependencyNode)outnodes.get(i)).getPostag() == null || !N_DOT_PATTERN.matcher(((ConllDependencyNode)outnodes.get(i)).getPostag()).matches()) continue;
            return (ConllDependencyNode)outnodes.get(i);
        }
        return (ConllDependencyNode)outnodes.get(outnodes.size() - 1);
    }

    public static Collection<IdentifiedAnnotation> getRelationAnnotations(Collection<BinaryTextRelation> relations) {
        HashSet<IdentifiedAnnotation> relationAnnotations = new HashSet<IdentifiedAnnotation>();
        for (BinaryTextRelation relation : relations) {
            RelationArgument arg1 = relation.getArg1();
            Annotation source = arg1.getArgument();
            if (!(source instanceof IdentifiedAnnotation)) {
                LOGGER.error((Object)("Relation source is not an IdentifiedAnnotation " + source.getCoveredText()));
                continue;
            }
            IdentifiedAnnotation sourceIA = (IdentifiedAnnotation)source;
            RelationArgument arg2 = relation.getArg2();
            Annotation target = arg2.getArgument();
            if (!(target instanceof IdentifiedAnnotation)) {
                LOGGER.error((Object)("Relation target is not an IdentifiedAnnotation " + source.getCoveredText()));
                continue;
            }
            IdentifiedAnnotation targetIA = (IdentifiedAnnotation)target;
            relationAnnotations.add(sourceIA);
            relationAnnotations.add(targetIA);
        }
        return relationAnnotations;
    }

    private static Collection<IdentifiedAnnotation> getEventMentions(Collection<IdentifiedAnnotation> annotations) {
        return annotations.stream().filter(a -> EventMention.class.equals(a.getClass())).collect(Collectors.toList());
    }

    private static Map<IdentifiedAnnotation, Collection<IdentifiedAnnotation>> getAnnotationEvents(Map<TextSpan, Collection<IdentifiedAnnotation>> annotationMap) {
        HashMap<IdentifiedAnnotation, Collection<IdentifiedAnnotation>> annotationEvents = new HashMap<IdentifiedAnnotation, Collection<IdentifiedAnnotation>>();
        HashMap unusedEvents = new HashMap();
        for (Map.Entry<TextSpan, Collection<IdentifiedAnnotation>> entry : annotationMap.entrySet()) {
            Collection<IdentifiedAnnotation> collection = entry.getValue();
            Collection<IdentifiedAnnotation> eventMentions = EssentialAnnotationUtil.getEventMentions(collection);
            if (eventMentions == null || eventMentions.isEmpty()) continue;
            if (collection.size() > 1) {
                int pre = annotationEvents.size();
                collection.stream().filter(EventMention.class::isInstance).filter(a -> !eventMentions.contains(a)).forEach(a -> annotationEvents.put((IdentifiedAnnotation)a, eventMentions));
                if (annotationEvents.size() > pre) {
                    collection.removeAll(eventMentions);
                    continue;
                }
                unusedEvents.put(entry.getKey(), eventMentions);
                continue;
            }
            unusedEvents.put(entry.getKey(), eventMentions);
        }
        if (unusedEvents.isEmpty()) {
            return annotationEvents;
        }
        HashMap usedEvents = new HashMap();
        for (Map.Entry entry : annotationMap.entrySet()) {
            TextSpan span = (TextSpan)entry.getKey();
            TextSpan usedEventSpan = null;
            for (Map.Entry unusedEvent : unusedEvents.entrySet()) {
                if (span.equals(unusedEvent.getKey()) || !span.contains((TextSpan)unusedEvent.getKey())) continue;
                ((Collection)entry.getValue()).stream().filter(EventMention.class::isInstance).forEach(a -> {
                    Collection cfr_ignored_0 = (Collection)annotationEvents.put((IdentifiedAnnotation)a, (Collection<IdentifiedAnnotation>)unusedEvent.getValue());
                });
                usedEventSpan = (TextSpan)unusedEvent.getKey();
                usedEvents.put(usedEventSpan, unusedEvent.getValue());
                break;
            }
            if (usedEventSpan == null) continue;
            unusedEvents.remove(usedEventSpan);
            if (!unusedEvents.isEmpty()) continue;
            break;
        }
        usedEvents.forEach((s, e) -> ((Collection)annotationMap.get(s)).remove(e));
        Collection emptySpans = annotationMap.entrySet().stream().filter(e -> ((Collection)e.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toList());
        annotationMap.keySet().removeAll(emptySpans);
        return annotationEvents;
    }

    private static String createSectionName(Segment section) {
        String sectionPref = section.getPreferredText();
        String sectionId = section.getId();
        if (sectionId != null && !sectionId.isEmpty() && !sectionId.equals(sectionPref)) {
            if (sectionPref == null || sectionPref.isEmpty()) {
                return sectionId;
            }
            return sectionPref + " " + sectionId;
        }
        if (sectionPref != null && !sectionPref.isEmpty()) {
            return sectionPref;
        }
        String tagText = section.getTagText();
        if (tagText == null || tagText.isEmpty()) {
            return "Unknown Section";
        }
        return tagText;
    }
}

