/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ctakes.core.util.Pair;
import org.apache.ctakes.core.util.annotation.ConceptBuilder;
import org.apache.ctakes.core.util.annotation.SemanticGroup;
import org.apache.ctakes.core.util.annotation.SemanticTui;
import org.apache.ctakes.typesystem.type.refsem.OntologyConcept;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.log4j.Logger;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;

public final class IdentifiedAnnotationBuilder {
    private static final Logger LOGGER = Logger.getLogger((String)"IdentifiedAnnotationBuilder");
    private static final Pair<Integer> NULL_SPAN = new Pair<Integer>(-1, -1);
    private Pair<Integer> _textSpan = NULL_SPAN;
    private Function<JCas, ? extends IdentifiedAnnotation> _creator;
    private SemanticGroup _group = SemanticGroup.UNKNOWN;
    private SemanticTui _type = SemanticTui.UNKNOWN;
    private final Collection<OntologyConcept> _concepts = new HashSet<OntologyConcept>();
    private boolean _negated = false;
    private boolean _uncertain = false;
    private boolean _generic = false;
    private boolean _conditional = false;
    private boolean _historic = false;
    private String _subject = "patient";
    private int _discoveredBy = 0;
    private float _confidence = Float.MIN_VALUE;

    public IdentifiedAnnotationBuilder span(int begin, int end) {
        return this.span(new Pair<Integer>(begin, end));
    }

    public IdentifiedAnnotationBuilder span(Pair<Integer> textSpan) {
        this._textSpan = textSpan;
        return this;
    }

    public IdentifiedAnnotationBuilder creator(Function<JCas, ? extends IdentifiedAnnotation> creator) {
        this._creator = creator;
        return this;
    }

    public IdentifiedAnnotationBuilder group(SemanticGroup semanticGroup) {
        this._group = semanticGroup;
        return this;
    }

    public IdentifiedAnnotationBuilder group(String semanticGroup) {
        return this.group(SemanticGroup.getGroup(semanticGroup));
    }

    public IdentifiedAnnotationBuilder type(SemanticTui semanticType) {
        this._type = semanticType;
        return this;
    }

    public IdentifiedAnnotationBuilder type(String semanticType) {
        return this.type(SemanticTui.getTui(semanticType));
    }

    public IdentifiedAnnotationBuilder concept(OntologyConcept concept) {
        this._concepts.add(concept);
        return this;
    }

    public IdentifiedAnnotationBuilder concept(JCas jCas, String cui) {
        return this.concept(jCas, cui, this._type);
    }

    public IdentifiedAnnotationBuilder concept(JCas jCas, String cui, SemanticTui type) {
        OntologyConcept concept = new ConceptBuilder().cui(cui).type(type).build(jCas);
        return this.concept(concept);
    }

    public IdentifiedAnnotationBuilder tui(int tui) {
        return this.type(SemanticTui.getTui(tui));
    }

    public IdentifiedAnnotationBuilder tui(String tui) {
        return this.type(SemanticTui.getTui(tui));
    }

    public IdentifiedAnnotationBuilder negated() {
        this._negated = true;
        return this;
    }

    public IdentifiedAnnotationBuilder uncertain() {
        this._uncertain = true;
        return this;
    }

    public IdentifiedAnnotationBuilder generic() {
        this._generic = true;
        return this;
    }

    public IdentifiedAnnotationBuilder conditional() {
        this._conditional = true;
        return this;
    }

    public IdentifiedAnnotationBuilder historic() {
        this._historic = true;
        return this;
    }

    public IdentifiedAnnotationBuilder subject(String subject) {
        this._subject = subject;
        return this;
    }

    public IdentifiedAnnotationBuilder discoveredBy(int discoveryTechnique) {
        this._discoveredBy = discoveryTechnique;
        return this;
    }

    public IdentifiedAnnotationBuilder confidence(float confidence) {
        this._confidence = confidence;
        return this;
    }

    private SemanticGroup getGroup() {
        if (this._group != SemanticGroup.UNKNOWN) {
            return this._group;
        }
        if (this._type != SemanticTui.UNKNOWN) {
            return this._type.getGroup();
        }
        if (!this._concepts.isEmpty()) {
            Collection groups = this._concepts.stream().filter(UmlsConcept.class::isInstance).map(c -> ((UmlsConcept)c).getTui()).filter(Objects::nonNull).filter(t -> !t.isEmpty()).map(SemanticTui::getTui).map(SemanticTui::getGroup).collect(Collectors.toSet());
            if (!groups.isEmpty() && groups.size() == 1) {
                return (SemanticGroup)((Object)new ArrayList(groups).get(0));
            }
            return SemanticGroup.getBestGroup(groups);
        }
        return this._group;
    }

    public Function<JCas, ? extends IdentifiedAnnotation> getCreator(SemanticGroup group) {
        if (this._creator != null) {
            return this._creator;
        }
        return group.getCreator();
    }

    private void addConcepts(JCas jCas, IdentifiedAnnotation annotation) {
        if (!this._concepts.isEmpty()) {
            FSArray conceptArr = new FSArray(jCas, this._concepts.size());
            conceptArr.addToIndexes();
            int arrIdx = 0;
            for (OntologyConcept concept : this._concepts) {
                conceptArr.set(arrIdx, (FeatureStructure)concept);
                ++arrIdx;
            }
            annotation.setOntologyConceptArr(conceptArr);
        }
    }

    @Deprecated
    public IdentifiedAnnotationBuilder cui(String cui) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public IdentifiedAnnotationBuilder preferredText(String text) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public IdentifiedAnnotationBuilder addSchemaCode(String schema, String code) {
        throw new UnsupportedOperationException();
    }

    private static boolean isSpanValid(Pair<Integer> textSpan, int docLength) {
        if (textSpan.equals(NULL_SPAN)) {
            LOGGER.error((Object)"A Text Span must be specified to build an IdentifiedAnnotation.");
            return false;
        }
        if (textSpan.getValue1() >= textSpan.getValue2()) {
            LOGGER.error((Object)("The Text Span (" + textSpan.getValue1() + "," + textSpan.getValue2() + ") is poorly formed.  A valid text span is required to build an IdentifiedAnnotation."));
            return false;
        }
        if (textSpan.getValue1() < 0 || textSpan.getValue2() >= docLength) {
            LOGGER.error((Object)("The Text Span (" + textSpan.getValue1() + "," + textSpan.getValue2() + ") must be within the document text bounds (0," + docLength + ") to build an IdentifiedAnnotation."));
            return false;
        }
        return true;
    }

    public IdentifiedAnnotation put(JCas jcas) {
        return this.build(jcas);
    }

    public IdentifiedAnnotation build(JCas jcas) {
        if (!IdentifiedAnnotationBuilder.isSpanValid(this._textSpan, jcas.getDocumentText().length())) {
            LOGGER.error((Object)("Invalid text span " + this._textSpan.getValue1() + "," + this._textSpan.getValue2() + " in document of length " + jcas.getDocumentText().length()));
            return null;
        }
        SemanticGroup group = this.getGroup();
        IdentifiedAnnotation annotation = this.getCreator(group).apply(jcas);
        annotation.setTypeID(group.getCode());
        annotation.setBegin(this._textSpan.getValue1().intValue());
        annotation.setEnd(this._textSpan.getValue2().intValue());
        if (this._negated) {
            annotation.setPolarity(-1);
        }
        if (this._uncertain) {
            annotation.setUncertainty(1);
        }
        if (this._generic) {
            annotation.setGeneric(true);
        }
        if (this._conditional) {
            annotation.setConditional(true);
        }
        if (this._historic) {
            annotation.setHistoryOf(1);
        }
        if (!this._subject.isEmpty()) {
            annotation.setSubject(this._subject);
        }
        annotation.setDiscoveryTechnique(this._discoveredBy);
        annotation.setConfidence(this._confidence);
        this.addConcepts(jcas, annotation);
        annotation.addToIndexes();
        return annotation;
    }
}

