/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util.annotation;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.ctakes.core.util.annotation.OntologyConceptUtil;
import org.apache.ctakes.core.util.annotation.SemanticGroup;
import org.apache.ctakes.core.util.annotation.SemanticTui;
import org.apache.ctakes.typesystem.type.refsem.OntologyConcept;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;

public final class IdentifiedAnnotationUtil {
    private IdentifiedAnnotationUtil() {
    }

    public static boolean isRealAffirmed(IdentifiedAnnotation annotation) {
        return !IdentifiedAnnotationUtil.isGeneric(annotation) && !IdentifiedAnnotationUtil.isUncertain(annotation) && !IdentifiedAnnotationUtil.isNegated(annotation) && !IdentifiedAnnotationUtil.isConditional(annotation);
    }

    public static boolean isGeneric(IdentifiedAnnotation annotation) {
        return annotation.getGeneric();
    }

    public static boolean isUncertain(IdentifiedAnnotation annotation) {
        return annotation.getUncertainty() == 1;
    }

    public static boolean isNegated(IdentifiedAnnotation annotation) {
        return annotation.getPolarity() == -1;
    }

    public static boolean isConditional(IdentifiedAnnotation annotation) {
        return annotation.getConditional();
    }

    public static String getText(IdentifiedAnnotation annotation) {
        return annotation.getCoveredText();
    }

    public static boolean isHistoric(IdentifiedAnnotation annotation) {
        return annotation.getHistoryOf() == 1;
    }

    public static Collection<SemanticGroup> getSemanticGroups(IdentifiedAnnotation annotation) {
        return SemanticGroup.getGroups(annotation);
    }

    public static Collection<SemanticTui> getSemanticTuis(IdentifiedAnnotation annotation) {
        return SemanticTui.getTuis(annotation);
    }

    public static Collection<String> getCuis(IdentifiedAnnotation annotation) {
        return OntologyConceptUtil.getCuis(annotation);
    }

    public static Collection<String> getCodeSchemes(IdentifiedAnnotation annotation) {
        return OntologyConceptUtil.getSchemeCodes(annotation).keySet();
    }

    public static Collection<String> getCodes(IdentifiedAnnotation annotation, String schemeName) {
        return OntologyConceptUtil.getCodes(annotation, schemeName);
    }

    public static Collection<String> getPreferredTexts(IdentifiedAnnotation annotation) {
        return OntologyConceptUtil.getUmlsConceptStream(annotation).map(UmlsConcept::getPreferredText).filter(Objects::nonNull).filter(t -> !t.isEmpty()).collect(Collectors.toSet());
    }

    public static float getConfidence(IdentifiedAnnotation annotation) {
        return annotation.getConfidence();
    }

    public static Collection<SemanticGroup> getBestSemanticGroups(IdentifiedAnnotation annotation) {
        return IdentifiedAnnotationUtil.getBestSemanticTuis(annotation).stream().map(SemanticTui::getGroup).collect(Collectors.toSet());
    }

    public static SemanticGroup getBestSemanticGroup(IdentifiedAnnotation annotation) {
        return SemanticGroup.getBestGroup(IdentifiedAnnotationUtil.getSemanticGroups(annotation));
    }

    public static Collection<SemanticTui> getBestSemanticTuis(IdentifiedAnnotation annotation) {
        return OntologyConceptUtil.getBestUmlsConcepts(annotation).stream().map(SemanticTui::getTui).collect(Collectors.toSet());
    }

    public static Collection<String> getBestCuis(IdentifiedAnnotation annotation) {
        return OntologyConceptUtil.getBestUmlsConcepts(annotation).stream().map(UmlsConcept::getCui).collect(Collectors.toSet());
    }

    public static Collection<String> getBestCodeSchemes(IdentifiedAnnotation annotation) {
        return OntologyConceptUtil.getBestUmlsConcepts(annotation).stream().map(OntologyConcept::getCodingScheme).collect(Collectors.toSet());
    }

    public static Collection<String> getBestCodes(IdentifiedAnnotation annotation, String schemeName) {
        return OntologyConceptUtil.getBestUmlsConcepts(annotation).stream().filter(c -> schemeName.equals(c.getCodingScheme())).map(OntologyConcept::getCode).collect(Collectors.toSet());
    }

    public static Collection<String> getBestPreferredTexts(IdentifiedAnnotation annotation) {
        return OntologyConceptUtil.getBestUmlsConcepts(annotation).stream().map(UmlsConcept::getPreferredText).collect(Collectors.toSet());
    }
}

