/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util.annotation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ctakes.core.util.annotation.SemanticTui;
import org.apache.ctakes.typesystem.type.textsem.AnatomicalSiteMention;
import org.apache.ctakes.typesystem.type.textsem.DiseaseDisorderMention;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.LabMention;
import org.apache.ctakes.typesystem.type.textsem.LabValueModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationMention;
import org.apache.ctakes.typesystem.type.textsem.Modifier;
import org.apache.ctakes.typesystem.type.textsem.PersonTitleAnnotation;
import org.apache.ctakes.typesystem.type.textsem.ProcedureMention;
import org.apache.ctakes.typesystem.type.textsem.SignSymptomMention;
import org.apache.ctakes.typesystem.type.textsem.SubjectModifier;
import org.apache.ctakes.typesystem.type.textsem.TimeAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.uima.jcas.JCas;

public enum SemanticGroup {
    DRUG(1, "Drug", "Medication", MedicationMention.class, MedicationMention::new),
    DISORDER(2, "Disorder", "Disease/Disorder", DiseaseDisorderMention.class, DiseaseDisorderMention::new),
    FINDING(3, "Finding", "Sign/Symptom", SignSymptomMention.class, SignSymptomMention::new),
    PROCEDURE(5, "Procedure", "Procedure", ProcedureMention.class, ProcedureMention::new),
    ANATOMY(6, "Anatomy", "Anatomical Site", AnatomicalSiteMention.class, AnatomicalSiteMention::new),
    CLINICAL_ATTRIBUTE(7, "Attribute", "Clinical Attribute", SignSymptomMention.class, SignSymptomMention::new),
    DEVICE(8, "Device", "Device", EntityMention.class, EntityMention::new),
    LAB(9, "Lab", "Lab", LabMention.class, LabMention::new),
    PHENOMENON(10, "Phenomenon", "Phenomenon", EventMention.class, EventMention::new),
    SUBJECT(1001, "Subject", "Subject", SubjectModifier.class, SubjectModifier::new),
    TITLE(1002, "Title", "Person Title", PersonTitleAnnotation.class, PersonTitleAnnotation::new),
    EVENT(1003, "Event", "Event", EventMention.class, EventMention::new),
    ENTITY(1004, "Entity", "Entity", EntityMention.class, EntityMention::new),
    TIME(1005, "Time", "Timex3", TimeMention.class, TimeAnnotation::new),
    MODIFIER(1006, "Modifier", "Modifier", Modifier.class, Modifier::new),
    LAB_MODIFIER(1007, "LabModifier", "Lab Modifier", LabValueModifier.class, LabValueModifier::new),
    UNKNOWN(0, "Unknown", "Unknown Semantic Group", IdentifiedAnnotation.class, IdentifiedAnnotation::new);

    private final int _code;
    private final String _name;
    private final String _longName;
    private final Class<? extends IdentifiedAnnotation> _clazz;
    private final Function<JCas, ? extends IdentifiedAnnotation> _creator;

    private SemanticGroup(int code, String name, String longName, Class<? extends IdentifiedAnnotation> clazz, Function<JCas, ? extends IdentifiedAnnotation> creator) {
        this._code = code;
        this._name = name;
        this._longName = name;
        this._clazz = clazz;
        this._creator = creator;
    }

    public int getCode() {
        return this._code;
    }

    public String getName() {
        return this._name;
    }

    public String getLongName() {
        return this._longName;
    }

    public Class<? extends IdentifiedAnnotation> getCtakesClass() {
        return this._clazz;
    }

    public Function<JCas, ? extends IdentifiedAnnotation> getCreator() {
        return this._creator;
    }

    public static SemanticGroup getGroup(int code) {
        return Arrays.stream(SemanticGroup.values()).filter(g -> g._code == code).findFirst().orElse(UNKNOWN);
    }

    public static SemanticGroup getGroup(String name) {
        return Arrays.stream(SemanticGroup.values()).filter(g -> g._name.equals(name)).findFirst().orElse(UNKNOWN);
    }

    public static Collection<SemanticGroup> getGroups(IdentifiedAnnotation annotation) {
        Collection groups = SemanticTui.getTuis(annotation).stream().map(SemanticTui::getGroup).collect(Collectors.toSet());
        SemanticGroup typeIdGroup = SemanticGroup.getBestTypeIdGroup(annotation);
        if (typeIdGroup == UNKNOWN || groups.contains((Object)typeIdGroup)) {
            return groups;
        }
        HashSet<SemanticGroup> allGroups = new HashSet<SemanticGroup>(groups);
        allGroups.add(typeIdGroup);
        return allGroups;
    }

    public static SemanticGroup getBestGroup(IdentifiedAnnotation annotation) {
        SemanticGroup typeIdGroup = SemanticGroup.getBestTypeIdGroup(annotation);
        if (typeIdGroup != UNKNOWN) {
            return typeIdGroup;
        }
        return SemanticGroup.getBestGroup(SemanticGroup.getGroups(annotation));
    }

    public static SemanticGroup getBestGroup(Collection<SemanticGroup> groups) {
        return groups.stream().min(BestGrouper.INSTANCE).orElse(UNKNOWN);
    }

    private static SemanticGroup getBestTypeIdGroup(IdentifiedAnnotation annotation) {
        int typeId = annotation.getTypeID();
        return Arrays.stream(SemanticGroup.values()).filter(g -> g.getCode() == typeId).findFirst().orElse(UNKNOWN);
    }

    private static final class BestGrouper
    implements Comparator<SemanticGroup> {
        private static final BestGrouper INSTANCE = new BestGrouper();

        private BestGrouper() {
        }

        @Override
        public int compare(SemanticGroup g1, SemanticGroup g2) {
            if (g1 == UNKNOWN) {
                return 1;
            }
            if (g2 == UNKNOWN) {
                return -1;
            }
            return g2._code - g1._code;
        }
    }
}

