/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util.collection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ctakes.core.util.collection.CollectionCreator;

public final class CollectionCreatorFactory {
    private CollectionCreatorFactory() {
    }

    public static <V> CollectionCreator<V, Set<V>> createSetCreator() {
        return new CollectionCreator<V, Set<V>>(){

            @Override
            public Set<V> createCollection() {
                return new HashSet();
            }

            @Override
            public Set<V> createCollection(int size) {
                return new HashSet(size);
            }
        };
    }

    public static <V> CollectionCreator<V, List<V>> createListCreator() {
        return new CollectionCreator<V, List<V>>(){

            @Override
            public List<V> createCollection() {
                return new ArrayList();
            }

            @Override
            public List<V> createCollection(int size) {
                return new ArrayList(size);
            }
        };
    }
}

