/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util.doc;

import java.util.Collection;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.ctakes.typesystem.type.structured.DocumentID;
import org.apache.ctakes.typesystem.type.structured.DocumentIdPrefix;
import org.apache.log4j.Logger;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public final class DocIdUtil {
    public static final String NO_DOCUMENT_ID = "UnknownDocument";
    public static final String NO_DOCUMENT_ID_PREFIX = "UnknownDocumentPrefix";
    private static final Logger LOGGER = Logger.getLogger((String)"DocumentIDAnnotationUtil");
    private static final Pattern FILE_FIX_PATTERN = Pattern.compile("[^A-Za-z0-9\\.]");
    private static long _noDocIdIndex = 1L;

    private DocIdUtil() {
    }

    public static String getDocumentID(JCas jcas) {
        if (jcas == null) {
            LOGGER.debug((Object)"NULL CAS");
            return NO_DOCUMENT_ID;
        }
        Collection idSet = JCasUtil.select((JCas)jcas, DocumentID.class);
        DocumentID id = idSet.stream().filter(Objects::nonNull).findAny().orElse(null);
        if (id == null) {
            return DocIdUtil.createDocumentId(jcas);
        }
        try {
            return id.getDocumentID();
        }
        catch (CASRuntimeException casRTE) {
            String newId = NO_DOCUMENT_ID + _noDocIdIndex;
            ++_noDocIdIndex;
            LOGGER.warn((Object)("document Id Annotation does not have the id feature set, setting to " + newId), (Throwable)casRTE);
            id.setDocumentID(newId);
            return newId;
        }
    }

    public static String getDeepDocumentId(JCas startingJcas) {
        String documentID = DocIdUtil.getDocumentID(startingJcas);
        if (documentID == null || documentID.equals(NO_DOCUMENT_ID)) {
            JCas viewJcas;
            LOGGER.debug((Object)"Checking document Id for initial view");
            try {
                viewJcas = startingJcas.getView("_InitialView");
                documentID = DocIdUtil.getDocumentID(viewJcas);
            }
            catch (CASException | CASRuntimeException casE) {
                LOGGER.warn((Object)casE.getMessage());
                documentID = NO_DOCUMENT_ID;
            }
            if (documentID == null || documentID.equals(NO_DOCUMENT_ID)) {
                LOGGER.debug((Object)"Checking document Id for plaintext view");
                try {
                    viewJcas = startingJcas.getView("plaintext");
                    documentID = DocIdUtil.getDocumentID(viewJcas);
                }
                catch (CASException | CASRuntimeException casE) {
                    LOGGER.warn((Object)casE.getMessage());
                    documentID = NO_DOCUMENT_ID;
                }
                if (documentID == null || documentID.equals(NO_DOCUMENT_ID)) {
                    LOGGER.warn((Object)"Unable to find DocumentIDAnnotation");
                    return DocIdUtil.createDocumentId(startingJcas);
                }
            }
        }
        return documentID;
    }

    public static String getDocumentIdForFile(JCas jcas) {
        String casDocText;
        String docId = DocIdUtil.getDeepDocumentId(jcas);
        if ((docId == null || docId.isEmpty()) && (casDocText = jcas.getDocumentText()) != null && !(casDocText = casDocText.trim()).isEmpty()) {
            docId = casDocText.substring(0, Math.min(casDocText.length(), 10)) + "_" + casDocText.hashCode();
        }
        if (docId == null || docId.isEmpty()) {
            docId = "Unknown_" + System.currentTimeMillis();
        }
        return FILE_FIX_PATTERN.matcher(docId).replaceAll("_");
    }

    private static String createDocumentId(JCas jCas) {
        String newId = NO_DOCUMENT_ID + _noDocIdIndex;
        ++_noDocIdIndex;
        LOGGER.debug((Object)("Creating document ID " + newId));
        DocumentID documentIDAnnotation = new DocumentID(jCas);
        documentIDAnnotation.setDocumentID(newId);
        documentIDAnnotation.addToIndexes();
        return newId;
    }

    public static String getDocumentIdPrefix(JCas jcas) {
        if (jcas == null) {
            LOGGER.debug((Object)"NULL CAS");
            return NO_DOCUMENT_ID_PREFIX;
        }
        Collection prefices = JCasUtil.select((JCas)jcas, DocumentIdPrefix.class);
        DocumentIdPrefix prefix = prefices.stream().filter(Objects::nonNull).findAny().orElse(null);
        if (prefix == null) {
            LOGGER.debug((Object)("No document id prefix information for " + DocIdUtil.getDocumentID(jcas)));
            return NO_DOCUMENT_ID_PREFIX;
        }
        try {
            return prefix.getDocumentIdPrefix();
        }
        catch (CASRuntimeException casRTE) {
            LOGGER.debug((Object)("No document id prefix information for " + DocIdUtil.getDocumentID(jcas)));
            return NO_DOCUMENT_ID_PREFIX;
        }
    }
}

