/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util.doc;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.ctakes.core.util.doc.DocIdUtil;
import org.apache.ctakes.core.util.doc.SourceMetadataUtil;
import org.apache.ctakes.typesystem.type.structured.SourceData;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.log4j.Logger;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public final class NoteSpecs {
    private static final Logger LOGGER = Logger.getLogger((String)"NoteSpecs");
    public static final String ID_NAME_CLINICAL_NOTE = "ClinicalNote";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddhhmm");
    private static final DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    public static final String SUBJECT_PATIENT = "patient";
    public static final String DEFAULT_PATIENT_NAME = "Generic";
    private final String _documentId;
    private final String _documentType;
    private final String _documentText;
    private final String _patientName;
    private final Collection<String> _subjects;
    private final Date _noteDate;

    public NoteSpecs(JCas jCas) {
        SourceData sourceData = SourceMetadataUtil.getSourceData(jCas);
        this._noteDate = NoteSpecs.createNoteDate(sourceData);
        this._documentId = DocIdUtil.getDocumentID(jCas);
        this._documentType = NoteSpecs.createDocumentType(sourceData);
        this._documentText = jCas.getDocumentText();
        this._patientName = NoteSpecs.createPatientName(jCas, this._documentId);
        this._subjects = this.createSubjects(jCas);
    }

    public String getDocumentId() {
        return this._documentId;
    }

    public String getPatientName() {
        return this._patientName;
    }

    public Collection<String> getSubjects() {
        return this._subjects;
    }

    private Collection<String> createSubjects(JCas jCas) {
        return JCasUtil.select((JCas)jCas, IdentifiedAnnotation.class).stream().map(IdentifiedAnnotation::getSubject).filter(Objects::nonNull).map(String::toLowerCase).filter(s -> !SUBJECT_PATIENT.equals(s)).distinct().collect(Collectors.toList());
    }

    public Date getNoteDate() {
        return this._noteDate;
    }

    public String getNoteTime() {
        return DATE_FORMAT.format(this._noteDate);
    }

    public String getDocumentType() {
        return this._documentType;
    }

    public String getDocumentText() {
        return this._documentText;
    }

    private static String createPatientName(JCas jCas, String documentId) {
        int firstScore;
        String patientId = SourceMetadataUtil.getPatientIdentifier(jCas);
        if (patientId != null && !patientId.isEmpty() && !patientId.equals("UnknownPatient")) {
            return patientId;
        }
        String idPrefix = DocIdUtil.getDocumentIdPrefix(jCas);
        if (idPrefix != null && !idPrefix.isEmpty() && !idPrefix.equals("UnknownDocumentPrefix")) {
            return idPrefix;
        }
        if (!documentId.isEmpty() && (firstScore = documentId.indexOf(95)) > 2) {
            return documentId.substring(0, firstScore);
        }
        return DEFAULT_PATIENT_NAME;
    }

    private static String createDocumentType(SourceData sourceData) {
        if (sourceData == null) {
            return ID_NAME_CLINICAL_NOTE;
        }
        String sourceType = sourceData.getNoteTypeCode();
        return sourceType == null ? ID_NAME_CLINICAL_NOTE : sourceType;
    }

    private static Date createNoteDate(SourceData sourceData) {
        if (sourceData == null) {
            return new Date();
        }
        String sourceDateText = sourceData.getSourceOriginalDate();
        if (sourceDateText != null) {
            try {
                return TIMESTAMP_FORMAT.parse(sourceDateText);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new Date();
    }
}

