/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util.doc;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.ctakes.core.util.doc.DocIdUtil;
import org.apache.ctakes.typesystem.type.structured.Metadata;
import org.apache.ctakes.typesystem.type.structured.SourceData;
import org.apache.log4j.Logger;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceProcessException;

public final class SourceMetadataUtil {
    private static final Logger LOGGER = Logger.getLogger((String)"SourceMetadataUtil");
    public static final String UNKNOWN_PATIENT = "UnknownPatient";
    public static final long UNKNOWN_PATIENT_NUM = -1L;

    private SourceMetadataUtil() {
    }

    public static String getPatientIdentifier(JCas jcas) {
        String patientId;
        Metadata metadata = SourceMetadataUtil.getMetadata(jcas);
        if (metadata != null && (patientId = metadata.getPatientIdentifier()) != null && !patientId.isEmpty()) {
            return patientId;
        }
        String docPrefix = DocIdUtil.getDocumentIdPrefix(jcas);
        if (docPrefix != null && !docPrefix.isEmpty()) {
            return docPrefix;
        }
        return UNKNOWN_PATIENT;
    }

    public static void setPatientIdentifier(JCas jCas, String patientId) {
        Metadata metadata = SourceMetadataUtil.getOrCreateMetadata(jCas);
        metadata.setPatientIdentifier(patientId);
    }

    public static long getPatientNum(JCas jcas) {
        Metadata metadata = SourceMetadataUtil.getMetadata(jcas);
        if (metadata == null) {
            return -1L;
        }
        return metadata.getPatientID();
    }

    public static Metadata getMetadata(JCas jcas) {
        Collection metadatas = JCasUtil.select((JCas)jcas, Metadata.class);
        if (metadatas == null || metadatas.isEmpty()) {
            return null;
        }
        return (Metadata)new ArrayList(metadatas).get(0);
    }

    public static Metadata getOrCreateMetadata(JCas jCas) {
        Metadata metadata = SourceMetadataUtil.getMetadata(jCas);
        if (metadata != null) {
            return metadata;
        }
        Metadata newMetadata = new Metadata(jCas);
        newMetadata.addToIndexes();
        return newMetadata;
    }

    public static SourceData getSourceData(JCas jcas) {
        Metadata metadata = SourceMetadataUtil.getMetadata(jcas);
        if (metadata == null) {
            return null;
        }
        return metadata.getSourceData();
    }

    public static SourceData getOrCreateSourceData(JCas jCas) {
        SourceData sourceData = SourceMetadataUtil.getSourceData(jCas);
        if (sourceData != null) {
            return sourceData;
        }
        Metadata metadata = SourceMetadataUtil.getOrCreateMetadata(jCas);
        SourceData newSourceData = new SourceData(jCas);
        metadata.setSourceData(newSourceData);
        return newSourceData;
    }

    public static long getInstanceNum(SourceData sourcedata) throws ResourceProcessException {
        long instanceNum;
        String instance = sourcedata.getSourceInstanceId();
        if (instance == null || instance.isEmpty()) {
            return -1L;
        }
        try {
            instanceNum = Long.parseLong(instance);
        }
        catch (NumberFormatException nfE) {
            throw new ResourceProcessException((Throwable)nfE);
        }
        return instanceNum;
    }

    public static int getEncounterNum(SourceData sourcedata) throws ResourceProcessException {
        int encounterNum;
        String encounter = sourcedata.getSourceEncounterId();
        try {
            encounterNum = Integer.parseInt(encounter);
        }
        catch (NumberFormatException nfE) {
            throw new ResourceProcessException((Throwable)nfE);
        }
        return encounterNum;
    }

    public static String getProviderId(SourceData sourcedata) {
        return sourcedata.getAuthorSpecialty();
    }

    public static Timestamp getStartDate(SourceData sourcedata) {
        String sourceDate = sourcedata.getSourceOriginalDate();
        return Timestamp.valueOf(sourceDate);
    }
}

