/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util.doc;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.uima.UIMAException;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.jcas.JCas;

public final class TextBySectionBuilder {
    private final List<String> _sectionNames = new ArrayList<String>();
    private final List<String> _sectionTexts = new ArrayList<String>();

    public TextBySectionBuilder addSection(String name, String text) {
        this._sectionNames.add(name);
        this._sectionTexts.add(text);
        return this;
    }

    public JCas build() throws UIMAException {
        return this.populate(JCasFactory.createJCas());
    }

    public JCas populate(JCas jCas) {
        StringBuilder sb = new StringBuilder();
        int sectionCount = this._sectionNames.size();
        int sectionNum = 1;
        for (int i = 0; i < sectionCount; ++i) {
            String name = this._sectionNames.get(i);
            Segment section = new Segment(jCas);
            section.setTagText(name);
            section.setPreferredText(name);
            section.setId(name + '_' + sectionNum);
            sb.append(name).append("\n");
            section.setBegin(sb.length());
            sb.append(this._sectionTexts.get(i)).append("\n\n");
            section.setEnd(sb.length());
            section.addToIndexes();
            ++sectionNum;
        }
        jCas.setDocumentText(sb.toString());
        return jCas;
    }
}

