/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util.doc;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.UIMAException;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.jcas.JCas;

public final class TextBySentenceBuilder {
    private static final String DEFAULT_SEGMENT_ID = "SIMPLE_SEGMENT";
    private final List<SentenceSection> _sentenceSections = new ArrayList<SentenceSection>();
    private SentenceSection _currentSection;

    public TextBySentenceBuilder startSection(String name) {
        if (this._currentSection != null) {
            this._sentenceSections.add(this._currentSection);
        }
        this._currentSection = new SentenceSection(name);
        return this;
    }

    public TextBySentenceBuilder addSentence(String text) {
        if (this._currentSection == null) {
            this._currentSection = new SentenceSection(DEFAULT_SEGMENT_ID);
        }
        this._currentSection.addSentence(text);
        return this;
    }

    public JCas build() throws UIMAException {
        return this.populate(JCasFactory.createJCas());
    }

    public JCas populate(JCas jCas) {
        this._sentenceSections.add(this._currentSection);
        StringBuilder sb = new StringBuilder();
        int sectionNum = 1;
        int sentenceNum = 1;
        for (SentenceSection sentenceSection : this._sentenceSections) {
            String name = sentenceSection._name;
            Segment section = new Segment(jCas);
            section.setTagText(name);
            section.setPreferredText(name);
            String sectionId = name + '_' + sectionNum;
            section.setId(sectionId);
            section.setBegin(sb.length());
            if (!name.equals(DEFAULT_SEGMENT_ID)) {
                sb.append(name).append("\n");
            }
            for (String sentenceText : sentenceSection._sentences) {
                Sentence sentence = new Sentence(jCas);
                sentence.setSegmentId(sectionId);
                sentence.setSentenceNumber(sentenceNum);
                sentence.setBegin(sb.length());
                sb.append(sentenceText).append("\n");
                sentence.setEnd(sb.length());
                sentence.addToIndexes(jCas);
                ++sentenceNum;
            }
            if (this._sentenceSections.size() > 1) {
                sb.append("\n\n");
            }
            section.setEnd(sb.length());
            section.addToIndexes(jCas);
            ++sectionNum;
        }
        jCas.setDocumentText(sb.toString());
        return jCas;
    }

    private static final class SentenceSection {
        private final String _name;
        private final List<String> _sentences = new ArrayList<String>();

        private SentenceSection(String name) {
            this._name = name;
        }

        private void addSentence(String text) {
            this._sentences.add(text);
        }
    }
}

