/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util.external;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;

public final class SystemUtil {
    private static final Logger LOGGER = Logger.getLogger((String)"SystemUtil");
    private static final String ENV_VAR_PREFIX = "ctakes.env.";
    public static final File NO_FILE = new File("");
    public static final String FILE_NOT_FOUND = "FILE_NOT_FOUND";

    private SystemUtil() {
    }

    public static String subVariableParameters(String command, UimaContext context) {
        if (context == null || command == null || !command.contains("$")) {
            return command;
        }
        StringBuilder sb = new StringBuilder();
        int previousVarEnd = 0;
        int varBegin = command.indexOf(36, previousVarEnd);
        while (varBegin > -1) {
            sb.append(command, previousVarEnd, varBegin);
            int varEnd = command.indexOf(32, varBegin);
            varEnd = varEnd < 0 ? command.length() : varEnd;
            String varName = command.substring(varBegin + 1, varEnd);
            Object value = context.getConfigParameterValue(varName);
            if (value == null) {
                LOGGER.warn((Object)("No value for $" + varName + " in known parameter values."));
                sb.append("$").append(varName);
            } else {
                LOGGER.info((Object)("Substituting Parameter Value " + value + " for $" + varName));
                sb.append(value);
            }
            if (varEnd == command.length()) break;
            sb.append(' ');
            previousVarEnd = varEnd;
            varBegin = command.indexOf(36, varEnd);
            if (varBegin >= 0) continue;
            sb.append(command, varEnd, command.length());
        }
        return sb.toString();
    }

    public static void addEnvironmentVariables(Object ... variables) {
        if (variables.length == 0) {
            LOGGER.warn((Object)"No variables specified.");
            return;
        }
        if (variables.length % 2 != 0) {
            LOGGER.error((Object)"Odd number of variables provided.  Should be key value pairs.");
            return;
        }
        for (int i = 0; i < variables.length; i += 2) {
            if (variables[i] instanceof String) {
                System.setProperty(ENV_VAR_PREFIX + variables[i], variables[i + 1].toString());
                continue;
            }
            LOGGER.warn((Object)("Variable" + i + " not a String, using " + variables[i].toString()));
            System.setProperty(ENV_VAR_PREFIX + variables[i].toString(), variables[i + 1].toString());
        }
    }

    public static boolean copyDir(String source, String target) {
        File sourceDir = new File(source);
        if (!sourceDir.isDirectory()) {
            LOGGER.error((Object)("Source is not a directory " + source));
            return false;
        }
        File[] files = sourceDir.listFiles();
        if (files == null) {
            LOGGER.error((Object)("Cannot list files in " + source));
            return false;
        }
        new File(target).mkdirs();
        Arrays.stream(files).filter(f -> !f.isDirectory()).sorted().map(File::getName).forEach(n -> SystemUtil.copyFile(source + "/" + n, target + "/" + n));
        Arrays.stream(files).filter(File::isDirectory).sorted().map(File::getName).forEach(n -> SystemUtil.copyDir(source + "/" + n, target + "/" + n));
        return true;
    }

    public static boolean copyFile(String source, String target) {
        Path targetPath;
        InputStream sourceStream = FileLocator.getStreamQuiet(source);
        if (sourceStream == null) {
            LOGGER.error((Object)("Cannot access source " + source));
            return false;
        }
        try {
            targetPath = Paths.get(target, new String[0]);
        }
        catch (InvalidPathException ipE) {
            LOGGER.error((Object)("Cannot access target path " + target));
            return false;
        }
        return SystemUtil.copyToDisk(sourceStream, targetPath);
    }

    public static boolean copyToDisk(InputStream source, Path target) {
        try {
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ioE) {
            LOGGER.error((Object)ioE.getMessage());
            return false;
        }
        return true;
    }

    public static String findExecutable(String name) {
        String executable = SystemUtil.findExecutableInCtakes(name);
        if (!FILE_NOT_FOUND.equals(executable)) {
            return executable;
        }
        return SystemUtil.findExecutableOnPath(name);
    }

    public static String findExecutableInCtakes(String name) {
        File executable = FileLocator.getFileQuiet(name);
        if (executable != null && executable.canExecute()) {
            return executable.getAbsolutePath();
        }
        return FILE_NOT_FOUND;
    }

    public static String findExecutableOnPath(String name) {
        for (String dirname : System.getenv("PATH").split(File.pathSeparator)) {
            File testFile = new File(dirname, name);
            if (!testFile.isFile() || !testFile.canExecute()) continue;
            return testFile.getAbsolutePath();
        }
        return FILE_NOT_FOUND;
    }

    private static boolean unzipit(String zippedFile, File unzipDir) throws IOException {
        InputStream zippedStream = FileLocator.getStreamQuiet(zippedFile);
        if (zippedStream == null) {
            LOGGER.error((Object)("Could not access " + zippedFile));
            return false;
        }
        return SystemUtil.unzipit(zippedStream, unzipDir);
    }

    private static boolean unzipit(File zippedFile, File unzipDir) throws IOException {
        return SystemUtil.unzipit(zippedFile.getPath(), unzipDir);
    }

    private static boolean unzipit(InputStream zippedStream, File unzipDir) throws IOException {
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(zippedStream);
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            if (zipEntry.isDirectory()) {
                File newUnzipDir = new File(unzipDir, zipEntry.getName());
                newUnzipDir.mkdirs();
            } else {
                int len;
                File newUnzipFile = SystemUtil.newUnzipFile(unzipDir, zipEntry);
                FileOutputStream fos = new FileOutputStream(newUnzipFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        return true;
    }

    private static File newUnzipFile(File unzipDirPath, ZipEntry zipEntry) throws IOException {
        File unzippedFile = new File(unzipDirPath, zipEntry.getName());
        String destDirPath = unzipDirPath.getCanonicalPath();
        String destFilePath = unzippedFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        unzippedFile.getParentFile().mkdirs();
        return unzippedFile;
    }

    public static void openWebPage(String page) {
        LOGGER.info((Object)("Opening Web Page " + page + " ..."));
        String command = "start \"Browser\" /max " + page;
        String os = System.getProperty("os.name");
        if (!os.toLowerCase().contains("windows")) {
            command = "open " + page + " || xdg-open " + page + " || sensible-browser " + page;
        }
        try {
            SystemUtil.run(command);
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage());
        }
    }

    public static boolean run(String command) throws IOException {
        CommandRunner runner = new CommandRunner(command);
        return SystemUtil.run(runner);
    }

    public static boolean run(CommandRunner runner) throws IOException {
        boolean ok = false;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<Boolean> future = executor.submit(runner);
            ok = future.get();
        }
        catch (InterruptedException | ExecutionException multE) {
            throw new IOException(multE);
        }
        return ok;
    }

    private static class ErrorLogger
    implements Runnable {
        private final InputStream _error;
        private final Logger _logger;

        private ErrorLogger(Process process, Logger logger) {
            this._error = process.getErrorStream();
            this._logger = logger;
        }

        @Override
        public void run() {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this._error));){
                reader.lines().forEach(arg_0 -> ((Logger)this._logger).error(arg_0));
            }
            catch (IOException ioE) {
                this._logger.error((Object)ioE.getMessage());
            }
        }
    }

    private static class OutputLogger
    implements Runnable {
        private final InputStream _output;
        private final Logger _logger;

        private OutputLogger(Process process, Logger logger) {
            this._output = process.getInputStream();
            this._logger = logger;
        }

        @Override
        public void run() {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this._output));){
                reader.lines().forEach(arg_0 -> ((Logger)this._logger).info(arg_0));
            }
            catch (IOException ioE) {
                this._logger.error((Object)ioE.getMessage());
            }
        }
    }

    private static class InputFeeder {
        private OutputStream _input;

        private InputFeeder() {
        }

        private void setProcess(Process process) {
            this._input = process.getOutputStream();
        }

        public void feedInput(String input) {
            if (this._input == null) {
                LOGGER.error((Object)"Process not started, cannot send input.");
            }
            try {
                this._input.write(input.getBytes());
            }
            catch (IOException ioE) {
                LOGGER.error((Object)("Could not send input to process. " + ioE.getMessage()));
            }
        }
    }

    public static class CommandRunner
    implements Callable<Boolean> {
        private static final String LOG_DIR = "temp";
        private final Map<String, String> _userEnvVars = new HashMap<String, String>();
        private final String _command;
        private String _dir;
        private String _outLog;
        private boolean _keepTempLog = false;
        private Logger _logger;
        private boolean _wait;
        private boolean _stopOnExit;
        private InputFeeder _inputFeeder;
        private boolean _setJavaHome = true;
        private String _venv;
        private static final String[] VENV_EXTENSIONS = new String[]{"Library/mingw-w64/bin", "Library/usr/bin", "Library/bin", "Scripts", "bin", "lib/site-packages"};

        public CommandRunner(String command) {
            this._command = command;
        }

        public void setDirectory(String directory) {
            this._dir = directory;
        }

        public void setLogger(Logger logger) {
            this._logger = logger;
        }

        public void setLogFiles(String outLog) {
            this._outLog = outLog;
        }

        public void keepTempLog(boolean keep) {
            this._keepTempLog = keep;
        }

        public void wait(boolean wait) {
            this._wait = wait;
        }

        public void addEnvVar(String name, String value) {
            this._userEnvVars.put(name, value);
        }

        public void stopOnExit(boolean stopOnExit) {
            this._stopOnExit = stopOnExit;
        }

        public InputFeeder createInputFeeder() {
            this._inputFeeder = new InputFeeder();
            return this._inputFeeder;
        }

        public void setSetJavaHome(boolean setJavaHome) {
            this._setJavaHome = setJavaHome;
        }

        public void setVenv(String venv) {
            this._venv = venv;
        }

        private String getDefaultLogFile() {
            File tempFile;
            String ext = String.valueOf(new Random().nextLong());
            int spaceIndex = this._command.indexOf(32);
            String cmd = spaceIndex < 0 ? this._command : this._command.substring(0, spaceIndex);
            try {
                tempFile = File.createTempFile(cmd + ".ctakes.log.", ext);
            }
            catch (IOException ioE) {
                new File(LOG_DIR).mkdirs();
                tempFile = new File(LOG_DIR, cmd + ".ctakes.log." + ext);
            }
            if (!this._keepTempLog) {
                tempFile.deleteOnExit();
            }
            return tempFile.getPath();
        }

        private void ensureEnvironment(ProcessBuilder processBuilder) {
            String classpath;
            Map<String, String> env = processBuilder.environment();
            System.getProperties().stringPropertyNames().stream().filter(n -> n.startsWith(SystemUtil.ENV_VAR_PREFIX)).forEach(n -> env.put(n.substring(SystemUtil.ENV_VAR_PREFIX.length()), System.getProperty(n)));
            if (this._setJavaHome) {
                env.put("JAVA_HOME", System.getProperty("java.home"));
            }
            if (!env.containsKey("CTAKES_HOME")) {
                String cTakesHome = System.getenv("CTAKES_HOME");
                if (cTakesHome == null || cTakesHome.isEmpty()) {
                    cTakesHome = System.getProperty("user.dir");
                }
                env.put("CTAKES_HOME", cTakesHome);
            }
            if (!env.containsKey("CLASSPATH") && (classpath = System.getProperty("java.class.path")) != null && !classpath.isEmpty()) {
                env.put("CLASSPATH", classpath);
            }
            env.putAll(this._userEnvVars);
            if (this._venv != null && !this._venv.trim().isEmpty()) {
                String UxPath;
                env.put("VIRTUAL_ENV", this._venv);
                String WinPath = env.get("Path");
                if (WinPath != null) {
                    env.put("Path", this.getVenvPath() + WinPath);
                }
                if ((UxPath = env.get("PATH")) != null) {
                    env.put("PATH", this.getVenvPath() + UxPath);
                }
            }
        }

        private String getVenvPath() {
            StringBuilder sb = new StringBuilder(this._venv + File.pathSeparator);
            for (String extension : VENV_EXTENSIONS) {
                String envPath = this._venv + File.separator + extension.replace('/', File.separatorChar);
                if (!new File(envPath).isDirectory()) continue;
                sb.append(envPath).append(File.pathSeparator);
            }
            return sb.toString();
        }

        @Override
        public Boolean call() throws IOException, InterruptedException {
            String command = this._command;
            if (this._logger == null) {
                if (this._outLog != null && !this._outLog.isEmpty()) {
                    File log = new File(this._outLog);
                    if (log.getParentFile() != null) {
                        log.getParentFile().mkdirs();
                    }
                    command = command + " > " + this._outLog + " 2>&1";
                } else {
                    command = command + " > " + this.getDefaultLogFile() + " 2>&1";
                }
            }
            String cmd = "cmd.exe";
            String cmdOpt = "/c";
            String os = System.getProperty("os.name");
            if (!os.toLowerCase().contains("windows")) {
                cmd = "bash";
                cmdOpt = "-c";
            }
            ProcessBuilder processBuilder = new ProcessBuilder(cmd, cmdOpt, command);
            if (this._dir != null && !this._dir.isEmpty()) {
                File dir = new File(this._dir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                processBuilder.directory(dir);
            }
            this.ensureEnvironment(processBuilder);
            Process process = processBuilder.start();
            if (this._stopOnExit) {
                this.registerShutdownHook(process);
            }
            if (this._logger != null) {
                ExecutorService executors = Executors.newFixedThreadPool(2);
                executors.submit(new OutputLogger(process, this._logger));
                executors.submit(new ErrorLogger(process, this._logger));
            }
            if (this._inputFeeder != null) {
                this._inputFeeder.setProcess(process);
            }
            if (this._wait) {
                return process.waitFor() == 0;
            }
            return true;
        }

        private void registerShutdownHook(Process process) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    if (process.isAlive()) {
                        process.destroy();
                        process.waitFor();
                    }
                }
                catch (InterruptedException multE) {
                    LOGGER.error((Object)"Could not stop process.", (Throwable)multE);
                }
            }));
        }
    }

    public static class FileUnzipper
    implements Callable<File> {
        private final File _zip;
        private final File _unzipDir;

        public FileUnzipper(File zip, File unzipDir) {
            this._zip = zip;
            this._unzipDir = unzipDir;
        }

        @Override
        public File call() throws IOException {
            SystemUtil.unzipit(this._zip, this._unzipDir);
            return this._unzipDir;
        }
    }

    public static class FileDownloader
    implements Callable<File> {
        private final String _url;
        private final String _tempPrefix;
        private final String _tempSuffix;

        public FileDownloader(String url) {
            this(url, "Prefix", "suffix");
        }

        public FileDownloader(String url, String tempPrefix, String tempSuffix) {
            this._url = url;
            this._tempPrefix = tempPrefix;
            this._tempSuffix = tempSuffix;
        }

        @Override
        public File call() throws IOException {
            File tempZip = File.createTempFile(this._tempPrefix, this._tempSuffix);
            tempZip.deleteOnExit();
            URL url = new URL(this._url);
            try (ReadableByteChannel readableByteChannel = Channels.newChannel(url.openStream());
                 FileOutputStream fileOutputStream = new FileOutputStream(tempZip);
                 FileChannel fileChannel = fileOutputStream.getChannel();){
                fileChannel.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            }
            return tempZip;
        }
    }
}

