/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util.log;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.pipeline.ProgressManager;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Finished Logger", description="Writes a banner message COMPLETE to the log when all processing is finished.", role=PipeBitInfo.Role.SPECIAL)
public final class FinishedLogger
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"ProgressDone");
    private static final String BUILD_VERSION = "Implementation-Version";
    private static final String BUILD_DATE = "Implementation-Build-Date";
    private long _initMillis;
    private long _docCount = 0L;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this._initMillis = System.currentTimeMillis();
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        ++this._docCount;
        ProgressManager.getInstance().updateProgress(Long.valueOf(this._docCount).intValue());
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        long endMillis = System.currentTimeMillis();
        long instantMillis = ManagementFactory.getRuntimeMXBean().getStartTime();
        Map<String, String> buildInfo = FinishedLogger.getBuildInfo(BUILD_VERSION, BUILD_DATE);
        LOGGER.info((Object)("Build Version:                " + buildInfo.getOrDefault(BUILD_VERSION, "")));
        LOGGER.info((Object)("Build Date:                   " + buildInfo.getOrDefault(BUILD_DATE, "")));
        LOGGER.info((Object)("Run Start Time:               " + FinishedLogger.getTime(instantMillis)));
        LOGGER.info((Object)("Processing Start Time:        " + FinishedLogger.getTime(this._initMillis)));
        LOGGER.info((Object)("Processing End Time:          " + FinishedLogger.getTime(endMillis)));
        LOGGER.info((Object)("Initialization Time Elapsed:  " + FinishedLogger.getSpan(this._initMillis - instantMillis)));
        LOGGER.info((Object)("Processing Time Elapsed:      " + FinishedLogger.getSpan(endMillis - this._initMillis)));
        LOGGER.info((Object)("Total Run Time Elapsed:       " + FinishedLogger.getSpan(endMillis - instantMillis)));
        LOGGER.info((Object)("Documents Processed:          " + this._docCount));
        long millisPerNote = this._docCount == 0L ? 0L : (endMillis - this._initMillis) / this._docCount;
        LOGGER.info((Object)String.format("Average Seconds per Document: %.2f", Float.valueOf((float)millisPerNote / 1000.0f)));
    }

    private static String getTime(long millis) {
        return new Date(millis).toString();
    }

    private static String getSpan(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        long days = hours / 24L;
        hours %= 24L;
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append(" days, ");
        }
        if (days > 0L || hours > 0L) {
            sb.append(hours).append(" hours, ");
        }
        if (days > 0L || hours > 0L || minutes > 0L) {
            sb.append(minutes).append(" minutes, ");
        }
        sb.append(seconds).append(" seconds");
        return sb.toString();
    }

    public static Map<String, String> getBuildInfo(String ... attributeNames) {
        File libDir = FileLocator.getFileQuiet("lib");
        if (libDir == null || !libDir.isDirectory()) {
            return Collections.emptyMap();
        }
        File[] files = libDir.listFiles();
        if (files == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> attributeMap = new HashMap<String, String>(attributeNames.length);
        for (File jar : files) {
            String name = jar.getName();
            if (!name.contains("ctakes-core") || name.contains("ctakes-core-models") || name.contains("coreference") || name.contains("ctakes-core-res")) continue;
            try (JarFile jf = new JarFile(jar);){
                Manifest manifest = jf.getManifest();
                Attributes attributes = manifest.getMainAttributes();
                for (String attributeName : attributeNames) {
                    attributeMap.put(attributeName, FinishedLogger.getAttribute(attributes, attributeName));
                }
            }
            catch (IOException ioE) {
                return attributeMap;
            }
        }
        return attributeMap;
    }

    private static String getAttribute(Attributes attributes, String attributeName) {
        String value = attributes.getValue(attributeName);
        return value == null ? "" : value;
    }
}

