/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.jdl.data.xml;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SaxParser
extends DefaultHandler {
    private String srcXml;
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String SCHEMA_NONS_LOCATION_ID = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";

    public SaxParser(String srcXml) {
        this.setSrcXml(srcXml);
    }

    public final void parse() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(this.srcXml, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final String getSrcXml() {
        return this.srcXml;
    }

    public final void setSrcXml(String srcXml) {
        this.srcXml = srcXml;
        this.parse();
    }

    public final void parse(String srcXsd) throws ParserConfigurationException, SAXException, MalformedURLException {
        SAXParserFactory saxfactory = SAXParserFactory.newInstance();
        saxfactory.setNamespaceAware(true);
        SAXParser parser = saxfactory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setFeature(NAMESPACES_FEATURE_ID, false);
        reader.setFeature(NAMESPACE_PREFIXES_FEATURE_ID, false);
        reader.setFeature(VALIDATION_FEATURE_ID, true);
        reader.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        reader.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, false);
        reader.setFeature(DYNAMIC_VALIDATION_FEATURE_ID, false);
        reader.setProperty(SCHEMA_NONS_LOCATION_ID, new File(srcXsd).toURI().toURL().toString());
    }
}

