/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.R;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.R.RGramMatrixExporter;
import org.apache.ctakes.ytex.kernel.FileUtil;
import org.apache.ctakes.ytex.kernel.InstanceData;
import org.apache.ctakes.ytex.kernel.KernelContextHolder;
import org.apache.ctakes.ytex.kernel.KernelUtil;
import org.apache.ctakes.ytex.kernel.dao.KernelEvaluationDao;
import org.apache.ctakes.ytex.sparsematrix.InstanceDataExporter;

public class RGramMatrixExporterImpl
implements RGramMatrixExporter {
    private static final Log log = LogFactory.getLog(RGramMatrixExporter.class);
    private InstanceDataExporter instanceDataExporter;
    private KernelEvaluationDao kernelEvaluationDao;
    private KernelUtil kernelUtil;

    public static void main(String[] args) throws IOException {
        Options options = new Options();
        OptionBuilder.withArgName((String)"prop");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"property file with queries and other kernel parameters");
        options.addOption(OptionBuilder.create((String)"prop"));
        try {
            GnuParser parser = new GnuParser();
            CommandLine line = parser.parse(options, args);
            RGramMatrixExporter exporter = (RGramMatrixExporter)KernelContextHolder.getApplicationContext().getBean(RGramMatrixExporter.class);
            exporter.exportGramMatrix(FileUtil.loadProperties(line.getOptionValue("prop"), true));
        }
        catch (ParseException pe) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java " + RGramMatrixExporterImpl.class.getName() + " export gram matrix for use in R/Matlab", options);
        }
    }

    private void exportGramMatrices(String name, String experiment, double param1, String param2, String splitName, String scope, String outdir, InstanceData instanceData) throws IOException {
        if (scope == null || scope.length() == 0) {
            this.exportGramMatrix(name, experiment, param1, param2, splitName, outdir, instanceData, null, 0, 0);
        } else {
            for (String label : instanceData.getLabelToInstanceMap().keySet()) {
                if ("label".equals(scope)) {
                    this.exportGramMatrix(name, experiment, param1, param2, splitName, outdir, instanceData, label, 0, 0);
                    continue;
                }
                if (!"fold".equals(scope)) continue;
                Iterator i$ = ((SortedMap)instanceData.getLabelToInstanceMap().get(label)).keySet().iterator();
                while (i$.hasNext()) {
                    int run = (Integer)i$.next();
                    Iterator i$2 = ((SortedMap)((SortedMap)instanceData.getLabelToInstanceMap().get(label)).get(run)).keySet().iterator();
                    while (i$2.hasNext()) {
                        int fold = (Integer)i$2.next();
                        this.exportGramMatrix(name, experiment, param1, param2, splitName, outdir, instanceData, label, run, fold);
                    }
                }
            }
        }
    }

    private void exportGramMatrix(String name, String experiment, double param1, String param2, String splitName, String outdir, InstanceData instanceData, String label, int run, int fold) throws IOException {
        SortedSet<Long> instanceIds = instanceData.getAllInstanceIds(label, run, fold);
        String filePrefix = FileUtil.getDataFilePrefix(outdir, label, run, fold, null);
        double[][] gramMatrix = this.kernelUtil.loadGramMatrix(instanceIds, name, splitName, experiment, label, run, fold, param1, param2);
        if (gramMatrix != null) {
            this.outputGramMatrix(gramMatrix, instanceIds, filePrefix);
        }
    }

    @Override
    public void exportGramMatrix(Properties props) throws IOException {
        String name = props.getProperty("org.apache.ctakes.ytex.corpusName");
        String splitName = props.getProperty("org.apache.ctakes.ytex.splitName");
        String experiment = props.getProperty("org.apache.ctakes.ytex.experiment");
        String param2 = props.getProperty("org.apache.ctakes.ytex.param2");
        double param1 = Double.parseDouble(props.getProperty("org.apache.ctakes.ytex.param1", "0"));
        String scope = props.getProperty("scope");
        String outdir = props.getProperty("outdir");
        InstanceData instanceData = this.getKernelUtil().loadInstances(props.getProperty("instanceClassQuery"));
        this.exportGramMatrices(name, experiment, param1, param2, splitName, scope, outdir, instanceData);
        this.instanceDataExporter.outputInstanceData(instanceData, FileUtil.addFilenameToDir(outdir, "instance.txt"));
    }

    public InstanceDataExporter getInstanceDataExporter() {
        return this.instanceDataExporter;
    }

    public KernelEvaluationDao getKernelEvaluationDao() {
        return this.kernelEvaluationDao;
    }

    public KernelUtil getKernelUtil() {
        return this.kernelUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputGramMatrix(double[][] gramMatrix, SortedSet<Long> instanceIds, String dataFilePrefix) throws IOException {
        BufferedWriter w = null;
        BufferedWriter wId = null;
        try {
            w = new BufferedWriter(new FileWriter(dataFilePrefix + "data.txt"));
            wId = new BufferedWriter(new FileWriter(dataFilePrefix + "instance_id.txt"));
            Long[] instanceIdArray = instanceIds.toArray(new Long[0]);
            for (int h = 0; h < instanceIdArray.length; ++h) {
                wId.write(Long.toString(instanceIdArray[h]));
                wId.write("\n");
            }
            for (int i = 0; i < instanceIdArray.length; ++i) {
                for (int j = 0; j < instanceIdArray.length; ++j) {
                    w.write(Double.toString(gramMatrix[i][j]));
                    if (j >= instanceIdArray.length - 1) continue;
                    w.write(" ");
                }
                w.write("\n");
            }
        }
        finally {
            if (w != null) {
                w.close();
            }
            if (wId != null) {
                wId.close();
            }
        }
    }

    public void setInstanceDataExporter(InstanceDataExporter instanceDataExporter) {
        this.instanceDataExporter = instanceDataExporter;
    }

    public void setKernelEvaluationDao(KernelEvaluationDao kernelEvaluationDao) {
        this.kernelEvaluationDao = kernelEvaluationDao;
    }

    public void setKernelUtil(KernelUtil kernelUtil) {
        this.kernelUtil = kernelUtil;
    }
}

