/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.ClassifierEvaluationParser;
import org.apache.ctakes.ytex.kernel.FileUtil;
import org.apache.ctakes.ytex.kernel.dao.ClassifierEvaluationDao;
import org.apache.ctakes.ytex.kernel.model.ClassifierEvaluation;
import org.apache.ctakes.ytex.kernel.model.ClassifierInstanceEvaluation;

public abstract class BaseClassifierEvaluationParser
implements ClassifierEvaluationParser {
    private static final Log log = LogFactory.getLog(BaseClassifierEvaluationParser.class);
    public static Pattern wsPattern = Pattern.compile("\\s|\\z");
    public static Pattern wsDotPattern = Pattern.compile("\\s|\\.|\\z");
    private ClassifierEvaluationDao classifierEvaluationDao;

    public ClassifierEvaluationDao getClassifierEvaluationDao() {
        return this.classifierEvaluationDao;
    }

    public void setClassifierEvaluationDao(ClassifierEvaluationDao classifierEvaluationDao) {
        this.classifierEvaluationDao = classifierEvaluationDao;
    }

    public static String extractFirstToken(String line, Pattern tokDelimPattern) {
        Matcher wsMatcher = tokDelimPattern.matcher(line);
        String token = null;
        if (wsMatcher.find() && wsMatcher.start() > 0) {
            token = line.substring(0, wsMatcher.start());
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> parseInstanceIds(String instanceIdFile) throws IOException {
        ArrayList<Long> instanceIds = new ArrayList<Long>();
        try (BufferedReader instanceIdReader = null;){
            instanceIdReader = new BufferedReader(new FileReader(instanceIdFile));
            String instanceId = null;
            while ((instanceId = instanceIdReader.readLine()) != null) {
                instanceIds.add(Long.parseLong(instanceId));
            }
            ArrayList<Long> arrayList = instanceIds;
            return arrayList;
        }
    }

    protected Double parseDoubleOption(Pattern pCost, String options) {
        Matcher m = pCost.matcher(options);
        if (m.find()) {
            String toParse = m.group(1);
            try {
                return Double.parseDouble(toParse);
            }
            catch (NumberFormatException nfe) {
                log.warn((Object)("could not parse: " + toParse), (Throwable)nfe);
            }
        }
        return null;
    }

    protected Integer parseIntOption(Pattern pKernel, String options) {
        Matcher m = pKernel.matcher(options);
        if (m.find()) {
            return Integer.parseInt(m.group(1));
        }
        return null;
    }

    protected void initClassifierEvaluation(String instanceIdFile, ClassifierEvaluation eval) {
        eval.setFold(FileUtil.parseFoldFromFileName(instanceIdFile));
        eval.setRun(FileUtil.parseRunFromFileName(instanceIdFile));
        eval.setLabel(FileUtil.parseLabelFromFileName(instanceIdFile));
    }

    protected void initClassifierEvaluationFromProperties(Properties props, ClassifierEvaluation eval) {
        eval.setName(props.getProperty("kernel.name"));
        eval.setExperiment(props.getProperty("kernel.experiment"));
        String strParam1 = props.getProperty("kernel.param1");
        if (strParam1 != null && strParam1.length() > 0) {
            eval.setParam1(Double.parseDouble(strParam1));
        }
        eval.setParam2(props.getProperty("kernel.param2"));
        eval.setOptions(props.getProperty(ClassifierEvaluationParser.ParseOption.EVAL_LINE.getOptionKey()));
    }

    public Properties loadProps(File outputDir) throws FileNotFoundException, IOException {
        return FileUtil.loadProperties(outputDir.getPath() + File.separator + "options.properties", true);
    }

    protected boolean checkFileRead(String file) {
        return new File(file).canRead();
    }

    protected String getFileBaseName(Properties kernelProps) {
        return kernelProps.getProperty(ClassifierEvaluationParser.ParseOption.DATA_BASENAME.getOptionKey(), ClassifierEvaluationParser.ParseOption.DATA_BASENAME.getDefaultValue());
    }

    protected void storeSemiSupervised(Properties kernelProps, ClassifierEvaluation ce, BiMap<Integer, String> classIdToNameMap) {
        boolean storeInstanceEval = "yes".equalsIgnoreCase(kernelProps.getProperty(ClassifierEvaluationParser.ParseOption.STORE_INSTANCE_EVAL.getOptionKey(), ClassifierEvaluationParser.ParseOption.STORE_INSTANCE_EVAL.getDefaultValue()));
        boolean storeUnlabeled = "yes".equalsIgnoreCase(kernelProps.getProperty(ClassifierEvaluationParser.ParseOption.STORE_UNLABELED.getOptionKey(), ClassifierEvaluationParser.ParseOption.STORE_UNLABELED.getDefaultValue()));
        boolean storeIR = "yes".equalsIgnoreCase(kernelProps.getProperty(ClassifierEvaluationParser.ParseOption.STORE_IRSTATS.getOptionKey(), ClassifierEvaluationParser.ParseOption.STORE_IRSTATS.getDefaultValue()));
        this.getClassifierEvaluationDao().saveClassifierEvaluation(ce, (Map<Integer, String>)classIdToNameMap, storeInstanceEval || storeUnlabeled, storeIR, 0);
    }

    protected void updateSemiSupervisedPredictions(ClassifierEvaluation ce, List<List<Long>> listClassInfo, boolean storeUnlabeled, int[] classIds) {
        for (int i = 0; i < classIds.length; ++i) {
            List<Long> classInfo = listClassInfo.get(i);
            long instanceId = classInfo.get(0);
            boolean train = classInfo.get(1) == 1L;
            int targetClassId = classInfo.get(2).intValue();
            if (!storeUnlabeled && train) continue;
            ClassifierInstanceEvaluation cie = new ClassifierInstanceEvaluation();
            cie.setClassifierEvaluation(ce);
            cie.setInstanceId(instanceId);
            cie.setPredictedClassId(classIds[i]);
            if (targetClassId != 0) {
                cie.setTargetClassId(targetClassId);
            }
            ce.getClassifierInstanceEvaluations().put(instanceId, cie);
        }
    }

    protected void updateSemiSupervisedPredictions(ClassifierEvaluation ce, List<InstanceClassInfo> listClassInfo, boolean storeUnlabeled, String[] predictedClassNames, Map<String, Integer> classNameToIdMap) {
        for (int i = 0; i < predictedClassNames.length; ++i) {
            InstanceClassInfo classInfo = listClassInfo.get(i);
            boolean train = classInfo.isTrain();
            if (!storeUnlabeled && train) continue;
            ClassifierInstanceEvaluation cie = new ClassifierInstanceEvaluation();
            cie.setClassifierEvaluation(ce);
            cie.setInstanceId(classInfo.getInstanceId());
            cie.setPredictedClassId(classNameToIdMap.get(predictedClassNames[i]));
            int targetClassId = classNameToIdMap.get(classInfo.getTargetClassName());
            if (targetClassId != 0) {
                cie.setTargetClassId(targetClassId);
            }
            ce.getClassifierInstanceEvaluations().put(cie.getInstanceId(), cie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BiMap<Integer, String> loadClassIdMap(File dataDir, String label) throws IOException {
        HashBiMap classIndexMap = HashBiMap.create();
        String filename = FileUtil.getScopedFileName(dataDir.getPath(), label, null, null, "class.properties");
        File f = new File(filename);
        if (f.exists()) {
            BufferedReader r = null;
            try {
                r = new BufferedReader(new FileReader(f));
                Properties props = new Properties();
                props.load(r);
                for (String key : props.stringPropertyNames()) {
                    classIndexMap.put((Object)Integer.parseInt(key), (Object)props.getProperty(key));
                }
            }
            finally {
                try {
                    r.close();
                }
                catch (IOException e) {}
            }
        }
        return classIndexMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<InstanceClassInfo> loadInstanceClassInfo(File dataDir, String classFileName) throws IOException {
        ArrayList<InstanceClassInfo> listClassInfo = null;
        try (BufferedReader r = null;){
            r = new BufferedReader(new FileReader(classFileName));
            listClassInfo = new ArrayList<InstanceClassInfo>();
            String line = null;
            while ((line = r.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                String[] classInfoToks = line.split("\\s");
                if (classInfoToks.length != 3) {
                    log.error((Object)("error parsing line: " + line));
                    List<InstanceClassInfo> list = null;
                    return list;
                }
                listClassInfo.add(new InstanceClassInfo(Long.parseLong(classInfoToks[0]), Integer.parseInt(classInfoToks[1]) != 0, classInfoToks[2]));
            }
        }
        return listClassInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<List<Long>> loadClassInfo(File dataDir, String classFileName) throws IOException {
        ArrayList<List<Long>> listClassInfo = null;
        try (BufferedReader r = null;){
            r = new BufferedReader(new FileReader(classFileName));
            listClassInfo = new ArrayList<List<Long>>();
            String line = null;
            while ((line = r.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                String[] classInfoToks = line.split("\\s");
                ArrayList<Long> classInfo = new ArrayList<Long>(3);
                for (String tok : classInfoToks) {
                    classInfo.add(Long.parseLong(tok));
                }
                if (classInfo.size() != 3) {
                    log.error((Object)("error parsing line: " + line));
                    List<List<Long>> list = null;
                    return list;
                }
                listClassInfo.add(classInfo);
            }
        }
        return listClassInfo;
    }

    public static class InstanceClassInfo {
        long instanceId;
        boolean train;
        String targetClassName;

        public InstanceClassInfo() {
        }

        public InstanceClassInfo(long instanceId, boolean train, String targetClassName) {
            this.instanceId = instanceId;
            this.train = train;
            this.targetClassName = targetClassName;
        }

        public long getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(long instanceId) {
            this.instanceId = instanceId;
        }

        public boolean isTrain() {
            return this.train;
        }

        public void setTrain(boolean train) {
            this.train = train;
        }

        public String getTargetClassName() {
            return this.targetClassName;
        }

        public void setTargetClassName(String targetClassName) {
            this.targetClassName = targetClassName;
        }
    }
}

