/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.ClassifierEvaluationParser;
import org.apache.ctakes.ytex.kernel.FileUtil;
import org.apache.ctakes.ytex.kernel.KernelContextHolder;

public class ClassifierEvaluationImporter {
    private static final Log log = LogFactory.getLog(ClassifierEvaluationImporter.class);
    private Map<String, ClassifierEvaluationParser> nameToParserMap;

    public Map<String, ClassifierEvaluationParser> getNameToParserMap() {
        return this.nameToParserMap;
    }

    public void setNameToParserMap(Map<String, ClassifierEvaluationParser> nameToParserMap) {
        this.nameToParserMap = nameToParserMap;
    }

    private static Options initOptions() {
        Options options = new Options();
        OptionBuilder.withArgName((String)"cvDir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"results directory, defaults to working directory");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"dir"));
        OptionBuilder.withArgName((String)"type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"libsvm (default) or svmlight or semil");
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"type"));
        return options;
    }

    public static void main(String[] args) throws Exception {
        Options options = ClassifierEvaluationImporter.initOptions();
        if (args.length == 0) {
            ClassifierEvaluationImporter.printHelp(options);
        } else {
            GnuParser oparser = new GnuParser();
            ClassifierEvaluationImporter importer = (ClassifierEvaluationImporter)KernelContextHolder.getApplicationContext().getBean(ClassifierEvaluationImporter.class);
            try {
                CommandLine line = oparser.parse(options, args);
                importer.importDirectory(line);
            }
            catch (ParseException e) {
                ClassifierEvaluationImporter.printHelp(options);
                throw e;
            }
        }
    }

    private ClassifierEvaluationParser getParser(CommandLine line) {
        String type = line.getOptionValue("type", "libsvm");
        return this.nameToParserMap.get(type);
    }

    public void importDirectory(CommandLine line) throws IOException {
        ClassifierEvaluationParser lparser = this.getParser(line);
        File directory = new File(line.getOptionValue("dir", "."));
        this.importDirectory(directory, lparser);
    }

    public void importDirectory(File directory, ClassifierEvaluationParser lparser) throws IOException {
        File[] subdirs = directory.listFiles(new FileUtil.DirectoryFileFilter());
        if (subdirs == null || subdirs.length == 0) {
            try {
                lparser.parseDirectory(new File("."), directory);
            }
            catch (IOException ioe) {
                log.error((Object)("error parsing directory: " + directory), (Throwable)ioe);
            }
        } else {
            for (File subdir : subdirs) {
                this.importDirectory(subdir, lparser);
            }
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java org.apache.ctakes.ytex.libsvm.ClassifierEvaluationImporter\n", options);
    }
}

