/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtil {
    static Pattern pFold = Pattern.compile("fold(\\d+)_");
    static Pattern pRun = Pattern.compile("run(\\d+)_");
    static Pattern pLabel = Pattern.compile("label([^_]+)_");

    public static int parseFoldFromFileName(String filename) {
        Matcher m = pFold.matcher(filename);
        if (m.find()) {
            return Integer.parseInt(m.group(1));
        }
        return 0;
    }

    public static Integer parseRunFromFileName(String filename) {
        Matcher m = pRun.matcher(filename);
        if (m.find()) {
            return Integer.parseInt(m.group(1));
        }
        return 0;
    }

    public static String parseLabelFromFileName(String filename) {
        Matcher m = pLabel.matcher(filename);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public static String getFoldFilePrefix(String outdir, String label, Integer run, Integer fold) {
        StringBuilder builder = new StringBuilder();
        if (outdir != null && outdir.length() > 0) {
            builder.append(outdir);
            if (!outdir.endsWith("/") && !outdir.endsWith("\\")) {
                builder.append(File.separator);
            }
        }
        if (label != null && label.length() > 0) {
            builder.append("label").append(label);
            if (run != null && run > 0 || fold != null && fold > 0) {
                builder.append("_");
            }
        }
        if (run != null && run > 0) {
            builder.append("run").append(Integer.toString(run));
            if (fold != null && fold > 0) {
                builder.append("_");
            }
        }
        if (fold != null && fold > 0) {
            builder.append("fold").append(Integer.toString(fold));
        }
        return builder.toString();
    }

    public static String getScopedFileName(String outdir, String label, Integer run, Integer fold, String suffix) {
        String filename = FileUtil.getFoldFilePrefix(outdir, label, run, fold);
        if (!(filename.length() <= 0 || filename.endsWith("/") || filename.endsWith("\\") || filename.endsWith("."))) {
            filename = filename + "_";
        }
        filename = filename + suffix;
        return filename;
    }

    public static String addFilenameToDir(String outdir, String filename) {
        StringBuilder builder = new StringBuilder();
        if (outdir != null && outdir.length() > 0) {
            builder.append(outdir);
            if (!outdir.endsWith("/") && !outdir.endsWith("\\")) {
                builder.append(File.separator);
            }
        }
        builder.append(filename);
        return builder.toString();
    }

    public static String getDataFilePrefix(String outdir, String label, Integer run, Integer fold, Boolean train) {
        StringBuilder builder = new StringBuilder(FileUtil.getFoldFilePrefix(outdir, label, run, fold));
        if (label != null && label.length() > 0 || run != null && run > 0 || fold != null && fold > 0) {
            builder.append("_");
        }
        if (train != null) {
            if (train.booleanValue()) {
                builder.append("train");
            } else {
                builder.append("test");
            }
        }
        return builder.toString();
    }

    public static void createOutdir(String outdir) throws IOException {
        if (outdir != null && outdir.length() > 0) {
            File outdirF = new File(outdir);
            if (outdirF.exists()) {
                if (!outdirF.isDirectory()) {
                    throw new IOException("outdir exists but is not a directory " + outdir);
                }
            } else if (!outdirF.mkdirs()) {
                throw new IOException("could not create directory: " + outdir);
            }
        }
    }

    public static boolean checkFileRead(String file) {
        return new File(file).canRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String fileName, boolean systemOverride) throws IOException {
        Properties kernelProps = new Properties();
        InputStream is = null;
        boolean propsLoaded = false;
        if (fileName != null && fileName.length() > 0) {
            try {
                is = new BufferedInputStream(new FileInputStream(fileName));
                if (fileName.endsWith(".xml")) {
                    kernelProps.loadFromXML(is);
                } else {
                    kernelProps.load(is);
                }
                propsLoaded = true;
            }
            catch (FileNotFoundException fe) {
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        if (systemOverride) {
            kernelProps.putAll((Map<?, ?>)System.getProperties());
            propsLoaded = true;
        }
        if (propsLoaded) {
            return kernelProps;
        }
        return null;
    }

    public static Double getDoubleProperty(Properties props, String propKey, Double defaultProp) {
        Double propValue = null;
        String propStr = props.getProperty(propKey);
        if (propStr != null && propStr.length() > 0) {
            try {
                propValue = Double.parseDouble(propStr);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return propValue != null ? propValue : defaultProp;
    }

    public static Integer getIntegerProperty(Properties props, String propKey, Integer defaultProp) {
        Integer propValue = null;
        String propStr = props.getProperty(propKey);
        if (propStr != null && propStr.length() > 0) {
            try {
                propValue = Integer.parseInt(propStr);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return propValue != null ? propValue : defaultProp;
    }

    public static class SuffixFileFilter
    implements FileFilter {
        String suffix = null;

        public SuffixFileFilter(String prefix) {
            this.suffix = prefix;
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(this.suffix);
        }
    }

    public static class PrefixFileFilter
    implements FileFilter {
        String prefix = null;

        public PrefixFileFilter(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().startsWith(this.prefix);
        }
    }

    public static class DirectoryFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

