/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.FileUtil;
import org.apache.ctakes.ytex.kernel.ImputedFeatureEvaluator;
import org.apache.ctakes.ytex.kernel.InfoContentEvaluator;
import org.apache.ctakes.ytex.kernel.InstanceData;
import org.apache.ctakes.ytex.kernel.KernelContextHolder;
import org.apache.ctakes.ytex.kernel.KernelUtil;
import org.apache.ctakes.ytex.kernel.dao.ClassifierEvaluationDao;
import org.apache.ctakes.ytex.kernel.dao.ConceptDao;
import org.apache.ctakes.ytex.kernel.model.ConcRel;
import org.apache.ctakes.ytex.kernel.model.ConceptGraph;
import org.apache.ctakes.ytex.kernel.model.CrossValidationFold;
import org.apache.ctakes.ytex.kernel.model.FeatureEvaluation;
import org.apache.ctakes.ytex.kernel.model.FeatureParentChild;
import org.apache.ctakes.ytex.kernel.model.FeatureRank;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import weka.core.ContingencyTables;

public class ImputedFeatureEvaluatorImpl
implements ImputedFeatureEvaluator {
    private static final Log log = LogFactory.getLog(ImputedFeatureEvaluatorImpl.class);
    protected ClassifierEvaluationDao classifierEvaluationDao;
    protected ConceptDao conceptDao;
    private InfoContentEvaluator infoContentEvaluator;
    protected JdbcTemplate jdbcTemplate;
    protected KernelUtil kernelUtil;
    protected NamedParameterJdbcTemplate namedParamJdbcTemplate;
    protected PlatformTransactionManager transactionManager;
    private Properties ytexProperties = null;

    protected static double entropy(double[] classProbs) {
        double entropy = 0.0;
        double log2 = Math.log(2.0);
        for (double prob : classProbs) {
            if (!(prob > 0.0)) continue;
            entropy += prob * Math.log(prob) / log2;
        }
        return entropy * -1.0;
    }

    protected static double entropy(Iterable<Double> classProbs) {
        double entropy = 0.0;
        double log2 = Math.log(2.0);
        for (double prob : classProbs) {
            if (!(prob > 0.0)) continue;
            entropy += prob * Math.log(prob) / log2;
        }
        return entropy * -1.0;
    }

    public static void main(String[] args) throws ParseException, IOException {
        Options options = new Options();
        OptionBuilder.withArgName((String)"prop");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"property file with queries and other parameters. todo desc");
        options.addOption(OptionBuilder.create((String)"prop"));
        try {
            GnuParser parser = new GnuParser();
            CommandLine line = parser.parse(options, args);
            if (!((ImputedFeatureEvaluator)KernelContextHolder.getApplicationContext().getBean(ImputedFeatureEvaluator.class)).evaluateCorpus(line.getOptionValue("prop"))) {
                ImputedFeatureEvaluatorImpl.printHelp(options);
            }
        }
        catch (ParseException pe) {
            ImputedFeatureEvaluatorImpl.printHelp(options);
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + ImputedFeatureEvaluatorImpl.class.getName() + " calculate raw, propagated, and imputed infogain for each feature", options);
    }

    private void addSubtree(Set<String> childConcepts, ConcRel cr) {
        childConcepts.add(cr.getConceptID());
        for (ConcRel crc : cr.getChildren()) {
            this.addSubtree(childConcepts, crc);
        }
    }

    private JointDistribution calcMergedJointDistribution(Map<String, JointDistribution> conceptJointDistroMap, Map<String, Integer> conceptDistMap, ConcRel cr, Map<String, JointDistribution> rawJointDistroMap, Map<String, Set<Long>> yMargin, String xMerge, double minInfo, List<String> path) {
        if (conceptJointDistroMap.containsKey(cr.getConceptID())) {
            return conceptJointDistroMap.get(cr.getConceptID());
        }
        ArrayList<JointDistribution> distroList = new ArrayList<JointDistribution>(cr.getChildren().size() + 1);
        int distance = -1;
        if (rawJointDistroMap.containsKey(cr.getConceptID())) {
            JointDistribution rawJointDistro = rawJointDistroMap.get(cr.getConceptID());
            distroList.add(rawJointDistro);
            distance = 0;
        }
        for (ConcRel crc : cr.getChildren()) {
            ArrayList<String> pathChild = new ArrayList<String>(path.size() + 1);
            pathChild.addAll(path);
            pathChild.add(crc.getConceptID());
            JointDistribution jdChild = this.calcMergedJointDistribution(conceptJointDistroMap, conceptDistMap, crc, rawJointDistroMap, yMargin, xMerge, minInfo, pathChild);
            if (jdChild == null) continue;
            distroList.add(jdChild);
            if (distance == 0) continue;
            int distChild = conceptDistMap.get(crc.getConceptID());
            if (distance != -1 && distChild + 1 >= distance) continue;
            distance = distChild + 1;
        }
        JointDistribution mergedDistro = distroList.size() > 0 ? (distroList.size() == 1 ? (JointDistribution)distroList.get(0) : JointDistribution.merge(distroList, yMargin, xMerge)) : null;
        conceptJointDistroMap.put(cr.getConceptID(), mergedDistro);
        if (distance > -1) {
            conceptDistMap.put(cr.getConceptID(), distance);
        }
        return mergedDistro;
    }

    private double calculateFoldEntropy(Map<String, Set<Long>> classCountMap) {
        int total = 0;
        ArrayList<Double> classProbs = new ArrayList<Double>(classCountMap.size());
        for (Set<Long> instances : classCountMap.values()) {
            total += instances.size();
        }
        for (Set<Long> instances : classCountMap.values()) {
            classProbs.add((double)instances.size() / (double)total);
        }
        return ImputedFeatureEvaluatorImpl.entropy(classProbs);
    }

    private Map<String, JointDistribution> completeJointDistroForFold(Map<String, Map<String, Set<Long>>> conceptInstanceMap, Map<String, Set<Long>> yMargin, Set<String> xVals, Set<String> yVals, String xLeftover) {
        HashMap<String, JointDistribution> foldJointDistroMap = new HashMap<String, JointDistribution>(conceptInstanceMap.size());
        for (Map.Entry<String, Map<String, Set<Long>>> conceptInstance : conceptInstanceMap.entrySet()) {
            foldJointDistroMap.put(conceptInstance.getKey(), new JointDistribution(xVals, yVals, conceptInstance.getValue(), yMargin, xLeftover));
        }
        return foldJointDistroMap;
    }

    private void deleteFeatureEval(Parameters params, String label, int foldId) {
        for (String type : new String[]{params.getMeasure().getName(), params.getMeasure().getName() + "-propagated", params.getMeasure().getName() + "-imputed", params.getMeasure().getName() + "-imputed-filt"}) {
            this.classifierEvaluationDao.deleteFeatureEvaluation(params.getCorpusName(), params.getConceptSetName(), label, type, foldId, 0.0, params.getConceptGraphName());
        }
    }

    @Override
    public boolean evaluateCorpus(Parameters params) {
        if (params.getCorpusName() == null || params.getConceptGraphName() == null || params.getLabelQuery() == null || params.getClassFeatureQuery() == null) {
            return false;
        }
        ConceptGraph cg = this.conceptDao.getConceptGraph(params.getConceptGraphName());
        InstanceData instanceData = this.kernelUtil.loadInstances(params.getLabelQuery());
        for (String label : instanceData.getLabelToInstanceMap().keySet()) {
            this.evaluateCorpusLabel(params, cg, instanceData, label);
        }
        return true;
    }

    @Override
    public boolean evaluateCorpus(String propFile) throws IOException {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.getYtexProperties());
        props.putAll((Map<?, ?>)FileUtil.loadProperties(propFile, true));
        return this.evaluateCorpus(new Parameters(props));
    }

    private void evaluateCorpusFold(Parameters params, Map<String, Set<Long>> yMargin, ConceptGraph cg, InstanceData instanceData, String label, Map<String, Map<String, Set<Long>>> conceptInstanceMap, int foldId) {
        if (log.isInfoEnabled()) {
            log.info((Object)("evaluateCorpusFold() label = " + label + ", fold = " + foldId));
        }
        this.deleteFeatureEval(params, label, foldId);
        double yEntropy = this.calculateFoldEntropy(yMargin);
        Map<String, JointDistribution> rawJointDistro = this.completeJointDistroForFold(conceptInstanceMap, yMargin, params.getxVals(), (Set)instanceData.getLabelToClassMap().get(label), params.getxLeftover());
        ArrayList<FeatureRank> listRawRanks = new ArrayList<FeatureRank>(rawJointDistro.size());
        FeatureEvaluation feRaw = this.saveFeatureEvaluation(rawJointDistro, params, label, foldId, yEntropy, "", listRawRanks);
        this.propagateJointDistribution(rawJointDistro, params, label, foldId, cg, yMargin);
        this.storeChildConcepts(listRawRanks, params, label, foldId, cg, true);
        this.storeChildConcepts(listRawRanks, params, label, foldId, cg, false);
    }

    private void evaluateCorpusLabel(Parameters params, ConceptGraph cg, InstanceData instanceData, String label) {
        if (log.isInfoEnabled()) {
            log.info((Object)("evaluateCorpusLabel() label = " + label));
        }
        Map<String, Map<String, Set<Long>>> conceptInstanceMap = this.loadConceptInstanceMap(params.getClassFeatureQuery(), cg, label);
        Iterator i$ = ((SortedMap)instanceData.getLabelToInstanceMap().get(label)).keySet().iterator();
        while (i$.hasNext()) {
            int run = (Integer)i$.next();
            Iterator i$2 = ((SortedMap)((SortedMap)instanceData.getLabelToInstanceMap().get(label)).get(run)).keySet().iterator();
            while (i$2.hasNext()) {
                int fold = (Integer)i$2.next();
                int foldId = this.getFoldId(params, label, run, fold);
                Map<String, Set<Long>> yMargin = this.getFoldYMargin(instanceData, label, run, fold);
                this.evaluateCorpusFold(params, yMargin, cg, instanceData, label, conceptInstanceMap, foldId);
            }
        }
    }

    public ClassifierEvaluationDao getClassifierEvaluationDao() {
        return this.classifierEvaluationDao;
    }

    public ConceptDao getConceptDao() {
        return this.conceptDao;
    }

    public DataSource getDataSource(DataSource ds) {
        return this.jdbcTemplate.getDataSource();
    }

    private int getFoldId(Parameters params, String label, int run, int fold) {
        int foldId = 0;
        if (run > 0 && fold > 0) {
            CrossValidationFold cvFold = this.classifierEvaluationDao.getCrossValidationFold(params.getCorpusName(), params.getSplitName(), label, run, fold);
            if (cvFold != null) {
                foldId = cvFold.getCrossValidationFoldId();
            } else {
                log.warn((Object)("could not find cv fold, name=" + params.getCorpusName() + ", run=" + run + ", fold=" + fold));
            }
        }
        return foldId;
    }

    private Map<String, Set<Long>> getFoldYMargin(InstanceData instanceData, String label, int run, int fold) {
        Map instanceClassMap = (Map)((SortedMap)((SortedMap)((SortedMap)instanceData.getLabelToInstanceMap().get(label)).get(run)).get(fold)).get(true);
        HashMap<String, Set<Long>> yMargin = new HashMap<String, Set<Long>>();
        for (Map.Entry instanceClass : instanceClassMap.entrySet()) {
            HashSet instanceIds = (HashSet)yMargin.get(instanceClass.getValue());
            if (instanceIds == null) {
                instanceIds = new HashSet();
                yMargin.put((String)instanceClass.getValue(), instanceIds);
            }
            instanceIds.add(instanceClass.getKey());
        }
        return yMargin;
    }

    public InfoContentEvaluator getInfoContentEvaluator() {
        return this.infoContentEvaluator;
    }

    public KernelUtil getKernelUtil() {
        return this.kernelUtil;
    }

    public Properties getYtexProperties() {
        return this.ytexProperties;
    }

    private FeatureEvaluation initFeatureEval(Parameters params, String label, int foldId, String type) {
        FeatureEvaluation feval = new FeatureEvaluation();
        feval.setCorpusName(params.getCorpusName());
        feval.setLabel(label);
        feval.setCrossValidationFoldId(foldId);
        feval.setParam2(params.getConceptGraphName());
        feval.setEvaluationType(type);
        feval.setFeatureSetName(params.getConceptSetName());
        return feval;
    }

    private Map<String, Map<String, Set<Long>>> loadConceptInstanceMap(String classFeatureQuery, ConceptGraph cg, String label) {
        HashMap<String, Map<String, Set<Long>>> conceptInstanceMap = new HashMap<String, Map<String, Set<Long>>>();
        HashMap<String, String> args = new HashMap<String, String>(1);
        if (label != null && label.length() > 0) {
            args.put("label", label);
        }
        ConceptInstanceMapExtractor ex = new ConceptInstanceMapExtractor(conceptInstanceMap, cg);
        this.namedParamJdbcTemplate.query(classFeatureQuery, args, (RowCallbackHandler)ex);
        return conceptInstanceMap;
    }

    private FeatureEvaluation propagateJointDistribution(Map<String, JointDistribution> rawJointDistroMap, Parameters params, String label, int foldId, ConceptGraph cg, Map<String, Set<Long>> yMargin) {
        double yEntropy = this.calculateFoldEntropy(yMargin);
        HashMap<String, JointDistribution> conceptJointDistroMap = new HashMap<String, JointDistribution>(cg.getConceptMap().size());
        HashMap<String, Integer> conceptDistMap = new HashMap<String, Integer>();
        this.calcMergedJointDistribution(conceptJointDistroMap, conceptDistMap, cg.getConceptMap().get(cg.getRoot()), rawJointDistroMap, yMargin, params.getxMerge(), params.getMinInfo(), Arrays.asList(cg.getRoot()));
        ArrayList<FeatureRank> listPropRanks = new ArrayList<FeatureRank>(conceptJointDistroMap.size());
        return this.saveFeatureEvaluation(conceptJointDistroMap, params, label, foldId, yEntropy, "-propagated", listPropRanks);
    }

    private List<FeatureRank> rank(ImputedFeatureEvaluator.MeasureType measureType, FeatureEvaluation fe, Map<String, JointDistribution> rawJointDistro, double yEntropy, List<FeatureRank> featureRankList) {
        for (Map.Entry<String, JointDistribution> conceptJointDistro : rawJointDistro.entrySet()) {
            double evaluation;
            JointDistribution d = conceptJointDistro.getValue();
            if (d == null || !((evaluation = ImputedFeatureEvaluator.MeasureType.MUTUALINFO.equals((Object)measureType) ? d.getMutualInformation(yEntropy) : d.getInfoGain()) > 0.001)) continue;
            FeatureRank r = new FeatureRank(fe, conceptJointDistro.getKey(), evaluation);
            featureRankList.add(r);
        }
        return FeatureRank.sortFeatureRankList(featureRankList, new FeatureRank.FeatureRankDesc());
    }

    private FeatureEvaluation saveFeatureEvaluation(Map<String, JointDistribution> rawJointDistro, Parameters params, String label, int foldId, double yEntropy, String suffix, List<FeatureRank> listRawRanks) {
        FeatureEvaluation fe = this.initFeatureEval(params, label, foldId, params.getMeasure().getName() + suffix);
        this.classifierEvaluationDao.saveFeatureEvaluation(fe, this.rank(params.getMeasure(), fe, rawJointDistro, yEntropy, listRawRanks));
        return fe;
    }

    public void setClassifierEvaluationDao(ClassifierEvaluationDao classifierEvaluationDao) {
        this.classifierEvaluationDao = classifierEvaluationDao;
    }

    public void setConceptDao(ConceptDao conceptDao) {
        this.conceptDao = conceptDao;
    }

    public void setDataSource(DataSource ds) {
        this.jdbcTemplate = new JdbcTemplate(ds);
        this.namedParamJdbcTemplate = new NamedParameterJdbcTemplate(ds);
    }

    public void setInfoContentEvaluator(InfoContentEvaluator infoContentEvaluator) {
        this.infoContentEvaluator = infoContentEvaluator;
    }

    public void setKernelUtil(KernelUtil kernelUtil) {
        this.kernelUtil = kernelUtil;
    }

    public void setYtexProperties(Properties ytexProperties) {
        this.ytexProperties = ytexProperties;
    }

    public void storeChildConcepts(List<FeatureRank> listRawRanks, Parameters params, String label, int foldId, ConceptGraph cg, boolean bAll) {
        Map<String, Double> conceptICMap = bAll ? this.classifierEvaluationDao.getInfoContent(params.getCorpusName(), params.getConceptGraphName(), params.getConceptSetName()) : this.infoContentEvaluator.getFrequencies(params.getFreqQuery());
        HashMap<String, Double> conceptRawEvalMap = new HashMap<String, Double>(listRawRanks.size());
        for (FeatureRank r : listRawRanks) {
            conceptRawEvalMap.put(r.getFeatureName(), r.getEvaluation());
        }
        HashMap<FeatureRank, Set<FeatureRank>> childParentMap = bAll ? null : new HashMap<FeatureRank, Set<FeatureRank>>();
        String propagatedType = params.getMeasure().getName() + "-propagated";
        List<FeatureRank> listConceptStat = params.getParentConceptTopThreshold() != null ? this.classifierEvaluationDao.getTopFeatures(params.getCorpusName(), params.getConceptSetName(), label, propagatedType, foldId, 0.0, params.getConceptGraphName(), params.getParentConceptTopThreshold()) : this.classifierEvaluationDao.getThresholdFeatures(params.getCorpusName(), params.getConceptSetName(), label, propagatedType, foldId, 0.0, params.getConceptGraphName(), params.getParentConceptEvalThreshold());
        FeatureEvaluation fe = this.initFeatureEval(params, label, foldId, params.getMeasure().getName() + (bAll ? "-imputed" : "-imputed-filt"));
        HashMap<String, FeatureRank> mapChildConcept = new HashMap<String, FeatureRank>();
        for (FeatureRank parentConcept : listConceptStat) {
            this.updateChildren(parentConcept, mapChildConcept, fe, cg, conceptICMap, conceptRawEvalMap, childParentMap, params.getImputeWeight(), params.getMinInfo());
        }
        ArrayList<FeatureRank> features = new ArrayList<FeatureRank>(mapChildConcept.values());
        FeatureRank.sortFeatureRankList(features, new FeatureRank.FeatureRankDesc());
        this.classifierEvaluationDao.saveFeatureEvaluation(fe, features);
        if (!bAll) {
            for (Map.Entry childParentEntry : childParentMap.entrySet()) {
                FeatureRank child = (FeatureRank)childParentEntry.getKey();
                for (FeatureRank parent : (Set)childParentEntry.getValue()) {
                    FeatureParentChild parchd = new FeatureParentChild();
                    parchd.setFeatureRankParent(parent);
                    parchd.setFeatureRankChild(child);
                    this.classifierEvaluationDao.saveFeatureParentChild(parchd);
                }
            }
        }
    }

    private void updateChildren(FeatureRank parentConcept, Map<String, FeatureRank> mapChildConcept, FeatureEvaluation fe, ConceptGraph cg, Map<String, Double> conceptICMap, Map<String, Double> conceptRawEvalMap, Map<FeatureRank, Set<FeatureRank>> childParentMap, double imputeWeight, double minInfo) {
        ConcRel cr = cg.getConceptMap().get(parentConcept.getFeatureName());
        HashSet<String> childConcepts = new HashSet<String>();
        this.addSubtree(childConcepts, cr);
        for (String childConceptId : childConcepts) {
            if (!conceptICMap.containsKey(childConceptId)) continue;
            FeatureRank chd = mapChildConcept.get(childConceptId);
            if (chd == null) {
                chd = new FeatureRank(fe, childConceptId, 0.0);
                mapChildConcept.put(childConceptId, chd);
            }
            double rawEvaluation = conceptRawEvalMap.containsKey(childConceptId) ? conceptRawEvalMap.get(childConceptId) : minInfo;
            double imputedEvaluation = imputeWeight * parentConcept.getEvaluation() + (1.0 - imputeWeight) * rawEvaluation;
            if (chd.getEvaluation() < imputedEvaluation) {
                chd.setEvaluation(imputedEvaluation);
            }
            if (childParentMap == null) continue;
            Set<FeatureRank> parents = childParentMap.get(chd);
            if (parents == null) {
                parents = new HashSet<FeatureRank>(10);
                childParentMap.put(chd, parents);
            }
            parents.add(parentConcept);
        }
    }

    public static class Parameters {
        String classFeatureQuery;
        String conceptGraphName;
        String conceptSetName;
        String corpusName;
        String freqQuery;
        double imputeWeight;
        String labelQuery;
        ImputedFeatureEvaluator.MeasureType measure;
        double minInfo;
        Double parentConceptEvalThreshold;
        Integer parentConceptTopThreshold;
        String splitName;
        String xLeftover;
        String xMerge;
        Set<String> xVals;

        public Parameters() {
        }

        public Parameters(Properties props) {
            this.corpusName = props.getProperty("org.apache.ctakes.ytex.corpusName");
            this.conceptGraphName = props.getProperty("org.apache.ctakes.ytex.conceptGraphName");
            this.conceptSetName = props.getProperty("org.apache.ctakes.ytex.conceptSetName");
            this.splitName = props.getProperty("org.apache.ctakes.ytex.splitName");
            this.labelQuery = props.getProperty("instanceClassQuery");
            this.classFeatureQuery = props.getProperty("org.apache.ctakes.ytex.conceptInstanceQuery");
            this.freqQuery = props.getProperty("org.apache.ctakes.ytex.freqQuery");
            this.minInfo = Double.parseDouble(props.getProperty("min.info", "1e-4"));
            String xValStr = props.getProperty("org.apache.ctakes.ytex.xVals", "0,1");
            this.xVals = new HashSet<String>();
            this.xVals.addAll(Arrays.asList(xValStr.split(",")));
            this.xLeftover = props.getProperty("org.apache.ctakes.ytex.xLeftover", "0");
            this.xMerge = props.getProperty("org.apache.ctakes.ytex.xMerge", "1");
            this.measure = ImputedFeatureEvaluator.MeasureType.valueOf(props.getProperty("org.apache.ctakes.ytex.measure", "INFOGAIN"));
            this.parentConceptEvalThreshold = FileUtil.getDoubleProperty(props, "org.apache.ctakes.ytex.parentConceptEvalThreshold", null);
            this.parentConceptTopThreshold = this.parentConceptEvalThreshold == null ? FileUtil.getIntegerProperty(props, "org.apache.ctakes.ytex.parentConceptTopThreshold", 25) : null;
            this.imputeWeight = FileUtil.getDoubleProperty(props, "org.apache.ctakes.ytex.imputeWeight", 1.0);
        }

        public String getClassFeatureQuery() {
            return this.classFeatureQuery;
        }

        public String getConceptGraphName() {
            return this.conceptGraphName;
        }

        public String getConceptSetName() {
            return this.conceptSetName;
        }

        public String getCorpusName() {
            return this.corpusName;
        }

        public String getFreqQuery() {
            return this.freqQuery;
        }

        public double getImputeWeight() {
            return this.imputeWeight;
        }

        public String getLabelQuery() {
            return this.labelQuery;
        }

        public ImputedFeatureEvaluator.MeasureType getMeasure() {
            return this.measure;
        }

        public double getMinInfo() {
            return this.minInfo;
        }

        public Double getParentConceptEvalThreshold() {
            return this.parentConceptEvalThreshold;
        }

        public Integer getParentConceptTopThreshold() {
            return this.parentConceptTopThreshold;
        }

        public String getSplitName() {
            return this.splitName;
        }

        public String getxLeftover() {
            return this.xLeftover;
        }

        public String getxMerge() {
            return this.xMerge;
        }

        public Set<String> getxVals() {
            return this.xVals;
        }
    }

    public static class JointDistribution {
        protected double[][] contingencyTable;
        protected Double entropyX = null;
        protected Double entropyXY = null;
        protected SortedMap<String, SortedMap<String, Set<Long>>> jointDistroTable;
        protected Set<String> xVals;
        protected Set<String> yVals;

        public static JointDistribution merge(List<JointDistribution> jointDistros, Map<String, Set<Long>> yMargin, String xMerge) {
            Set<String> xVals = jointDistros.get((int)0).xVals;
            Set<String> yVals = jointDistros.get((int)0).yVals;
            JointDistribution mergedDistro = new JointDistribution(xVals, yVals);
            for (String y : yVals) {
                Set<Long> xMergedInst = mergedDistro.getInstances(xMerge, y);
                xMergedInst.addAll((Collection<Long>)yMargin.get(y));
                for (String x : xVals) {
                    if (x.equals(xMerge)) continue;
                    Set<Long> intersectIds = mergedDistro.getInstances(x, y);
                    boolean bFirstIter = true;
                    for (JointDistribution distro : jointDistros) {
                        if (bFirstIter) {
                            intersectIds.addAll(distro.getInstances(x, y));
                            bFirstIter = false;
                            continue;
                        }
                        intersectIds.retainAll(distro.getInstances(x, y));
                    }
                    xMergedInst.removeAll(intersectIds);
                }
            }
            return mergedDistro;
        }

        public JointDistribution(Set<String> xVals, Set<String> yVals) {
            this.xVals = xVals;
            this.yVals = yVals;
            this.jointDistroTable = new TreeMap<String, SortedMap<String, Set<Long>>>();
            for (String yVal : yVals) {
                TreeMap yMap = new TreeMap();
                this.jointDistroTable.put(yVal, yMap);
                for (String xVal : xVals) {
                    yMap.put(xVal, new HashSet());
                }
            }
        }

        public JointDistribution(Set<String> xVals, Set<String> yVals, Map<String, Set<Long>> xMargin, Map<String, Set<Long>> yMargin, String xLeftover) {
            this.xVals = xVals;
            this.yVals = yVals;
            this.jointDistroTable = new TreeMap<String, SortedMap<String, Set<Long>>>();
            for (String string : yVals) {
                TreeMap yMap = new TreeMap();
                this.jointDistroTable.put(string, yMap);
                for (String xVal : xVals) {
                    yMap.put(xVal, new HashSet());
                }
            }
            for (Map.Entry entry : yMargin.entrySet()) {
                String yName = (String)entry.getKey();
                HashSet yInst = new HashSet((Collection)entry.getValue());
                for (Map.Entry<String, Set<Long>> xEntry : xMargin.entrySet()) {
                    Set foldXInst = (Set)((SortedMap)this.jointDistroTable.get(yName)).get(xEntry.getKey());
                    foldXInst.addAll((Collection)xEntry.getValue());
                    foldXInst.retainAll(yInst);
                    yInst.removeAll(foldXInst);
                }
                if (yInst.size() <= 0) continue;
                ((Set)((SortedMap)this.jointDistroTable.get(entry.getKey())).get(xLeftover)).addAll(yInst);
            }
        }

        public double[][] getContingencyTable() {
            if (this.contingencyTable == null) {
                this.contingencyTable = new double[this.yVals.size()][this.xVals.size()];
                int i = 0;
                for (String yVal : this.yVals) {
                    int j = 0;
                    for (String xVal : this.xVals) {
                        this.contingencyTable[i][j] = ((Set)((SortedMap)this.jointDistroTable.get(yVal)).get(xVal)).size();
                        ++j;
                    }
                    ++i;
                }
            }
            return this.contingencyTable;
        }

        public double getEntropyX() {
            double[] probs = new double[this.xVals.size()];
            Arrays.fill(probs, 0.0);
            if (this.entropyX == null) {
                double nTotal = 0.0;
                for (Map map : this.jointDistroTable.values()) {
                    int i = 0;
                    for (Set instances : map.values()) {
                        double nCell = instances.size();
                        nTotal += nCell;
                        int n = i++;
                        probs[n] = probs[n] + nCell;
                    }
                }
                int i = 0;
                while (i < probs.length) {
                    int n = i++;
                    probs[n] = probs[n] / nTotal;
                }
                this.entropyX = ImputedFeatureEvaluatorImpl.entropy(probs);
            }
            return this.entropyX;
        }

        public double getEntropyXY() {
            double[] probs = new double[this.xVals.size() * this.yVals.size()];
            Arrays.fill(probs, 0.0);
            if (this.entropyXY == null) {
                double nTotal = 0.0;
                int i = 0;
                for (Map map : this.jointDistroTable.values()) {
                    for (Set instances : map.values()) {
                        probs[i] = instances.size();
                        nTotal += probs[i];
                        ++i;
                    }
                }
                int j = 0;
                while (j < probs.length) {
                    int n = j++;
                    probs[n] = probs[n] / nTotal;
                }
                this.entropyXY = ImputedFeatureEvaluatorImpl.entropy(probs);
            }
            return this.entropyXY;
        }

        public double getInfoGain() {
            return ContingencyTables.entropyOverColumns((double[][])this.getContingencyTable()) - ContingencyTables.entropyConditionedOnRows((double[][])this.getContingencyTable());
        }

        public Set<Long> getInstances(String x, String y) {
            return (Set)((SortedMap)this.jointDistroTable.get(y)).get(x);
        }

        public double getMutualInformation(double entropyY) {
            return entropyY + this.getEntropyX() - this.getEntropyXY();
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.getClass().getCanonicalName());
            b.append(" [jointDistro=(");
            Iterator<Map.Entry<String, SortedMap<String, Set<Long>>>> yIter = this.jointDistroTable.entrySet().iterator();
            while (yIter.hasNext()) {
                Map.Entry<String, SortedMap<String, Set<Long>>> yEntry = yIter.next();
                Iterator<Map.Entry<String, Set<Long>>> xIter = yEntry.getValue().entrySet().iterator();
                while (xIter.hasNext()) {
                    Map.Entry<String, Set<Long>> xEntry = xIter.next();
                    b.append(xEntry.getValue().size());
                    if (!xIter.hasNext()) continue;
                    b.append(", ");
                }
                if (!yIter.hasNext()) continue;
                b.append("| ");
            }
            b.append(")]");
            return b.toString();
        }
    }

    public class ConceptInstanceMapExtractor
    implements RowCallbackHandler {
        ConceptGraph cg;
        Map<String, Map<String, Set<Long>>> conceptInstanceMap;

        ConceptInstanceMapExtractor(Map<String, Map<String, Set<Long>>> conceptInstanceMap, ConceptGraph cg) {
            this.cg = cg;
            this.conceptInstanceMap = conceptInstanceMap;
        }

        public void processRow(ResultSet rs) throws SQLException {
            Set<Long> instanceIds;
            String conceptId = rs.getString(1);
            long instanceId = rs.getLong(2);
            String x = rs.getString(3);
            Map<String, Set<Long>> binInstanceMap = this.conceptInstanceMap.get(conceptId);
            if (binInstanceMap == null) {
                binInstanceMap = new HashMap<String, Set<Long>>(2);
                this.conceptInstanceMap.put(conceptId, binInstanceMap);
            }
            if ((instanceIds = binInstanceMap.get(x)) == null) {
                instanceIds = new HashSet<Long>();
                binInstanceMap.put(x, instanceIds);
            }
            instanceIds.add(instanceId);
        }
    }
}

