/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel;

import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.FileUtil;
import org.apache.ctakes.ytex.kernel.IntrinsicInfoContentEvaluator;
import org.apache.ctakes.ytex.kernel.KernelContextHolder;
import org.apache.ctakes.ytex.kernel.dao.ClassifierEvaluationDao;
import org.apache.ctakes.ytex.kernel.dao.ConceptDao;
import org.apache.ctakes.ytex.kernel.model.ConcRel;
import org.apache.ctakes.ytex.kernel.model.ConceptGraph;
import org.apache.ctakes.ytex.kernel.model.FeatureEvaluation;
import org.apache.ctakes.ytex.kernel.model.FeatureRank;

public class IntrinsicInfoContentEvaluatorImpl
implements IntrinsicInfoContentEvaluator {
    private static final Log log = LogFactory.getLog(IntrinsicInfoContentEvaluatorImpl.class);
    private static final double log2adjust = 1.0 / Math.log(2.0);
    private ClassifierEvaluationDao classifierEvaluationDao;
    private ConceptDao conceptDao;

    public static void main(String[] args) throws IOException {
        Properties props = (Properties)KernelContextHolder.getApplicationContext().getBean("ytexProperties");
        props.putAll((Map<?, ?>)System.getProperties());
        if (!props.containsKey("org.apache.ctakes.ytex.conceptGraphName")) {
            System.err.println("error: org.apache.ctakes.ytex.conceptGraphName not specified");
            System.exit(1);
        } else {
            IntrinsicInfoContentEvaluator corpusEvaluator = (IntrinsicInfoContentEvaluator)KernelContextHolder.getApplicationContext().getBean(IntrinsicInfoContentEvaluator.class);
            corpusEvaluator.evaluateIntrinsicInfoContent(props);
            System.exit(0);
        }
    }

    private double computeIC(IntrinsicICInfo icInfo, int maxLeaves) {
        double denom = log2adjust * Math.log((double)icInfo.getLeafCount() / (double)icInfo.getSubsumerCount() + 1.0);
        double num = log2adjust * Math.log((double)maxLeaves + 1.0);
        if (denom == Double.NaN || num == Double.NaN) {
            log.error((Object)("IC = NaN for " + icInfo.getConcept().getConceptID() + ", leafCount=" + icInfo.getLeafCount() + ", subsumerCount = " + icInfo.getSubsumerCount()));
            return -1.0;
        }
        return num - denom;
    }

    private TIntSet getLeaves(ConcRel concept, SoftReference<TIntSet>[] leafCache, Map<String, IntrinsicICInfo> icInfoMap, ConceptGraph cg, BufferedWriter w, TIntSet visitedNodes) throws IOException {
        SoftReference<TIntSet> refLeaves = leafCache[concept.getNodeIndex()];
        if (refLeaves != null && refLeaves.get() != null) {
            return refLeaves.get();
        }
        TIntHashSet leaves = new TIntHashSet();
        leafCache[concept.getNodeIndex()] = new SoftReference<TIntHashSet>(leaves);
        if (concept.isLeaf()) {
            leaves.add(concept.getNodeIndex());
        } else {
            IntrinsicICInfo icInfo = icInfoMap.get(concept.getConceptID());
            boolean needLeaves = icInfo != null && icInfo.getLeafCount() == 0;
            TIntSet visitedNodesLocal = visitedNodes;
            if (needLeaves || visitedNodesLocal == null) {
                visitedNodesLocal = new TIntHashSet();
            }
            for (ConcRel child : concept.getChildren()) {
                if (visitedNodesLocal.contains(child.getNodeIndex())) continue;
                leaves.addAll((TIntCollection)this.getLeaves(child, leafCache, icInfoMap, cg, w, visitedNodesLocal));
            }
            if (visitedNodes != null && visitedNodes != visitedNodesLocal) {
                visitedNodes.add(concept.getNodeIndex());
                visitedNodes.addAll((TIntCollection)visitedNodesLocal);
            }
            if (needLeaves) {
                icInfo.setLeafCount(leaves.size());
                if (w != null) {
                    w.write(concept.getConceptID());
                    w.write("\t");
                    w.write(Integer.toString(leaves.size()));
                    w.write("\t");
                    TIntIterator iter = leaves.iterator();
                    while (iter.hasNext()) {
                        w.write(cg.getConceptList().get(iter.next()).getConceptID());
                        w.write(" ");
                    }
                    w.newLine();
                }
            }
        }
        return leaves;
    }

    private void computeSubsumerCount(ConcRel concept, Map<String, IntrinsicICInfo> icInfoMap, Map<String, Set<String>> subsumerMap, short[] depthArray, BufferedWriter w) throws IOException {
        IntrinsicICInfo icInfo = icInfoMap.get(concept.getConceptID());
        if (icInfo != null && icInfo.getSubsumerCount() > 0) {
            return;
        }
        if (icInfo == null) {
            icInfo = new IntrinsicICInfo(concept);
            icInfoMap.put(concept.getConceptID(), icInfo);
        }
        Set<String> subsumers = this.getSubsumers(concept, subsumerMap, depthArray);
        if (w != null) {
            w.write(concept.getConceptID());
            w.write("\t");
            w.write(Integer.toString(subsumers.size()));
            w.write("\t");
            w.write(subsumers.toString());
            w.newLine();
        }
        icInfo.setSubsumerCount(subsumers.size());
        for (ConcRel child : concept.getChildren()) {
            this.computeSubsumerCount(child, icInfoMap, subsumerMap, depthArray, w);
        }
    }

    @Override
    public void evaluateIntrinsicInfoContent(Properties props) throws IOException {
        String conceptGraphName = props.getProperty("org.apache.ctakes.ytex.conceptGraphName");
        String conceptGraphDir = props.getProperty("org.apache.ctakes.ytex.conceptGraphDir", System.getProperty("java.io.tmpdir"));
        ConceptGraph cg = this.conceptDao.getConceptGraph(conceptGraphName);
        this.evaluateIntrinsicInfoContent(conceptGraphName, conceptGraphDir, cg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluateIntrinsicInfoContent(String conceptGraphName, String conceptGraphDir, ConceptGraph cg) throws IOException {
        log.info((Object)"computing subsumer counts");
        HashMap<String, IntrinsicICInfo> icInfoMap = new HashMap<String, IntrinsicICInfo>();
        WeakHashMap<String, Set<String>> subsumerMap = new WeakHashMap<String, Set<String>>();
        short[] depthArray = new short[cg.getConceptList().size()];
        BufferedWriter w = null;
        try {
            w = this.getOutputFile(conceptGraphName, conceptGraphDir, "subsumer");
            this.computeSubsumerCount(cg.getConceptMap().get(cg.getRoot()), icInfoMap, subsumerMap, depthArray, w);
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException e) {}
            }
        }
        subsumerMap = null;
        log.info((Object)"computing max leaves");
        Set<String> leafSet = null;
        try {
            w = this.getOutputFile(conceptGraphName, conceptGraphDir, "allleaf");
            leafSet = this.getAllLeaves(cg, w);
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException e) {}
            }
        }
        log.info((Object)"computing leaf counts");
        SoftReference[] leafCache = (SoftReference[])Array.newInstance(new SoftReference<TIntHashSet>(new TIntHashSet()).getClass(), cg.getConceptList().size());
        try {
            w = this.getOutputFile(conceptGraphName, conceptGraphDir, "leaf");
            this.getLeaves(cg.getConceptMap().get(cg.getRoot()), leafCache, icInfoMap, cg, w, null);
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException e) {}
            }
        }
        leafCache = null;
        log.info((Object)"storing intrinsic ic");
        this.storeIntrinsicIC(conceptGraphName, leafSet.size(), icInfoMap, depthArray, cg);
        log.info((Object)"finished computing intrinsic ic");
    }

    private BufferedWriter getOutputFile(String conceptGraphName, String conceptGraphDir, String type) throws IOException {
        if ("true".equalsIgnoreCase(System.getProperty("org.apache.ctakes.ytex.ic.debug", "false"))) {
            return new BufferedWriter(new FileWriter(FileUtil.addFilenameToDir(conceptGraphDir, conceptGraphName + "-" + type + ".txt")));
        }
        return null;
    }

    public Set<String> getAllLeaves(ConceptGraph cg, BufferedWriter w) throws IOException {
        HashSet<String> leafSet = new HashSet<String>();
        for (Map.Entry<String, ConcRel> con : cg.getConceptMap().entrySet()) {
            if (!con.getValue().isLeaf()) continue;
            leafSet.add(con.getValue().getConceptID());
        }
        if (w != null) {
            w.write(Integer.toString(leafSet.size()));
            w.write("\t");
            w.write(((Object)leafSet).toString());
            w.newLine();
        }
        return leafSet;
    }

    public ClassifierEvaluationDao getClassifierEvaluationDao() {
        return this.classifierEvaluationDao;
    }

    public ConceptDao getConceptDao() {
        return this.conceptDao;
    }

    private Set<String> getSubsumers(ConcRel concept, Map<String, Set<String>> subsumerMap, short[] depthArray) {
        if (subsumerMap.containsKey(concept.getConceptID())) {
            return subsumerMap.get(concept.getConceptID());
        }
        HashSet<String> subsumers = new HashSet<String>();
        boolean calcDepth = depthArray[concept.getNodeIndex()] == 0;
        short parentMaxDepth = 0;
        if (concept.getParents() != null && !concept.getParents().isEmpty()) {
            for (ConcRel parent : concept.getParents()) {
                short parentDepth;
                subsumers.addAll(this.getSubsumers(parent, subsumerMap, depthArray));
                if (!calcDepth || (parentDepth = depthArray[parent.getNodeIndex()]) <= parentMaxDepth) continue;
                parentMaxDepth = parentDepth;
            }
        }
        if (calcDepth) {
            depthArray[concept.getNodeIndex()] = (short)(parentMaxDepth + 1);
        }
        subsumers.add(concept.getConceptID());
        subsumerMap.put(new String(concept.getConceptID()), subsumers);
        return subsumers;
    }

    public void setClassifierEvaluationDao(ClassifierEvaluationDao classifierEvaluationDao) {
        this.classifierEvaluationDao = classifierEvaluationDao;
    }

    public void setConceptDao(ConceptDao conceptDao) {
        this.conceptDao = conceptDao;
    }

    private void storeIntrinsicIC(String conceptGraphName, int maxLeaves, Map<String, IntrinsicICInfo> icInfoMap, short[] depthArray, ConceptGraph cg) {
        FeatureEvaluation fe = new FeatureEvaluation();
        fe.setEvaluationType("intrinsic-infocontent");
        fe.setParam2(conceptGraphName);
        ArrayList<FeatureRank> listFeatureRank = new ArrayList<FeatureRank>(icInfoMap.size());
        double maxIC = 0.0;
        short maxDepth = 0;
        for (IntrinsicICInfo icInfo : icInfoMap.values()) {
            ConcRel cr = icInfo.getConcept();
            short depth = depthArray[cr.getNodeIndex()];
            cr.setDepth(depth);
            if (depth > maxDepth) {
                maxDepth = depth;
            }
            double ic = this.computeIC(icInfo, maxLeaves);
            cr.setIntrinsicInfoContent(ic);
            if (ic > maxIC) {
                maxIC = ic;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(icInfo.getConcept().getConceptID() + "=" + ic));
            }
            listFeatureRank.add(new FeatureRank(fe, icInfo.getConcept().getConceptID(), ic, depthArray[icInfo.getConcept().getNodeIndex()]));
        }
        cg.setDepthMax(maxDepth);
        cg.setIntrinsicICMax(maxIC);
        if ("true".equalsIgnoreCase(System.getProperty("org.apache.ctakes.ytex.ic.debug", "false"))) {
            this.classifierEvaluationDao.deleteFeatureEvaluation(null, null, null, fe.getEvaluationType(), null, 0.0, conceptGraphName);
            this.classifierEvaluationDao.saveFeatureEvaluation(fe, listFeatureRank);
        }
    }

    public static class IntrinsicICInfo {
        private ConcRel concept;
        private int leafCount = 0;
        private int subsumerCount = 0;

        public IntrinsicICInfo(ConcRel concept) {
            this.concept = concept;
        }

        public ConcRel getConcept() {
            return this.concept;
        }

        public int getLeafCount() {
            return this.leafCount;
        }

        public int getSubsumerCount() {
            return this.subsumerCount;
        }

        public void setConcept(ConcRel concept) {
            this.concept = concept;
        }

        public void setLeafCount(int leafCount) {
            this.leafCount = leafCount;
        }

        public void setSubsumerCount(int subsumerCount) {
            this.subsumerCount = subsumerCount;
        }
    }
}

