/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.dao;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.IntrinsicInfoContentEvaluator;
import org.apache.ctakes.ytex.kernel.KernelContextHolder;
import org.apache.ctakes.ytex.kernel.dao.ConceptDao;
import org.apache.ctakes.ytex.kernel.model.ConcRel;
import org.apache.ctakes.ytex.kernel.model.ConceptGraph;
import org.hibernate.SessionFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public class ConceptDaoImpl
implements ConceptDao {
    private static final String CONCEPT_GRAPH_PATH = "org/apache/ctakes/ytex/conceptGraph/";
    private static final String DEFAULT_ROOT_ID = "C0000000";
    private static final String[] defaultForbiddenConceptArr = new String[]{"C1274012", "C1274013", "C1276325", "C1274014", "C1274015", "C1274021", "C1443286", "C1274012", "C2733115"};
    private static Set<String> defaultForbiddenConcepts;
    private static final Log log;
    private IntrinsicInfoContentEvaluator intrinsicInfoContentEvaluator;
    private JdbcTemplate jdbcTemplate;
    private SessionFactory sessionFactory;
    private Properties ytexProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ParseException, IOException {
        Options options = new Options();
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"name of concept graph.  A property file with the name org/apache/ctakes/ytex/conceptGraph//[name].xml must exist on the classpath");
        options.addOption(OptionBuilder.create((String)"name"));
        try {
            Set<String> forbiddenConcepts;
            GnuParser parser = new GnuParser();
            CommandLine line = parser.parse(options, args);
            String name = line.getOptionValue("name");
            String propRes = CONCEPT_GRAPH_PATH + name + ".xml";
            URL url = ConceptDaoImpl.class.getClassLoader().getResource(propRes);
            if (url == null) {
                System.out.println("properties file could not be located: " + propRes);
                return;
            }
            Properties props = new Properties();
            try (InputStream is = ConceptDaoImpl.class.getClassLoader().getResourceAsStream(propRes);){
                props.loadFromXML(is);
            }
            File fDir = null;
            if ("file".equals(url.getProtocol())) {
                File f;
                try {
                    f = new File(url.toURI());
                }
                catch (URISyntaxException e) {
                    f = new File(url.getPath());
                }
                fDir = f.getParentFile();
            }
            String conceptGraphQuery = props.getProperty("ytex.conceptGraphQuery");
            String strCheckCycle = props.getProperty("ytex.checkCycle", "true");
            String forbiddenConceptList = props.getProperty("ytex.forbiddenConcepts");
            if (forbiddenConceptList != null) {
                forbiddenConcepts = new HashSet<String>();
                forbiddenConcepts.addAll(Arrays.asList(forbiddenConceptList.split(",")));
            } else {
                forbiddenConcepts = defaultForbiddenConcepts;
            }
            boolean checkCycle = true;
            if ("false".equalsIgnoreCase(strCheckCycle) || "no".equalsIgnoreCase(strCheckCycle)) {
                checkCycle = false;
            }
            if (!Strings.isNullOrEmpty((String)name) && !Strings.isNullOrEmpty((String)conceptGraphQuery)) {
                ((ConceptDao)KernelContextHolder.getApplicationContext().getBean(ConceptDao.class)).createConceptGraph(fDir != null ? fDir.getAbsolutePath() : null, name, conceptGraphQuery, checkCycle, forbiddenConcepts);
            } else {
                ConceptDaoImpl.printHelp(options);
            }
        }
        catch (ParseException pe) {
            ConceptDaoImpl.printHelp(options);
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + ConceptDaoImpl.class.getName() + " generate concept graph", options);
    }

    private void addRelation(ConceptGraph cg, Set<String> roots, String childCUI, String parentCUI, boolean checkCycle, Set<String> forbiddenConcepts) {
        if (forbiddenConcepts.contains(childCUI) || forbiddenConcepts.contains(parentCUI)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("skipping relation because of forbidden concept: par=" + parentCUI + " child=" + childCUI));
            }
            return;
        }
        if (!childCUI.equals(parentCUI)) {
            boolean bCycle;
            ConcRel crChild;
            boolean parNull = false;
            ConcRel crPar = cg.getConceptMap().get(parentCUI);
            if (crPar == null) {
                parNull = true;
                crPar = cg.addConcept(parentCUI);
                roots.add(parentCUI);
            }
            if ((crChild = cg.getConceptMap().get(childCUI)) != null && crPar.getChildren().contains(crChild)) {
                return;
            }
            boolean bl = bCycle = !parNull && crChild != null && checkCycle && this.checkCycle(crPar, crChild);
            if (bCycle) {
                log.warn((Object)("skipping relation that induces cycle: par=" + parentCUI + ", child=" + childCUI));
            } else {
                if (crChild == null) {
                    crChild = cg.addConcept(childCUI);
                } else if (roots.contains(childCUI)) {
                    roots.remove(childCUI);
                }
                crPar.getChildren().add(crChild);
                crChild.getParents().add(crPar);
            }
        }
    }

    @Override
    public void createConceptGraph(String dir, String name, String query, final boolean checkCycle, final Set<String> forbiddenConcepts) throws IOException {
        ConceptGraph conceptGraph = this.readConceptGraph(name);
        if (conceptGraph != null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"createConceptGraph(): concept graph already exists, will not create a new one.  Delete existing concept graph if you want to recreate it.");
            }
        } else {
            String outputDir = dir;
            if (Strings.isNullOrEmpty((String)outputDir)) {
                outputDir = this.getDefaultConceptGraphDir();
            }
            if (Strings.isNullOrEmpty((String)outputDir)) {
                throw new IllegalArgumentException("could not determine default concept graph directory; please set property org.apache.ctakes.ytex.conceptGraphDir");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"createConceptGraph(): file not found, creating concept graph from database.");
            }
            final ConceptGraph cg = new ConceptGraph();
            final HashSet roots = new HashSet();
            this.jdbcTemplate.query(query, new RowCallbackHandler(){
                int nRowsProcessed = 0;

                public void processRow(ResultSet rs) throws SQLException {
                    String child = rs.getString(1);
                    String parent = rs.getString(2);
                    ConceptDaoImpl.this.addRelation(cg, roots, child, parent, checkCycle, forbiddenConcepts);
                    ++this.nRowsProcessed;
                    if (this.nRowsProcessed % 10000 == 0) {
                        log.info((Object)("processed " + this.nRowsProcessed + " edges"));
                    }
                }
            });
            String rootId = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("roots: " + roots));
            }
            if (roots.size() == 1) {
                rootId = (String)roots.iterator().next();
            } else {
                rootId = System.getProperty("org.apache.ctakes.ytex.defaultRootId", DEFAULT_ROOT_ID);
                ConcRel crRoot = cg.addConcept(rootId);
                for (String crChildId : roots) {
                    ConcRel crChild = cg.getConceptMap().get(crChildId);
                    crRoot.getChildren().add(crChild);
                    crChild.getParents().add(crRoot);
                }
            }
            cg.setRoot(rootId);
            if (checkCycle) {
                log.info((Object)("computing intrinsic info for concept graph: " + name));
                this.intrinsicInfoContentEvaluator.evaluateIntrinsicInfoContent(name, outputDir, cg);
            }
            this.writeConceptGraph(outputDir, name, cg);
        }
    }

    @Override
    public ConceptGraph getConceptGraph(String name) {
        ConceptGraph cg = this.readConceptGraph(name);
        if (cg != null) {
            this.initializeConceptGraph(cg);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("concept graph %s, vertices: %s", name, cg.getConceptList().size()));
            }
        }
        return cg;
    }

    private File urlToFile(URL url) {
        if (url != null && "file".equals(url.getProtocol())) {
            File f;
            try {
                f = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                f = new File(url.getPath());
            }
            return f;
        }
        return null;
    }

    public String getDefaultConceptGraphDir() {
        File baseDir;
        URL url;
        File f;
        String cdir = System.getProperty("org.apache.ctakes.ytex.conceptGraphDir", this.ytexProperties.getProperty("org.apache.ctakes.ytex.conceptGraphDir"));
        if (Strings.isNullOrEmpty((String)cdir) && (f = this.urlToFile(url = this.getClass().getResource("/org/apache/ctakes/ytex/ytex.properties"))) != null && (baseDir = f.getParentFile()).exists() && baseDir.isDirectory()) {
            cdir = baseDir.getAbsolutePath() + File.separator + "conceptGraph";
        }
        return cdir;
    }

    public DataSource getDataSource(DataSource ds) {
        return this.jdbcTemplate.getDataSource();
    }

    public IntrinsicInfoContentEvaluator getIntrinsicInfoContentEvaluator() {
        return this.intrinsicInfoContentEvaluator;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Properties getYtexProperties() {
        return this.ytexProperties;
    }

    private boolean checkCycle(ConcRel crPar, ConcRel crChild) {
        TIntHashSet visitedNodes = new TIntHashSet();
        return this.hasAncestor(crPar, crChild, (TIntSet)visitedNodes);
    }

    private boolean hasAncestor(ConcRel crPar, ConcRel crChild, TIntSet visitedNodes) {
        if (visitedNodes.contains(crPar.getNodeIndex())) {
            return false;
        }
        if (crPar.getNodeIndex() == crChild.getNodeIndex()) {
            return true;
        }
        for (ConcRel c : crPar.getParents()) {
            if (!this.hasAncestor(c, crChild, visitedNodes)) continue;
            return true;
        }
        visitedNodes.add(crPar.getNodeIndex());
        return false;
    }

    private ConceptGraph initializeConceptGraph(ConceptGraph cg) {
        ImmutableMap.Builder mb = new ImmutableMap.Builder();
        for (ConcRel cr : cg.getConceptList()) {
            if (cg.getDepthMax() > 0) {
                cr.constructRel(cg.getConceptList());
            }
            mb.put((Object)cr.getConceptID(), (Object)cr);
        }
        cg.setConceptMap((Map<String, ConcRel>)mb.build());
        return cg;
    }

    private ConceptGraph readConceptGraph(String name) {
        ObjectInputStream is = null;
        try {
            ConceptGraph conceptGraph;
            InputStream resIs = this.getClass().getClassLoader().getResourceAsStream(CONCEPT_GRAPH_PATH + name + ".gz");
            if (resIs == null) {
                String cdir = this.getDefaultConceptGraphDir();
                if (cdir == null) {
                    throw new IllegalArgumentException("could not determine default concept graph directory; please set property org.apache.ctakes.ytex.conceptGraphDir");
                }
                File f = new File(cdir + "/" + name + ".gz");
                log.info((Object)("could not load conceptGraph from classpath, attempt to load from: " + f.getAbsolutePath()));
                if (f.exists()) {
                    resIs = new FileInputStream(f);
                } else {
                    log.info((Object)(f.getAbsolutePath() + " not found, cannot load concept graph"));
                }
            } else {
                log.info((Object)("loading concept graph from " + this.getClass().getClassLoader().getResource(CONCEPT_GRAPH_PATH + name + ".gz")));
            }
            if (resIs != null) {
                is = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(resIs)));
                conceptGraph = (ConceptGraph)is.readObject();
                return conceptGraph;
            }
            log.info((Object)("could not load conceptGraph: " + name));
            conceptGraph = null;
            return conceptGraph;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setDataSource(DataSource ds) {
        this.jdbcTemplate = new JdbcTemplate(ds);
    }

    public void setIntrinsicInfoContentEvaluator(IntrinsicInfoContentEvaluator intrinsicInfoContentEvaluator) {
        this.intrinsicInfoContentEvaluator = intrinsicInfoContentEvaluator;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setYtexProperties(Properties ytexProperties) {
        this.ytexProperties = new Properties(ytexProperties);
        this.ytexProperties.putAll((Map<?, ?>)System.getProperties());
    }

    private void writeConceptGraph(String dir, String name, ConceptGraph cg) {
        ObjectOutputStream os = null;
        String outputDir = dir;
        File cgFile = new File(outputDir + "/" + name + ".gz");
        log.info((Object)("writing concept graph: " + cgFile.getAbsolutePath()));
        if (!cgFile.getParentFile().exists()) {
            cgFile.getParentFile().mkdirs();
        }
        try {
            os = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(cgFile))));
            cg.setConceptList((List<ConcRel>)ImmutableList.copyOf(cg.getConceptList()));
            os.writeObject(cg);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        log = LogFactory.getLog(ConceptDaoImpl.class);
        defaultForbiddenConcepts = new HashSet<String>();
        defaultForbiddenConcepts.addAll(Arrays.asList(defaultForbiddenConceptArr));
    }
}

