/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.evaluator;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.dao.DBUtil;
import org.apache.ctakes.ytex.kernel.dao.KernelEvaluationDao;
import org.apache.ctakes.ytex.kernel.evaluator.CorpusKernelEvaluator;
import org.apache.ctakes.ytex.kernel.evaluator.Kernel;
import org.apache.ctakes.ytex.kernel.model.KernelEvaluation;
import org.apache.ctakes.ytex.kernel.model.KernelEvaluationInstance;
import org.apache.ctakes.ytex.kernel.tree.InstanceTreeBuilder;
import org.apache.ctakes.ytex.kernel.tree.Node;
import org.apache.ctakes.ytex.kernel.tree.TreeMappingInfo;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class CorpusKernelEvaluatorImpl
implements CorpusKernelEvaluator {
    private static final Log log = LogFactory.getLog(CorpusKernelEvaluator.class);
    private DataSource dataSource;
    private String experiment;
    private int foldId = 0;
    private String instanceIDQuery;
    private Kernel instanceKernel;
    private InstanceTreeBuilder instanceTreeBuilder;
    private JdbcTemplate jdbcTemplate;
    private KernelEvaluationDao kernelEvaluationDao;
    private String label = DBUtil.getEmptyString();
    private String name;
    private double param1 = 0.0;
    private String param2 = DBUtil.getEmptyString();
    private SimpleJdbcTemplate simpleJdbcTemplate;
    private PlatformTransactionManager transactionManager;
    private TreeMappingInfo treeMappingInfo;
    private TransactionTemplate txTemplate;

    private static Options initOptions() {
        Options options = new Options();
        OptionBuilder.withArgName((String)"classpath*:simSvcBeanRefContext.xml");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use specified beanRefContext.xml, default classpath*:simSvcBeanRefContext.xml");
        options.addOption(OptionBuilder.create((String)"beanref"));
        OptionBuilder.withArgName((String)"kernelApplicationContext");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use specified applicationContext, default kernelApplicationContext");
        options.addOption(OptionBuilder.create((String)"appctx"));
        OptionBuilder.withArgName((String)"beans-corpus.xml");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use specified beans.xml, no default.  This file is typically required.");
        options.addOption(OptionBuilder.create((String)"beans"));
        OptionBuilder.withArgName((String)"yes/no");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"should test instances be evaluated? default no.");
        options.addOption(OptionBuilder.create((String)"evalTest"));
        OptionBuilder.withArgName((String)"instanceMap.obj");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"load instanceMap from file system instead of from db.  Use after storing instance map.  If not specified will attempt to load from db.");
        options.addOption(OptionBuilder.create((String)"loadInstanceMap"));
        OptionBuilder.withDescription((String)"for parallelization, split the instances into mod slices");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"mod"));
        OptionBuilder.withDescription((String)"for parallelization, parameter that determines which slice we work on.  If this is not specified, nMod threads will be started to evaluate all slices in parallel.");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"slice"));
        options.addOption(new Option("help", "print this message"));
        return options;
    }

    public static void main(String[] args) throws Exception {
        Options options = CorpusKernelEvaluatorImpl.initOptions();
        if (args.length == 0) {
            CorpusKernelEvaluatorImpl.printHelp(options);
        } else {
            GnuParser parser = new GnuParser();
            try {
                ApplicationContext appCtx;
                CommandLine line = parser.parse(options, args);
                String beanRefContext = line.getOptionValue("beanref", "classpath*:simSvcBeanRefContext.xml");
                String contextName = line.getOptionValue("appctx", "kernelApplicationContext");
                String beans = line.getOptionValue("beans");
                ApplicationContext appCtxSource = appCtx = (ApplicationContext)ContextSingletonBeanFactoryLocator.getInstance((String)beanRefContext).useBeanFactory(contextName).getFactory();
                if (beans != null) {
                    appCtxSource = new FileSystemXmlApplicationContext(new String[]{beans}, appCtx);
                }
                CorpusKernelEvaluatorImpl.evalKernel(appCtxSource, line);
            }
            catch (ParseException e) {
                CorpusKernelEvaluatorImpl.printHelp(options);
                throw e;
            }
        }
    }

    private static void evalKernel(ApplicationContext appCtxSource, CommandLine line) throws Exception {
        InstanceTreeBuilder builder = (InstanceTreeBuilder)appCtxSource.getBean(InstanceTreeBuilder.class);
        CorpusKernelEvaluator corpusEvaluator = (CorpusKernelEvaluator)appCtxSource.getBean(CorpusKernelEvaluator.class);
        String loadInstanceMap = line.getOptionValue("loadInstanceMap");
        String strMod = line.getOptionValue("mod");
        String strSlice = line.getOptionValue("slice");
        boolean evalTest = "yes".equalsIgnoreCase(line.getOptionValue("evalTest", "no")) || "true".equalsIgnoreCase(line.getOptionValue("evalTest", "no"));
        int nMod = strMod != null ? Integer.parseInt(strMod) : 0;
        Integer nSlice = null;
        if (nMod == 0) {
            nSlice = 0;
        } else if (strSlice != null) {
            nSlice = Integer.parseInt(strSlice);
        }
        Map<Long, Node> instanceMap = null;
        instanceMap = loadInstanceMap != null ? builder.loadInstanceTrees(loadInstanceMap) : builder.loadInstanceTrees((TreeMappingInfo)appCtxSource.getBean(TreeMappingInfo.class));
        if (nSlice != null) {
            corpusEvaluator.evaluateKernelOnCorpus(instanceMap, nMod, nSlice, evalTest);
        } else {
            corpusEvaluator.evaluateKernelOnCorpus(instanceMap, nMod, evalTest);
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java org.apache.ctakes.ytex.kernel.evaluator.CorpusKernelEvaluatorImpl", options);
    }

    private void evalInstance(Map<Long, Node> instanceIDMap, KernelEvaluation kernelEvaluation, long instanceId1, SortedSet<Long> rightDocumentIDs) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("left: " + instanceId1 + ", right: " + rightDocumentIDs));
        }
        Iterator i$ = rightDocumentIDs.iterator();
        while (i$.hasNext()) {
            long instanceId2 = (Long)i$.next();
            long i1 = instanceId1;
            long i2 = instanceId2;
            Node root1 = instanceIDMap.get(i1);
            Node root2 = instanceIDMap.get(i2);
            if (root1 == null || root2 == null) continue;
            this.kernelEvaluationDao.storeKernel(kernelEvaluation, i1, i2, this.instanceKernel.evaluate(root1, root2));
        }
    }

    @Override
    public void evaluateKernelOnCorpus() {
        Map<Long, Node> instanceIDMap = this.instanceTreeBuilder.loadInstanceTrees(this.treeMappingInfo);
        this.evaluateKernelOnCorpus(instanceIDMap, 0, 0, false);
    }

    @Override
    public void evaluateKernelOnCorpus(Map<Long, Node> instanceIDMap, int nMod, boolean evalTest) throws InterruptedException {
        ExecutorService svc = Executors.newFixedThreadPool(nMod);
        ArrayList<SliceEvaluator> taskList = new ArrayList<SliceEvaluator>(nMod);
        for (int nSlice = 1; nSlice <= nMod; ++nSlice) {
            taskList.add(new SliceEvaluator(instanceIDMap, nMod, nSlice, evalTest));
        }
        svc.invokeAll(taskList);
        svc.shutdown();
        svc.awaitTermination(240L, TimeUnit.MINUTES);
    }

    @Override
    public void evaluateKernelOnCorpus(final Map<Long, Node> instanceIDMap, int nMod, int nSlice, boolean evalTest) {
        KernelEvaluation kernelEvaluationTmp = new KernelEvaluation();
        kernelEvaluationTmp.setExperiment(this.getExperiment());
        kernelEvaluationTmp.setFoldId(this.getFoldId());
        kernelEvaluationTmp.setLabel(this.getLabel());
        kernelEvaluationTmp.setCorpusName(this.getName());
        kernelEvaluationTmp.setParam1(this.getParam1());
        kernelEvaluationTmp.setParam2(this.getParam2());
        final KernelEvaluation kernelEvaluation = this.kernelEvaluationDao.storeKernelEval(kernelEvaluationTmp);
        ArrayList<Long> documentIds = new ArrayList<Long>();
        ArrayList<Long> testDocumentIds = new ArrayList<Long>();
        this.loadDocumentIds(documentIds, testDocumentIds, this.instanceIDQuery);
        if (!evalTest) {
            testDocumentIds.clear();
        }
        int nStart = 0;
        int nEnd = documentIds.size();
        int total = documentIds.size();
        if (nMod > 0) {
            nMod = Math.min(total, nMod);
        }
        if (nMod > 0 && nSlice > nMod) {
            log.info((Object)("more slices than documents, skipping slice: " + nSlice));
            return;
        }
        if (nMod > 0) {
            int sliceSize = total / nMod;
            nStart = sliceSize * (nSlice - 1);
            if (nSlice != nMod) {
                nEnd = nStart + sliceSize;
            }
        }
        for (int i = nStart; i < nEnd; ++i) {
            final long instanceId1 = (Long)documentIds.get(i);
            if (log.isInfoEnabled()) {
                log.info((Object)("evaluating kernel for instance_id1 = " + instanceId1));
            }
            final TreeSet<Long> rightDocumentIDs = new TreeSet<Long>(testDocumentIds);
            if (i < documentIds.size()) {
                rightDocumentIDs.addAll(documentIds.subList(i, documentIds.size()));
            }
            for (KernelEvaluationInstance kEval : this.kernelEvaluationDao.getAllKernelEvaluationsForInstance(kernelEvaluation, instanceId1)) {
                rightDocumentIDs.remove(instanceId1 == kEval.getInstanceId1() ? kEval.getInstanceId2() : kEval.getInstanceId1());
            }
            this.txTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus arg0) {
                    CorpusKernelEvaluatorImpl.this.evalInstance(instanceIDMap, kernelEvaluation, instanceId1, rightDocumentIDs);
                    return null;
                }
            });
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getExperiment() {
        return this.experiment;
    }

    public int getFoldId() {
        return this.foldId;
    }

    public String getInstanceIDQuery() {
        return this.instanceIDQuery;
    }

    public Kernel getInstanceKernel() {
        return this.instanceKernel;
    }

    public InstanceTreeBuilder getInstanceTreeBuilder() {
        return this.instanceTreeBuilder;
    }

    public KernelEvaluationDao getKernelEvaluationDao() {
        return this.kernelEvaluationDao;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public double getParam1() {
        return this.param1;
    }

    public String getParam2() {
        return this.param2;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public TreeMappingInfo getTreeMappingInfo() {
        return this.treeMappingInfo;
    }

    private void loadDocumentIds(final List<Long> documentIds, final List<Long> testDocumentIds, final String instanceIDQuery) {
        this.txTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public List<Integer> doInTransaction(TransactionStatus arg0) {
                CorpusKernelEvaluatorImpl.this.jdbcTemplate.query(instanceIDQuery, new RowCallbackHandler(){
                    Boolean trainFlag = null;

                    public void processRow(ResultSet rs) throws SQLException {
                        int train;
                        if (this.trainFlag == null) {
                            this.trainFlag = rs.getMetaData().getColumnCount() == 2;
                        }
                        long id = rs.getLong(1);
                        int n = train = this.trainFlag != false ? rs.getInt(2) : 1;
                        if (train != 0) {
                            documentIds.add(id);
                        } else {
                            testDocumentIds.add(id);
                        }
                    }
                });
                return null;
            }
        });
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    public void setExperiment(String experiment) {
        this.experiment = experiment;
    }

    public void setFoldId(int foldId) {
        this.foldId = foldId;
    }

    public void setInstanceIDQuery(String instanceIDQuery) {
        this.instanceIDQuery = instanceIDQuery;
    }

    public void setInstanceKernel(Kernel instanceKernel) {
        this.instanceKernel = instanceKernel;
    }

    public void setInstanceTreeBuilder(InstanceTreeBuilder instanceTreeBuilder) {
        this.instanceTreeBuilder = instanceTreeBuilder;
    }

    public void setKernelEvaluationDao(KernelEvaluationDao kernelEvaluationDao) {
        this.kernelEvaluationDao = kernelEvaluationDao;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParam1(double param1) {
        this.param1 = param1;
    }

    public void setParam2(String param2) {
        this.param2 = param2;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        this.txTemplate = new TransactionTemplate(this.transactionManager);
        this.txTemplate.setPropagationBehavior(3);
    }

    public void setTreeMappingInfo(TreeMappingInfo treeMappingInfo) {
        this.treeMappingInfo = treeMappingInfo;
    }

    public class SliceEvaluator
    implements Callable<Object> {
        Map<Long, Node> instanceIDMap;
        int nMod;
        int nSlice;
        boolean evalTest;

        public SliceEvaluator(Map<Long, Node> instanceIDMap, int nMod, int nSlice, boolean evalTest) {
            this.nSlice = nSlice;
            this.nMod = nMod;
            this.instanceIDMap = instanceIDMap;
            this.evalTest = evalTest;
        }

        @Override
        public Object call() throws Exception {
            try {
                CorpusKernelEvaluatorImpl.this.evaluateKernelOnCorpus(this.instanceIDMap, this.nMod, this.nSlice, this.evalTest);
            }
            catch (Exception e) {
                log.error((Object)("error on slice: " + this.nSlice), (Throwable)e);
                throw e;
            }
            return null;
        }
    }

    protected class InstanceIDRowMapper
    implements RowMapper<Integer> {
        protected InstanceIDRowMapper() {
        }

        public Integer mapRow(ResultSet rs, int arg1) throws SQLException {
            return rs.getInt(1);
        }
    }
}

