/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.metric;

import java.util.Map;
import org.apache.ctakes.ytex.kernel.metric.BaseSimilarityMetric;
import org.apache.ctakes.ytex.kernel.metric.ConceptSimilarityService;
import org.apache.ctakes.ytex.kernel.metric.SimilarityInfo;

public class WuPalmerMetric
extends BaseSimilarityMetric {
    @Override
    public double similarity(String concept1, String concept2, Map<String, Double> conceptFilter, SimilarityInfo simInfo) {
        this.initLCSes(concept1, concept2, simInfo);
        if (simInfo.getLcses().size() > 0) {
            int lcsDepth = 0;
            for (String lcs : simInfo.getLcses()) {
                int d = this.simSvc.getDepth(lcs);
                if (d <= lcsDepth) continue;
                lcsDepth = d;
            }
            double lcsDepth2 = lcsDepth * 2;
            return lcsDepth2 / (lcsDepth2 + (double)(simInfo.getLcsDist() - 1));
        }
        return 0.0;
    }

    public WuPalmerMetric(ConceptSimilarityService simSvc) {
        super(simSvc);
    }
}

