/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.pagerank;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.KernelContextHolder;
import org.apache.ctakes.ytex.kernel.dao.ConceptDao;
import org.apache.ctakes.ytex.kernel.model.ConcRel;
import org.apache.ctakes.ytex.kernel.model.ConceptGraph;
import org.apache.ctakes.ytex.kernel.pagerank.PageRankService;

public class PageRankServiceImpl
implements PageRankService {
    private static final Log log = LogFactory.getLog(PageRankServiceImpl.class);

    private double[] rankInternal(Map<Integer, Double> dampingVector, ConceptGraph cg, int iter, double threshold, double dampingFactor) {
        Map<Integer, Double> scoreMapCurrent = dampingVector;
        double N = cg.getConceptList().size();
        double[] scoresCurrent = new double[cg.getConceptList().size()];
        double diff = 1.0;
        for (int i = 0; i < iter; ++i) {
            double d;
            double[] scoresOld = scoresCurrent;
            long timeBegin = 0L;
            if (log.isDebugEnabled()) {
                timeBegin = System.currentTimeMillis();
            }
            scoresCurrent = this.pagerankIter(scoresOld, dampingVector, cg, dampingFactor, N);
            if (log.isDebugEnabled()) {
                log.debug((Object)("iter " + i + " " + Long.toString(System.currentTimeMillis() - timeBegin)));
            }
            diff = this.difference(scoresOld, scoresCurrent);
            if (d <= threshold) break;
        }
        if (log.isDebugEnabled() && diff > threshold) {
            log.debug((Object)("did not converge, diff = " + diff + ", dampingVector = " + dampingVector));
        }
        return scoresCurrent;
    }

    private <T> double difference(Map<T, Double> a, Map<T, Double> b) {
        double diff = 0.0;
        for (Map.Entry<T, Double> aiEntry : a.entrySet()) {
            Double bi = b.get(aiEntry.getKey());
            diff += Math.pow(aiEntry.getValue() - (bi != null ? bi : 0.0), 2.0);
        }
        for (Map.Entry<T, Double> biEntry : b.entrySet()) {
            if (a.containsKey(biEntry.getKey())) continue;
            diff += Math.pow(biEntry.getValue(), 2.0);
        }
        return diff;
    }

    private double difference(double[] u, double[] v) {
        double diff = 0.0;
        for (int i = 0; i < u.length; ++i) {
            double d = u[i] - v[i];
            diff += d * d;
        }
        return Math.sqrt(diff);
    }

    private double cosine(double[] u, double[] v) {
        double uu = 0.0;
        double vv = 0.0;
        double uv = 0.0;
        for (int i = 0; i < u.length; ++i) {
            uu += u[i] * u[i];
            vv += v[i] * v[i];
            uv += u[i] * v[i];
        }
        return uv / Math.sqrt(uu * vv);
    }

    public double[] pagerankIter(double[] currentScores, Map<Integer, Double> dampingVector, ConceptGraph cg, double dampingFactor, double N, Set<Integer> activeNodes) {
        double[] newScores = new double[(int)N];
        Arrays.fill(newScores, 0.0);
        Integer[] activeNodeArr = new Integer[activeNodes.size()];
        activeNodes.toArray(activeNodeArr);
        Integer[] arr$ = activeNodeArr;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int index = arr$[i$];
            double score = currentScores[index];
            ConcRel cr = cg.getConceptList().get(index);
            double nOutlinks = cr.getChildren().size();
            if (!(nOutlinks > 0.0)) continue;
            for (ConcRel crOut : cr.getChildren()) {
                int targetIndex = crOut.getNodeIndex();
                double childScore = newScores[targetIndex];
                newScores[targetIndex] = childScore += score / nOutlinks;
                activeNodes.add(targetIndex);
            }
        }
        for (int index : activeNodes) {
            double adjusted = newScores[index] * dampingFactor;
            Double v_i = dampingVector.get(index);
            if (v_i != null) {
                adjusted += v_i.doubleValue();
            }
            newScores[index] = adjusted;
        }
        return newScores;
    }

    public double[] pagerankIter(double[] currentScores, Map<Integer, Double> dampingVector, ConceptGraph cg, double dampingFactor, double N) {
        double[] newScores = new double[(int)N];
        double jump = (1.0 - dampingFactor) / N;
        for (int i = 0; i < currentScores.length; ++i) {
            double score = 0.0;
            ConcRel c = cg.getConceptList().get(i);
            for (int parentIndex : c.getParentsArray()) {
                ConcRel p = cg.getConceptList().get(parentIndex);
                double prIn = currentScores[parentIndex];
                score += prIn / (double)p.getChildrenArray().length;
            }
            if (dampingVector == null) {
                newScores[i] = score * dampingFactor + jump;
                continue;
            }
            double adjusted = score * dampingFactor;
            Double v_i = dampingVector.get(i);
            if (v_i != null) {
                adjusted += v_i.doubleValue();
            }
            newScores[i] = adjusted;
        }
        return newScores;
    }

    @Override
    public double[] rank2(Map<Integer, Double> dampingVector, ConceptGraph cg, int iter, double threshold, double dampingFactor) {
        double N = cg.getConceptMap().size();
        double[] scoresCurrent = new double[cg.getConceptMap().size()];
        HashMap<Integer, Double> dampingVectorAdj = null;
        if (dampingVector != null) {
            dampingVectorAdj = new HashMap<Integer, Double>(dampingVector.size());
            Arrays.fill(scoresCurrent, 0.0);
            for (Map.Entry<Integer, Double> dvEntry : dampingVector.entrySet()) {
                dampingVectorAdj.put(dvEntry.getKey(), dvEntry.getValue() * (1.0 - dampingFactor));
                scoresCurrent[dvEntry.getKey().intValue()] = dvEntry.getValue();
            }
        } else {
            Arrays.fill(scoresCurrent, 1.0 / N);
        }
        double diff = 1.0;
        for (int i = 0; i < iter; ++i) {
            double d;
            double[] scoresOld = scoresCurrent;
            long timeBegin = 0L;
            if (log.isDebugEnabled()) {
                timeBegin = System.currentTimeMillis();
            }
            scoresCurrent = this.pagerankIter(scoresCurrent, dampingVectorAdj, cg, dampingFactor, N);
            if (log.isDebugEnabled()) {
                log.debug((Object)("iter " + i + " time(ms) " + Long.toString(System.currentTimeMillis() - timeBegin)));
            }
            diff = this.difference(scoresCurrent, scoresOld);
            if (d <= threshold) break;
        }
        if (log.isDebugEnabled() && diff > threshold) {
            log.debug((Object)("did not converge, diff = " + diff + ", dampingVector = " + dampingVector));
        }
        return scoresCurrent;
    }

    public Map<Integer, Double> pagerankIter(Map<Integer, Double> currentScores, Map<Integer, Double> dampingVector, ConceptGraph cg, double dampingFactor, double N) {
        HashMap<Integer, Double> newScores = new HashMap<Integer, Double>();
        if (dampingVector == null) {
            double jump = (1.0 - dampingFactor) / N;
            double initialValue = 1.0 / N;
            for (ConcRel c : cg.getConceptList()) {
                double score = 0.0;
                for (ConcRel in : c.getParents()) {
                    double prIn = currentScores == null ? initialValue : currentScores.get(in.getNodeIndex());
                    score += prIn / (double)in.getChildren().size();
                }
                double adjusted = score * dampingFactor + jump;
                newScores.put(c.getNodeIndex(), adjusted);
            }
        } else {
            for (Map.Entry<Integer, Double> entry : currentScores.entrySet()) {
                Integer index = entry.getKey();
                double score = entry.getValue();
                ConcRel cr = cg.getConceptList().get(index);
                double nOutlinks = cr.getChildren().size();
                if (!(nOutlinks > 0.0)) continue;
                for (ConcRel crOut : cr.getChildren()) {
                    double childScore = 0.0;
                    Double childScoreD = (Double)newScores.get(crOut.getNodeIndex());
                    if (childScoreD != null) {
                        childScore = childScoreD;
                    }
                    newScores.put(crOut.getNodeIndex(), childScore += score / nOutlinks);
                }
            }
            for (Map.Entry<Integer, Double> entry : newScores.entrySet()) {
                Double v_i = dampingVector.get(entry.getKey());
                double v_i_adj = v_i != null ? v_i * (1.0 - dampingFactor) : 0.0;
                double adjusted = entry.getValue() * dampingFactor + v_i_adj;
                entry.setValue(adjusted);
            }
        }
        return newScores;
    }

    @Override
    public double sim(String concept1, String concept2, ConceptGraph cg, int iter, double threshold, double dampingFactor) {
        HashMap<Integer, Double> c1dv = new HashMap<Integer, Double>(1);
        ConcRel c1 = cg.getConceptMap().get(concept1);
        ConcRel c2 = cg.getConceptMap().get(concept2);
        if (c1 == null || c2 == null) {
            return 0.0;
        }
        c1dv.put(c1.getNodeIndex(), 1.0);
        double[] c1pr = this.rank2(c1dv, cg, iter, threshold, dampingFactor);
        HashMap<Integer, Double> c2dv = new HashMap<Integer, Double>(1);
        c2dv.put(c2.getNodeIndex(), 1.0);
        double[] c2pr = this.rank2(c2dv, cg, iter, threshold, dampingFactor);
        return this.cosine(c1pr, c2pr);
    }

    private <T> double cosine(Map<T, Double> u, Map<T, Double> v) {
        double uu = 0.0;
        double uv = 0.0;
        double vv = 0.0;
        if (u.isEmpty() || v.isEmpty()) {
            return 0.0;
        }
        for (Map.Entry<T, Double> uEntry : u.entrySet()) {
            double ui = uEntry.getValue();
            T uC = uEntry.getKey();
            uu += ui * ui;
            Double vi = v.get(uC);
            if (vi == null) continue;
            uv += ui * vi;
        }
        if (uv == 0.0) {
            return 0.0;
        }
        Iterator<Object> i$ = v.values().iterator();
        while (i$.hasNext()) {
            double vi = (Double)i$.next();
            vv += vi * vi;
        }
        return uv / Math.sqrt(vv * uu);
    }

    public static void main(String[] args) {
        Options options = new Options();
        OptionGroup og = new OptionGroup();
        OptionBuilder.withArgName((String)"concept1,concept2");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"compute similarity for specified concept pair");
        og.addOption(OptionBuilder.create((String)"sim"));
        OptionBuilder.withArgName((String)"concept1,concept2,...");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"personalized pagerank vector for specified concepts ");
        og.addOption(OptionBuilder.create((String)"ppr"));
        og.setRequired(true);
        options.addOptionGroup(og);
        try {
            GnuParser parser = new GnuParser();
            CommandLine line = parser.parse(options, args);
            Properties ytexProps = new Properties();
            ytexProps.putAll((Map<?, ?>)((Properties)KernelContextHolder.getApplicationContext().getBean("ytexProperties")));
            ytexProps.putAll((Map<?, ?>)System.getProperties());
            ConceptDao conceptDao = (ConceptDao)KernelContextHolder.getApplicationContext().getBean(ConceptDao.class);
            PageRankService pageRankService = (PageRankService)KernelContextHolder.getApplicationContext().getBean(PageRankService.class);
            ConceptGraph cg = conceptDao.getConceptGraph(ytexProps.getProperty("org.apache.ctakes.ytex.conceptGraphName"));
            if (line.hasOption("sim")) {
                String cs = line.getOptionValue("sim");
                String[] concept = cs.split(",");
                System.out.println(pageRankService.sim(concept[0], concept[1], cg, 30, 1.0E-4, 0.85));
            } else if (line.hasOption("ppr")) {
                String cs = line.getOptionValue("ppr");
                String[] concept = cs.split(",");
                double weight = 1.0 / (double)concept.length;
                HashMap<String, Double> ppv = new HashMap<String, Double>();
                for (String c : concept) {
                    ppv.put(c, weight);
                }
                System.out.println(pageRankService.rank(ppv, cg));
            }
        }
        catch (ParseException pe) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java " + PageRankServiceImpl.class.getName() + " compute personalized page rank or similarity.  used for testing purposes", options);
        }
    }

    @Override
    public double[] rank(Map<String, Double> dampingVector, ConceptGraph cg, int iter, double threshold, double dampingFactor) {
        return null;
    }

    @Override
    public double[] rank(Map<String, Double> dampingVector, ConceptGraph cg) {
        return null;
    }
}

